/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.identity.service;

import io.meeds.social.core.identity.model.UserExportFilter;
import io.meeds.social.core.identity.model.UserExportResult;
import io.meeds.social.core.identity.service.UserExportService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.search.UserSearchService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UserExportServiceTest {
    private static final String EXPORT_ID = "123";
    private static final String DELEGATED_GROUP = "/delegated_group";
    private static final String QUERY_TERM = "abc";
    private static final String USER_NAME_FIELD = "userName";
    private static final String EXPORTED_USER_LINE = "john,John,Doe,john@example.com,TRUE,Internal,/platform/users";
    private static final String USERS_GROUP = "/platform/users";
    private static final String EMAIL = "john@example.com";
    private static final String LAST_NAME = "Doe";
    private static final String FIRST_NAME = "John";
    private static final String TEST_USER1 = "root";
    private static final String TEST_USER2 = "john";
    private static final String EXTERNAL_USER_TYPE = "EXTERNAL";
    @Mock
    private IdentityManager identityManager;
    @Mock
    private UserSearchService userSearchService;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private UserACL userAcl;
    @Mock
    private MembershipHandler membershipHandler;
    @Mock
    private UserHandler userHandler;
    @Mock
    private Identity exoIdentity;
    @Mock
    private ListAccess<User> listAccess;
    @Mock
    private ListAccess<org.exoplatform.social.core.identity.model.Identity> identityListAccess;
    @InjectMocks
    private UserExportService service;

    @Before
    public void setUp() {
        Mockito.when((Object)this.organizationService.getMembershipHandler()).thenReturn((Object)this.membershipHandler);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        this.service.init();
    }

    @After
    public void teardown() {
        this.service.stop();
    }

    @Test
    public void testExportUsers() {
        UserExportFilter filter = new UserExportFilter();
        UserExportResult exportResult = this.service.exportUsers(filter, TEST_USER1);
        Assert.assertNotNull((Object)exportResult);
        Assert.assertNotNull((Object)exportResult.getExportId());
        Assert.assertNotNull((Object)exportResult.retrieveExportPath());
    }

    @Test
    public void testExportUsersWritesCsv() {
        UserExportFilter filter = new UserExportFilter();
        filter.setSortField("title");
        filter.setSortDirection("desc");
        filter.setExcludeCurrentUser(true);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Profile profile = (Profile)Mockito.mock(Profile.class);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)TEST_USER2);
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        Mockito.when((Object)profile.getProperty("firstName")).thenReturn((Object)FIRST_NAME);
        Mockito.when((Object)profile.getProperty("lastName")).thenReturn((Object)LAST_NAME);
        Mockito.when((Object)profile.getEmail()).thenReturn((Object)EMAIL);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)identity.isExternal()).thenReturn((Object)false);
        Identity aclIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER1)).thenReturn((Object)aclIdentity);
        Mockito.when((Object)this.identityManager.getIdentitiesByProfileFilter((String)ArgumentMatchers.eq((Object)"organization"), (ProfileFilter)ArgumentMatchers.any(ProfileFilter.class), ArgumentMatchers.eq((boolean)true))).thenReturn(this.identityListAccess);
        Mockito.when((Object)((org.exoplatform.social.core.identity.model.Identity[])this.identityListAccess.load(0, 10))).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity[]{identity});
        Membership membership = (Membership)Mockito.mock(Membership.class);
        Mockito.when((Object)membership.getGroupId()).thenReturn((Object)USERS_GROUP);
        Mockito.when((Object)this.membershipHandler.findMembershipsByUser(TEST_USER2)).thenReturn(List.of(membership));
        UserExportResult exportResult = this.prepareExportResult();
        this.service.exportUsers(filter, TEST_USER1, exportResult);
        try (FileInputStream in = new FileInputStream(exportResult.retrieveExportPath());){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String header = reader.readLine();
            String line = reader.readLine();
            Assert.assertTrue((boolean)header.contains(USER_NAME_FIELD));
            Assert.assertEquals((Object)EXPORTED_USER_LINE, (Object)line);
        }
    }

    @Test
    public void testGetUsersDelegatedAdmin() {
        UserExportFilter filter = new UserExportFilter();
        filter.setUserType(EXTERNAL_USER_TYPE);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Profile profile = (Profile)Mockito.mock(Profile.class);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)TEST_USER2);
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        Mockito.when((Object)profile.getProperty("firstName")).thenReturn((Object)FIRST_NAME);
        Mockito.when((Object)profile.getProperty("lastName")).thenReturn((Object)LAST_NAME);
        Mockito.when((Object)profile.getEmail()).thenReturn((Object)EMAIL);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)identity.isExternal()).thenReturn((Object)false);
        Membership membership = (Membership)Mockito.mock(Membership.class);
        Mockito.when((Object)membership.getGroupId()).thenReturn((Object)USERS_GROUP);
        Mockito.when((Object)this.membershipHandler.findMembershipsByUser(TEST_USER2)).thenReturn(List.of(membership));
        Identity aclIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER1)).thenReturn((Object)aclIdentity);
        Mockito.when((Object)aclIdentity.isMemberOf("/platform/delegated")).thenReturn((Object)true);
        Mockito.when((Object)aclIdentity.getMemberships()).thenReturn(Collections.singleton(new MembershipEntry(DELEGATED_GROUP, "manager")));
        Mockito.when((Object)this.organizationService.getUserHandler().findUsersByQuery((Query)ArgumentMatchers.any(Query.class), (List)ArgumentMatchers.eq(Collections.singletonList(DELEGATED_GROUP)), (UserStatus)ArgumentMatchers.eq((Object)UserStatus.ENABLED))).thenReturn(this.listAccess);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.listAccess.getSize()).thenReturn((Object)10);
        Mockito.when((Object)((User[])this.listAccess.load(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt()))).thenReturn((Object)new User[]{user});
        Mockito.when((Object)user.getUserName()).thenReturn((Object)TEST_USER2);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(TEST_USER2)).thenReturn((Object)identity);
        UserExportResult exportResult = this.prepareExportResult();
        this.service.exportUsers(filter, TEST_USER1, exportResult);
        try (FileInputStream in = new FileInputStream(exportResult.retrieveExportPath());){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String header = reader.readLine();
            String line = reader.readLine();
            Assert.assertTrue((boolean)header.contains(USER_NAME_FIELD));
            Assert.assertEquals((Object)EXPORTED_USER_LINE, (Object)line);
        }
    }

    @Test
    public void testDownloadUsersExportSuccess() {
        UserExportResult result = new UserExportResult();
        result.setUsername(TEST_USER1);
        File tempFile = File.createTempFile("users", ".csv");
        try (FileWriter fw = new FileWriter(tempFile);){
            fw.write("data");
        }
        result.setExportPath(tempFile.getAbsolutePath());
        result.setFinished(true);
        this.service.exportUsersProcessing.put(EXPORT_ID, result);
        try (InputStream in = this.service.downloadUsersExport(EXPORT_ID, TEST_USER1);){
            String content = new BufferedReader(new InputStreamReader(in)).readLine();
            Assert.assertEquals((Object)"data", (Object)content);
        }
    }

    @Test(expected=IllegalAccessException.class)
    public void testDownloadUsersExportWrongUser() throws IllegalAccessException, ObjectNotFoundException {
        UserExportResult result = new UserExportResult();
        result.setUsername(TEST_USER1);
        result.setFinished(true);
        result.setExportPath("/path/to/file");
        this.service.exportUsersProcessing.put(EXPORT_ID, result);
        this.service.downloadUsersExport(EXPORT_ID, TEST_USER2);
    }

    @Test(expected=IllegalStateException.class)
    public void testDownloadUsersExportNotFinished() throws IllegalAccessException, ObjectNotFoundException {
        UserExportResult result = new UserExportResult();
        result.setUsername(TEST_USER1);
        result.setFinished(false);
        this.service.exportUsersProcessing.put(EXPORT_ID, result);
        this.service.downloadUsersExport(EXPORT_ID, TEST_USER1);
    }

    @Test(expected=ObjectNotFoundException.class)
    public void testDownloadUsersExportFileNotFound() throws IllegalAccessException, ObjectNotFoundException {
        UserExportResult result = new UserExportResult();
        result.setUsername(TEST_USER1);
        result.setFinished(true);
        result.setExportPath("missing.csv");
        this.service.exportUsersProcessing.put(EXPORT_ID, result);
        this.service.downloadUsersExport(EXPORT_ID, TEST_USER1);
    }

    @Test
    public void testGetUsersExportResultSuccess() throws IllegalAccessException {
        UserExportResult result = new UserExportResult();
        result.setUsername(TEST_USER1);
        this.service.exportUsersProcessing.put(EXPORT_ID, result);
        Assert.assertEquals((Object)result, (Object)this.service.getUsersExportResult(EXPORT_ID, TEST_USER1));
    }

    @Test(expected=IllegalAccessException.class)
    public void testGetUsersExportResultWrongUser() throws IllegalAccessException {
        UserExportResult result = new UserExportResult();
        result.setUsername(TEST_USER1);
        this.service.exportUsersProcessing.put(EXPORT_ID, result);
        this.service.getUsersExportResult(EXPORT_ID, TEST_USER2);
    }

    @Test
    public void testGetUsersDisabledQuerySearch() {
        UserExportFilter filter = new UserExportFilter();
        filter.setDisabled(true);
        filter.setQuery(QUERY_TERM);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Profile profile = (Profile)Mockito.mock(Profile.class);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)TEST_USER2);
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        Mockito.when((Object)profile.getProperty("firstName")).thenReturn((Object)FIRST_NAME);
        Mockito.when((Object)profile.getProperty("lastName")).thenReturn((Object)LAST_NAME);
        Mockito.when((Object)profile.getEmail()).thenReturn((Object)EMAIL);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)identity.isExternal()).thenReturn((Object)false);
        org.exoplatform.social.core.identity.model.Identity viewerIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(TEST_USER1)).thenReturn((Object)viewerIdentity);
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER1)).thenReturn((Object)this.exoIdentity);
        Mockito.when((Object)this.userAcl.isAdministrator(this.exoIdentity)).thenReturn((Object)true);
        Mockito.when((Object)this.userSearchService.searchUsers(QUERY_TERM, UserStatus.DISABLED)).thenReturn(this.listAccess);
        Mockito.when((Object)this.listAccess.getSize()).thenReturn((Object)1);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getUserName()).thenReturn((Object)TEST_USER2);
        Mockito.when((Object)((User[])this.listAccess.load(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt()))).thenReturn((Object)new User[]{user});
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(TEST_USER2)).thenReturn((Object)((org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class)));
        Membership membership = (Membership)Mockito.mock(Membership.class);
        Mockito.when((Object)membership.getGroupId()).thenReturn((Object)USERS_GROUP);
        Mockito.when((Object)this.membershipHandler.findMembershipsByUser(TEST_USER2)).thenReturn(List.of(membership));
        Mockito.when((Object)this.listAccess.getSize()).thenReturn((Object)10);
        Mockito.when((Object)((User[])this.listAccess.load(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt()))).thenReturn((Object)new User[]{user});
        Mockito.when((Object)user.getUserName()).thenReturn((Object)TEST_USER2);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(TEST_USER2)).thenReturn((Object)identity);
        UserExportResult exportResult = this.prepareExportResult();
        this.service.exportUsers(filter, TEST_USER1, exportResult);
        try (FileInputStream in = new FileInputStream(exportResult.retrieveExportPath());){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String header = reader.readLine();
            String line = reader.readLine();
            Assert.assertTrue((boolean)header.contains(USER_NAME_FIELD));
            Assert.assertEquals((Object)EXPORTED_USER_LINE, (Object)line);
        }
    }

    @Test
    public void testExportIncludedUsers() {
        UserExportFilter filter = new UserExportFilter();
        filter.setIncludeUsers(Collections.singletonList(TEST_USER2));
        filter.setUserType(EXTERNAL_USER_TYPE);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Profile profile = (Profile)Mockito.mock(Profile.class);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)TEST_USER2);
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        Mockito.when((Object)profile.getProperty("firstName")).thenReturn((Object)FIRST_NAME);
        Mockito.when((Object)profile.getProperty("lastName")).thenReturn((Object)LAST_NAME);
        Mockito.when((Object)profile.getEmail()).thenReturn((Object)EMAIL);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)identity.isExternal()).thenReturn((Object)false);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(TEST_USER2)).thenReturn((Object)identity);
        Identity viewerAclIdentity = (Identity)Mockito.mock(Identity.class);
        Identity userAclIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER1)).thenReturn((Object)viewerAclIdentity);
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER2)).thenReturn((Object)userAclIdentity);
        Mockito.when((Object)viewerAclIdentity.isMemberOf("/platform/delegated")).thenReturn((Object)true);
        Mockito.when((Object)viewerAclIdentity.getMemberships()).thenReturn(Collections.singleton(new MembershipEntry(DELEGATED_GROUP, "manager")));
        Mockito.when((Object)userAclIdentity.isMemberOf(DELEGATED_GROUP)).thenReturn((Object)true);
        Membership membership = (Membership)Mockito.mock(Membership.class);
        Mockito.when((Object)membership.getGroupId()).thenReturn((Object)USERS_GROUP);
        Mockito.when((Object)this.membershipHandler.findMembershipsByUser(TEST_USER2)).thenReturn(List.of(membership));
        UserExportResult exportResult = this.prepareExportResult();
        this.service.exportUsers(filter, TEST_USER1, exportResult);
        try (FileInputStream in = new FileInputStream(exportResult.retrieveExportPath());){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String header = reader.readLine();
            String line = reader.readLine();
            Assert.assertTrue((boolean)header.contains(USER_NAME_FIELD));
            Assert.assertEquals((Object)EXPORTED_USER_LINE, (Object)line);
        }
    }

    private UserExportResult prepareExportResult() throws IOException {
        String exportId = UUID.randomUUID().toString();
        File file = Files.createTempFile(String.format("users-%s_", exportId), ".csv", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        UserExportResult exportResult = new UserExportResult();
        exportResult.setExportId(exportId);
        exportResult.setExportPath(file.getAbsolutePath());
        exportResult.setUsername(TEST_USER1);
        return exportResult;
    }
}

