/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.observer.plugin;

import io.meeds.social.observe.plugin.ActivityOberverPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityOberverPluginTest {
    private static final String AUDIENCE_ID = "5543";
    private static final String SPACE_ID = "5743";
    private static final String USER_NAME = "testUser";
    private static final int IDENTITY_ID = 2;
    private static final String OBJECT_ID = "objectId";
    @Mock
    private IdentityRegistry identityRegistry;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private ExoSocialActivity activity;
    @Mock
    private Identity identity;
    @Mock
    private ActivityStream activityStream;
    @Mock
    private org.exoplatform.services.security.Identity aclIdentity;
    ActivityOberverPlugin activityOberverPlugin;

    @Before
    public void setUp() {
        this.activityOberverPlugin = new ActivityOberverPlugin(this.activityManager, this.identityManager, this.organizationService, this.identityRegistry);
        Mockito.when((Object)this.identity.getRemoteId()).thenReturn((Object)USER_NAME);
        Mockito.when((Object)this.activity.getSpaceId()).thenReturn((Object)SPACE_ID);
        Mockito.when((Object)this.activity.getActivityStream()).thenReturn((Object)this.activityStream);
        Mockito.when((Object)this.activityStream.getId()).thenReturn((Object)AUDIENCE_ID);
    }

    @Test
    public void testGetObjectType() {
        Assert.assertEquals((Object)"activity", (Object)this.activityOberverPlugin.getObjectType());
    }

    @Test
    public void testCanObserve() throws ObjectNotFoundException {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.activityOberverPlugin.canObserve(2L, OBJECT_ID));
        Mockito.when((Object)this.activityManager.getActivity(OBJECT_ID)).thenReturn((Object)this.activity);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.activityOberverPlugin.canObserve(2L, OBJECT_ID));
        Mockito.when((Object)this.identityManager.getIdentity(2L)).thenReturn((Object)this.identity);
        Assert.assertThrows(IllegalStateException.class, () -> this.activityOberverPlugin.canObserve(2L, OBJECT_ID));
        Mockito.when((Object)this.identityRegistry.getIdentity(USER_NAME)).thenReturn((Object)this.aclIdentity);
        Assert.assertFalse((boolean)this.activityOberverPlugin.canObserve(2L, OBJECT_ID));
        Mockito.when((Object)this.activityManager.isActivityViewable(this.activity, this.aclIdentity)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.activityOberverPlugin.canObserve(2L, OBJECT_ID));
    }

    @Test
    public void testGetAudienceId() throws ObjectNotFoundException {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.activityOberverPlugin.getAudienceId(OBJECT_ID));
        Mockito.when((Object)this.activityManager.getActivity(OBJECT_ID)).thenReturn((Object)this.activity);
        Assert.assertEquals((long)Long.parseLong(AUDIENCE_ID), (long)this.activityOberverPlugin.getAudienceId(OBJECT_ID));
    }

    @Test
    public void testGetSpaceId() throws ObjectNotFoundException {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.activityOberverPlugin.getSpaceId(OBJECT_ID));
        Mockito.when((Object)this.activityManager.getActivity(OBJECT_ID)).thenReturn((Object)this.activity);
        Assert.assertEquals((long)0L, (long)this.activityOberverPlugin.getSpaceId(OBJECT_ID));
        Mockito.when((Object)this.activityStream.isSpace()).thenReturn((Object)true);
        Assert.assertEquals((long)Long.parseLong(SPACE_ID), (long)this.activityOberverPlugin.getSpaceId(OBJECT_ID));
    }
}

