/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.user.plugin;

import io.meeds.portal.plugin.AclPlugin;
import io.meeds.social.user.plugin.UserAclPlugin;
import java.util.Arrays;
import java.util.HashSet;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UserAclPluginTest {
    private static final String OTHER_USER_NAME = "user1";
    @Mock
    private PortalContainer portalContainer;
    @Mock
    private UserACL userACL;
    @Mock
    private Identity identity;
    @Mock
    private Identity userIdentity;
    @InjectMocks
    private UserAclPlugin plugin;

    @Before
    public void setUp() {
        Mockito.when((Object)((UserACL)this.portalContainer.getComponentInstanceOfType(UserACL.class))).thenReturn((Object)this.userACL);
        this.plugin.init();
    }

    @Test
    public void testInitRegistersPluginWithUserACL() {
        ((PortalContainer)Mockito.verify((Object)this.portalContainer)).getComponentInstanceOfType(UserACL.class);
        ((UserACL)Mockito.verify((Object)this.userACL)).addAclPlugin((AclPlugin)this.plugin);
    }

    @Test
    public void testGetObjectType() {
        Assert.assertEquals((Object)"user", (Object)this.plugin.getObjectType());
    }

    @Test
    public void testHasPermissionReturnsFalseWhenIdentityIsNull() {
        boolean result = this.plugin.hasPermission(OTHER_USER_NAME, "VIEW", null);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testHasPermissionReturnsTrueWhenIdentityIsAdministrator() {
        Mockito.when((Object)this.userACL.isAdministrator(this.identity)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.plugin.hasPermission(OTHER_USER_NAME, "VIEW", this.identity));
    }

    @Test
    public void testHasPermissionReturnsFalseWhenUserIdentityIsNull() {
        Mockito.when((Object)this.userACL.isAdministrator(this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.userACL.getUserIdentity(OTHER_USER_NAME)).thenReturn(null);
        Assert.assertFalse((boolean)this.plugin.hasPermission(OTHER_USER_NAME, "VIEW", this.identity));
    }

    @Test
    public void testHasPermissionReturnsTrueWhenCommonNonExternalGroupExists() {
        Mockito.when((Object)this.userACL.isAdministrator(this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.userACL.getUserIdentity(OTHER_USER_NAME)).thenReturn((Object)this.userIdentity);
        HashSet<String> userGroups = new HashSet<String>(Arrays.asList("/platform/users"));
        HashSet<String> callerGroups = new HashSet<String>(Arrays.asList("/platform/users", "/platform/admin"));
        Mockito.when((Object)this.userIdentity.getGroups()).thenReturn(userGroups);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(callerGroups);
        Assert.assertTrue((boolean)this.plugin.hasPermission(OTHER_USER_NAME, "VIEW", this.identity));
    }

    @Test
    public void testHasPermissionReturnsFalseWhenOnlyCommonGroupIsExternal() {
        Mockito.when((Object)this.userACL.isAdministrator(this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.userACL.getUserIdentity(OTHER_USER_NAME)).thenReturn((Object)this.userIdentity);
        HashSet<String> userGroups = new HashSet<String>(Arrays.asList("/platform/externals", "g1"));
        HashSet<String> callerGroups = new HashSet<String>(Arrays.asList("/platform/externals", "g2"));
        Mockito.when((Object)this.userIdentity.getGroups()).thenReturn(userGroups);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(callerGroups);
        Assert.assertFalse((boolean)this.plugin.hasPermission(OTHER_USER_NAME, "VIEW", this.identity));
    }

    @Test
    public void testHasPermissionReturnsFalseWhenNoCommonGroups() {
        Mockito.when((Object)this.userACL.isAdministrator(this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.userACL.getUserIdentity(OTHER_USER_NAME)).thenReturn((Object)this.userIdentity);
        HashSet<String> userGroups = new HashSet<String>(Arrays.asList("/platform/users"));
        HashSet<String> callerGroups = new HashSet<String>(Arrays.asList("/platform/guests"));
        Mockito.when((Object)this.userIdentity.getGroups()).thenReturn(userGroups);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(callerGroups);
        Assert.assertFalse((boolean)this.plugin.hasPermission(OTHER_USER_NAME, "VIEW", this.identity));
    }
}

