/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.filter;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.exoplatform.social.core.activity.filter.ActivityIterator;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;

public class ActivityIteratorTest
extends TestCase {
    private ActivityIterator ait = null;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ait = null;
    }

    public void testAddMore() throws Exception {
        this.ait = new ActivityIterator(0L, 0L, 0L);
        ActivityIteratorTest.assertFalse((boolean)this.ait.addMore());
    }

    public void testAddOneElement() throws Exception {
        this.ait = new ActivityIterator(0L, 1L, 1L);
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setTitle("title @demo hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertFalse((boolean)this.ait.addMore());
    }

    public void testAddMoreElements() throws Exception {
        this.ait = new ActivityIterator(0L, 2L, 2L);
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setId("id1");
        activity1.setTitle("title @demo hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        activity1 = new ExoSocialActivityImpl();
        activity1.setId("id1");
        activity1.setTitle("title 2 hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        activity1 = new ExoSocialActivityImpl();
        activity1.setId("id3");
        activity1.setTitle("title 3 hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertFalse((boolean)this.ait.addMore());
    }

    public void testAddMoreElementsOffset1() throws Exception {
        this.ait = new ActivityIterator(1L, 2L, 3L);
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setId("id1");
        activity1.setTitle("title @demo hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        activity1 = new ExoSocialActivityImpl();
        activity1.setId("id1");
        activity1.setTitle("title 2 hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        activity1 = new ExoSocialActivityImpl();
        activity1.setId("id3");
        activity1.setTitle("title 3 hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertFalse((boolean)this.ait.addMore());
        ActivityIteratorTest.assertEquals((int)2, (int)this.ait.result().size());
    }

    public void testAddMoreElementsOffset2() throws Exception {
        this.ait = new ActivityIterator(1L, 2L, 3L);
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setId("id1");
        activity1.setTitle("title @demo hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        activity1 = new ExoSocialActivityImpl();
        activity1.setId("id2");
        activity1.setTitle("title 2 hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        activity1 = new ExoSocialActivityImpl();
        activity1.setId("id3");
        activity1.setTitle("title 3 hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertFalse((boolean)this.ait.addMore());
        ActivityIteratorTest.assertEquals((int)2, (int)this.ait.result().size());
    }

    public void testAddMoreElementsOffset3() throws Exception {
        this.ait = new ActivityIterator(3L, 2L, 3L);
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setId("id1");
        activity1.setTitle("title @demo hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        activity1 = new ExoSocialActivityImpl();
        activity1.setId("id2");
        activity1.setTitle("title 2 hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        activity1 = new ExoSocialActivityImpl();
        activity1.setId("id3");
        activity1.setTitle("title 3 hi");
        this.ait.add((ExoSocialActivity)activity1);
        ActivityIteratorTest.assertTrue((boolean)this.ait.addMore());
        ActivityIteratorTest.assertEquals((int)0, (int)this.ait.result().size());
    }

    public void testCalculatorOffset0() throws Exception {
        ArrayList<ExoSocialActivityImpl> activities = new ArrayList<ExoSocialActivityImpl>();
        for (int i = 0; i < 5; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setId("id " + i);
            activity.setTitle("title " + i);
            activity.isComment(false);
            activities.add(activity);
        }
        long offset = 0L;
        long limit = 20L;
        Object var6_6 = null;
        ActivityIterator ait = new ActivityIterator(offset, limit, 5L);
        for (ExoSocialActivity exoSocialActivity : activities) {
            ait.add(exoSocialActivity);
            if (ait.addMore()) continue;
        }
        ActivityIteratorTest.assertEquals((int)5, (int)ait.result().size());
    }

    public void testCalculatorOffsetGreater0() throws Exception {
        ArrayList<ExoSocialActivityImpl> activities = new ArrayList<ExoSocialActivityImpl>();
        for (int i = 0; i < 5; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setId("id " + i);
            activity.setTitle("title " + i);
            activity.isComment(false);
            activities.add(activity);
        }
        long offset = 2L;
        long limit = 20L;
        Object var6_6 = null;
        ActivityIterator ait = new ActivityIterator(offset, limit, 5L);
        for (ExoSocialActivity exoSocialActivity : activities) {
            ait.add(exoSocialActivity);
            if (ait.addMore()) continue;
        }
        ActivityIteratorTest.assertEquals((int)3, (int)ait.result().size());
    }
}

