/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.StreamItemDAO;
import org.exoplatform.social.core.jpa.storage.entity.ActivityEntity;
import org.exoplatform.social.core.jpa.storage.entity.StreamItemEntity;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;

public class ActivityStorageTest
extends AbstractCoreTest {
    private StreamItemDAO streamItemDAO;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private SpaceStorage spaceStorage;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.streamItemDAO = this.getService(StreamItemDAO.class);
        this.spaceStorage = this.getService(SpaceStorage.class);
        ActivityStorageTest.assertNotNull((Object)this.activityStorage);
        this.rootIdentity = this.createIdentity("root");
        this.johnIdentity = this.createIdentity("john");
        this.maryIdentity = this.createIdentity("mary");
        this.demoIdentity = this.createIdentity("demo");
    }

    public void testGetActivitiesByPoster() {
        ExoSocialActivity activity1 = this.createActivity(1);
        activity1.setType("TYPE1");
        this.activityStorage.saveActivity(this.demoIdentity, activity1);
        ExoSocialActivity activity2 = this.createActivity(2);
        activity2.setType("TYPE2");
        this.activityStorage.saveActivity(this.demoIdentity, activity2);
        List activities = this.activityStorage.getActivitiesByPoster(this.demoIdentity, 0, 10);
        ActivityStorageTest.assertEquals((int)2, (int)activities.size());
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNumberOfActivitiesByPoster(this.demoIdentity));
        activities = this.activityStorage.getActivitiesByPoster(this.demoIdentity, 0, 10, new String[]{"TYPE1"});
        ActivityStorageTest.assertEquals((int)1, (int)activities.size());
    }

    public void testSaveActivity() {
        ExoSocialActivity activity = this.createActivity(0);
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        ActivityStorageTest.assertNotNull((Object)activity.getId());
        ExoSocialActivity rs = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertTrue((boolean)Arrays.asList(rs.getLikeIdentityIds()).contains("demo"));
    }

    public void testUpdateActivity() {
        ExoSocialActivity activity = this.createActivity(1);
        ExoSocialActivity activityCreated = this.activityStorage.saveActivity(this.demoIdentity, activity);
        List streamItems = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(Long.parseLong(activityCreated.getId())));
        activityCreated.setTitle("Title after updated");
        this.activityStorage.updateActivity(activityCreated);
        ExoSocialActivity res = this.activityStorage.getActivity(activity.getId());
        List streamItemsRes = this.streamItemDAO.findStreamItemByActivityId(Long.valueOf(Long.parseLong(activityCreated.getId())));
        ActivityStorageTest.assertEquals((Object)((StreamItemEntity)streamItemsRes.get(0)).getUpdatedDate(), (Object)((StreamItemEntity)streamItems.get(0)).getUpdatedDate());
        ActivityStorageTest.assertEquals((String)"Title after updated", (String)res.getTitle());
        String titleUpdated = "Title after updated with character = that should not be encoded";
        activityCreated.setTitle(titleUpdated);
        this.activityStorage.updateActivity(activityCreated);
        ActivityStorageTest.assertEquals((String)titleUpdated, (String)activityCreated.getTitle());
    }

    public void testUpdateComment() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Initial Activity");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("comment");
        comment.setUserId(this.johnIdentity.getId());
        comment.setPosterId(this.johnIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityStorageTest.assertTrue((comment.getPostedTime().longValue() == comment.getUpdated().getTime() ? 1 : 0) != 0);
        this.sleep(1);
        comment.setTitle("comment updated");
        comment.setUpdated(Long.valueOf(new Date().getTime()));
        this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        comment = this.activityStorage.getActivity(comment.getId());
        ActivityStorageTest.assertEquals((String)"comment updated", (String)comment.getTitle());
        ActivityStorageTest.assertTrue((comment.getPostedTime() < comment.getUpdated().getTime() ? 1 : 0) != 0);
    }

    public void testUpdateActivityMention() {
        System.setProperty("gatein.email.domain.url", "test.com");
        ExoSocialActivity activity = this.createActivity(1);
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        activity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertEquals((int)0, (int)activity.getMentionedIds().length);
        String currentDomain = CommonsUtils.getCurrentDomain();
        Object johnExternal = this.johnIdentity.getProfile().getProperty("external");
        Object rootExternal = this.rootIdentity.getProfile().getProperty("external");
        String processedTitle = "test <a class=\"user-suggester\" href=\"" + currentDomain + "/portal/classic/profile/root\" v-identity-popover=\"{id: '" + this.rootIdentity.getId() + "',username: '" + this.rootIdentity.getRemoteId() + "',fullName: '" + this.rootIdentity.getProfile().getFullName() + "',avatar: '" + this.rootIdentity.getProfile().getAvatarUrl() + "',position: '" + StringUtils.trimToEmpty((String)this.rootIdentity.getProfile().getPosition()) + "',external: '" + String.valueOf(rootExternal == null ? "false" : rootExternal) + "',enabled: '" + (this.rootIdentity.isEnable() && !this.rootIdentity.isDeleted()) + "',}\" rel=\"nofollow\" target=\"_self\">" + this.rootIdentity.getProfile().getFullName() + "</a> <a class=\"user-suggester\" href=\"" + currentDomain + "/portal/classic/profile/john\" v-identity-popover=\"{id: '" + this.johnIdentity.getId() + "',username: '" + this.johnIdentity.getRemoteId() + "',fullName: '" + this.johnIdentity.getProfile().getFullName() + "',avatar: '" + this.johnIdentity.getProfile().getAvatarUrl() + "',position: '" + StringUtils.trimToEmpty((String)this.johnIdentity.getProfile().getPosition()) + "',external: '" + String.valueOf(johnExternal == null ? "false" : johnExternal) + "',enabled: '" + (this.johnIdentity.isEnable() && !this.johnIdentity.isDeleted()) + "',}\" rel=\"nofollow\" target=\"_self\">" + this.johnIdentity.getProfile().getFullName() + "</a>";
        activity.setTitle("test @root @john");
        this.activityStorage.updateActivity(activity);
        activity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertEquals((String)processedTitle, (String)StringEscapeUtils.unescapeHtml4((String)activity.getTitle()));
        ActivityStorageTest.assertEquals((int)2, (int)activity.getMentionedIds().length);
        List list = this.activityStorage.getActivities(this.rootIdentity, this.rootIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)1, (int)list.size());
        list = this.activityStorage.getActivities(this.johnIdentity, this.johnIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)1, (int)list.size());
        activity.setTitle("test @root");
        this.activityStorage.updateActivity(activity);
        activity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertEquals((int)1, (int)activity.getMentionedIds().length);
        list = this.activityStorage.getActivities(this.johnIdentity, this.johnIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)0, (int)list.size());
        ExoSocialActivityImpl comment1 = new ExoSocialActivityImpl();
        comment1.setTitle("comment @root @john");
        comment1.setUserId(this.johnIdentity.getId());
        comment1.setPosterId(this.johnIdentity.getId());
        this.activityStorage.saveComment(activity, (ExoSocialActivity)comment1);
        activity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertEquals((int)2, (int)activity.getMentionedIds().length);
        list = this.activityStorage.getActivities(this.rootIdentity, this.rootIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)1, (int)list.size());
        list = this.activityStorage.getActivities(this.johnIdentity, this.johnIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)1, (int)list.size());
        System.clearProperty("gatein.email.domain.url");
    }

    public void testGetUserActivities() {
        ExoSocialActivity activity = this.createActivity(1);
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        List got = this.activityStorage.getUserActivities(this.demoIdentity, 0L, 20L);
        ActivityStorageTest.assertEquals((int)1, (int)got.size());
    }

    public void testGetUserIdsActivities() {
        ExoSocialActivity activity = this.createActivity(1);
        this.activityStorage.saveActivity(this.demoIdentity, activity);
        List got = this.activityStorage.getUserIdsActivities(this.demoIdentity, 0L, 20L);
        ActivityStorageTest.assertEquals((int)1, (int)got.size());
    }

    public void testGetActivitiesByIDs() {
        ExoSocialActivity activity1 = this.createActivity(10);
        this.activityStorage.saveActivity(this.demoIdentity, activity1);
        ExoSocialActivity activity2 = this.createActivity(20);
        this.activityStorage.saveActivity(this.demoIdentity, activity2);
        ExoSocialActivity activity3 = this.createActivity(30);
        this.activityStorage.saveActivity(this.demoIdentity, activity3);
        List got = this.activityStorage.getActivities(Arrays.asList(activity1.getId(), activity2.getId(), activity3.getId()));
        ActivityStorageTest.assertEquals((int)3, (int)got.size());
        ActivityStorageTest.assertEquals((String)activity1.getId(), (String)((ExoSocialActivity)got.get(0)).getId());
        ActivityStorageTest.assertEquals((String)activity2.getId(), (String)((ExoSocialActivity)got.get(1)).getId());
        ActivityStorageTest.assertEquals((String)activity3.getId(), (String)((ExoSocialActivity)got.get(2)).getId());
    }

    public void testGetActivityIdsFeed() {
        this.createActivities(3, this.demoIdentity);
        List got = this.activityStorage.getActivityIdsFeed(this.demoIdentity, 0, 10);
        ActivityStorageTest.assertEquals((int)3, (int)got.size());
    }

    public void testGetSpaceActivityIds() throws Exception {
        Space space = this.getSpaceInstance(0);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        int totalNumber = 5;
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        List got = this.activityStorage.getSpaceActivityIds(spaceIdentity, 0, 10);
        ActivityStorageTest.assertEquals((int)5, (int)got.size());
    }

    public void testGetActivity() {
        ExoSocialActivity activity = this.createActivity(1);
        activity = this.activityStorage.saveActivity(this.demoIdentity, activity);
    }

    public void testGetActivityIdsOfConnections() throws Exception {
        this.createActivities(5, this.johnIdentity);
        RealtimeListAccess demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityStorageTest.assertEquals((int)0, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 10)).length);
        ActivityStorageTest.assertEquals((int)0, (int)demoConnectionActivities.getSize());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.demoIdentity);
        this.createActivities(1, this.johnIdentity);
        RealtimeListAccess got = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityStorageTest.assertEquals((int)7, (int)((ExoSocialActivity[])got.load(0, 10)).length);
        ActivityStorageTest.assertEquals((int)7, (int)got.getSize());
    }

    public void testGetNewerOnUserActivities() {
        this.createActivities(2, this.demoIdentity);
        ExoSocialActivity firstActivity = (ExoSocialActivity)this.activityStorage.getUserActivities(this.demoIdentity, 0L, 10L).get(0);
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNewerOnUserActivities(this.demoIdentity, firstActivity, 10).size());
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNumberOfNewerOnUserActivities(this.demoIdentity, firstActivity));
        this.createActivities(2, this.maryIdentity);
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNewerOnUserActivities(this.demoIdentity, firstActivity, 10).size());
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNumberOfNewerOnUserActivities(this.demoIdentity, firstActivity));
        this.createActivities(2, this.demoIdentity);
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNewerOnUserActivities(this.demoIdentity, firstActivity, 10).size());
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNumberOfNewerOnUserActivities(this.demoIdentity, firstActivity));
    }

    public void testGetOlderOnUserActivities() {
        this.createActivities(2, this.demoIdentity);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityStorage.getUserActivities(this.demoIdentity, 0L, 10L).get(0);
        ActivityStorageTest.assertEquals((int)1, (int)this.activityStorage.getOlderOnUserActivities(this.demoIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)1, (int)this.activityStorage.getNumberOfOlderOnUserActivities(this.demoIdentity, baseActivity));
        this.createActivities(2, this.maryIdentity);
        ActivityStorageTest.assertEquals((int)1, (int)this.activityStorage.getOlderOnUserActivities(this.demoIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)1, (int)this.activityStorage.getNumberOfOlderOnUserActivities(this.demoIdentity, baseActivity));
        this.createActivities(2, this.demoIdentity);
        baseActivity = (ExoSocialActivity)this.activityStorage.getUserActivities(this.demoIdentity, 0L, 10L).get(0);
        ActivityStorageTest.assertEquals((int)3, (int)this.activityStorage.getOlderOnUserActivities(this.demoIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)3, (int)this.activityStorage.getNumberOfOlderOnUserActivities(this.demoIdentity, baseActivity));
    }

    public void testGetNewerOnActivityFeed() {
        this.createActivities(3, this.demoIdentity);
        ExoSocialActivity demoBaseActivity = (ExoSocialActivity)this.activityStorage.getActivityFeed(this.demoIdentity, 0, 10).get(0);
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNewerOnActivityFeed(this.demoIdentity, demoBaseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNumberOfNewerOnActivityFeed(this.demoIdentity, demoBaseActivity));
        this.createActivities(1, this.demoIdentity);
        ActivityStorageTest.assertEquals((int)1, (int)this.activityStorage.getNewerOnActivityFeed(this.demoIdentity, demoBaseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)1, (int)this.activityStorage.getNumberOfNewerOnActivityFeed(this.demoIdentity, demoBaseActivity));
        this.createActivities(2, this.maryIdentity);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        this.createActivities(2, this.maryIdentity);
        ActivityStorageTest.assertEquals((int)7, (int)this.activityStorage.getNewerOnActivityFeed(this.demoIdentity, demoBaseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)7, (int)this.activityStorage.getNumberOfNewerOnActivityFeed(this.demoIdentity, demoBaseActivity));
    }

    public void testGetOlderOnActivityFeed() throws Exception {
        this.createActivities(3, this.demoIdentity);
        this.createActivities(2, this.maryIdentity);
        Relationship maryDemoConnection = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        List demoActivityFeed = this.activityStorage.getActivityFeed(this.demoIdentity, 0, 10);
        ExoSocialActivity baseActivity = (ExoSocialActivity)demoActivityFeed.get(4);
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNumberOfOlderOnActivityFeed(this.demoIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getOlderOnActivityFeed(this.demoIdentity, baseActivity, 10).size());
        this.createActivities(1, this.johnIdentity);
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNumberOfOlderOnActivityFeed(this.demoIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getOlderOnActivityFeed(this.demoIdentity, baseActivity, 10).size());
        baseActivity = (ExoSocialActivity)demoActivityFeed.get(2);
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getNumberOfOlderOnActivityFeed(this.demoIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getOlderOnActivityFeed(this.demoIdentity, baseActivity, 10).size());
    }

    public void testGetNewerOnActivitiesOfConnections() {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        this.createActivities(3, this.maryIdentity);
        this.createActivities(1, this.demoIdentity);
        this.createActivities(2, this.johnIdentity);
        this.createActivities(2, this.rootIdentity);
        List maryActivities = this.activityStorage.getActivitiesOfIdentity(this.maryIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)3, (int)maryActivities.size());
        ExoSocialActivity baseActivity = (ExoSocialActivity)maryActivities.get(1);
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNewerOnActivitiesOfConnections(this.maryIdentity, baseActivity, 10L).size());
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.maryIdentity, baseActivity));
        Relationship maryDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        relationships.add(maryDemoRelationship);
        this.createActivities(1, this.demoIdentity);
        ActivityStorageTest.assertEquals((int)3, (int)this.activityStorage.getNewerOnActivitiesOfConnections(this.maryIdentity, baseActivity, 10L).size());
        ActivityStorageTest.assertEquals((int)3, (int)this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.maryIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNewerOnActivitiesOfConnections(this.demoIdentity, baseActivity, 10L).size());
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.demoIdentity, baseActivity));
        Relationship maryJohnRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.johnIdentity);
        relationships.add(maryJohnRelationship);
        this.createActivities(1, this.johnIdentity);
        ActivityStorageTest.assertEquals((int)7, (int)this.activityStorage.getNewerOnActivitiesOfConnections(this.maryIdentity, baseActivity, 10L).size());
        ActivityStorageTest.assertEquals((int)7, (int)this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.maryIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNewerOnActivitiesOfConnections(this.johnIdentity, baseActivity, 10L).size());
        ActivityStorageTest.assertEquals((int)2, (int)this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.johnIdentity, baseActivity));
        Relationship maryRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        relationships.add(maryRootRelationship);
        this.createActivities(1, this.rootIdentity);
        ActivityStorageTest.assertEquals((int)10, (int)this.activityStorage.getNewerOnActivitiesOfConnections(this.maryIdentity, baseActivity, 10L).size());
        ActivityStorageTest.assertEquals((int)11, (int)this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.maryIdentity, baseActivity));
    }

    public void testGetOlderOnActivitiesOfConnections() {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        this.createActivities(3, this.maryIdentity);
        this.createActivities(1, this.demoIdentity);
        this.createActivities(2, this.johnIdentity);
        this.createActivities(2, this.rootIdentity);
        List maryActivities = this.activityStorage.getActivitiesOfIdentity(this.maryIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)3, (int)maryActivities.size());
        ExoSocialActivity baseActivity = (ExoSocialActivity)maryActivities.get(2);
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getOlderOnActivitiesOfConnections(this.maryIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.maryIdentity, baseActivity));
        Relationship maryDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        relationships.add(maryDemoRelationship);
        baseActivity = (ExoSocialActivity)this.activityStorage.getActivitiesOfIdentity(this.demoIdentity, 0L, 10L).get(0);
        this.LOG.info((Object)("demo::sinceTime = " + baseActivity.getPostedTime()));
        ActivityStorageTest.assertEquals((int)1, (int)this.activityStorage.getOlderOnActivitiesOfConnections(this.maryIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)1, (int)this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.maryIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getOlderOnActivitiesOfConnections(this.demoIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.demoIdentity, baseActivity));
        Relationship maryJohnRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.johnIdentity);
        relationships.add(maryJohnRelationship);
        baseActivity = (ExoSocialActivity)this.activityStorage.getActivitiesOfIdentity(this.johnIdentity, 0L, 10L).get(0);
        this.LOG.info((Object)("john::sinceTime = " + baseActivity.getPostedTime()));
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getOlderOnActivitiesOfConnections(this.maryIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.maryIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getOlderOnActivitiesOfConnections(this.johnIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.johnIdentity, baseActivity));
        Relationship maryRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        relationships.add(maryRootRelationship);
        baseActivity = (ExoSocialActivity)this.activityStorage.getActivitiesOfIdentity(this.rootIdentity, 0L, 10L).get(0);
        this.LOG.info((Object)("root::sinceTime = " + baseActivity.getPostedTime()));
        ActivityStorageTest.assertEquals((int)7, (int)this.activityStorage.getOlderOnActivitiesOfConnections(this.maryIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)7, (int)this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.maryIdentity, baseActivity));
    }

    public void testGetNewerOnUserSpacesActivities() throws Exception {
        Space space = this.getSpaceInstance(0);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        int totalNumber = 10;
        ExoSocialActivityImpl baseActivity = null;
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityStorage.saveActivity(spaceIdentity, (ExoSocialActivity)activity);
            this.sleep(1);
            if (i != 0) continue;
            baseActivity = activity;
        }
        ActivityStorageTest.assertEquals((int)9, (int)this.activityStorage.getNewerOnUserSpacesActivities(this.demoIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)9, (int)this.activityStorage.getNumberOfNewerOnUserSpacesActivities(this.demoIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)9, (int)this.activityStorage.getNewerOnSpaceActivities(spaceIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)9, (int)this.activityStorage.getNumberOfNewerOnSpaceActivities(spaceIdentity, (ExoSocialActivity)baseActivity));
        Space space2 = this.getSpaceInstance(1);
        Identity spaceIdentity2 = this.identityManager.getOrCreateIdentity("space", space2.getPrettyName(), false);
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityStorage.saveActivity(spaceIdentity2, (ExoSocialActivity)activity);
            this.sleep(1);
        }
        ActivityStorageTest.assertEquals((int)19, (int)this.activityStorage.getNewerOnUserSpacesActivities(this.demoIdentity, (ExoSocialActivity)baseActivity, 20).size());
        ActivityStorageTest.assertEquals((int)19, (int)this.activityStorage.getNumberOfNewerOnUserSpacesActivities(this.demoIdentity, (ExoSocialActivity)baseActivity));
    }

    public void testGetOlderOnUserSpacesActivities() throws Exception {
        Space space = this.getSpaceInstance(0);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        int totalNumber = 5;
        ExoSocialActivityImpl baseActivity = null;
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityStorage.saveActivity(spaceIdentity, (ExoSocialActivity)activity);
            this.LOG.info((Object)("user = " + this.demoIdentity.getRemoteId() + " activity's postedTime = " + activity.getPostedTime()));
            this.sleep(1);
            this.restartTransaction();
            if (i != 4) continue;
            baseActivity = activity;
        }
        this.LOG.info((Object)("user = " + this.demoIdentity.getRemoteId() + " sinceTime = " + baseActivity.getPostedTime()));
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getOlderOnUserSpacesActivities(this.demoIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getNumberOfOlderOnUserSpacesActivities(this.demoIdentity, baseActivity));
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getOlderOnSpaceActivities(spaceIdentity, baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getNumberOfOlderOnSpaceActivities(spaceIdentity, (ExoSocialActivity)baseActivity));
        Space space2 = this.getSpaceInstance(1);
        Identity spaceIdentity2 = this.identityManager.getOrCreateIdentity("space", space2.getPrettyName(), false);
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityStorage.saveActivity(spaceIdentity2, (ExoSocialActivity)activity);
            this.sleep(1);
            this.restartTransaction();
        }
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getOlderOnUserSpacesActivities(this.demoIdentity, (ExoSocialActivity)baseActivity, 10).size());
        ActivityStorageTest.assertEquals((int)4, (int)this.activityStorage.getNumberOfOlderOnUserSpacesActivities(this.demoIdentity, (ExoSocialActivity)baseActivity));
    }

    public void testGetNewerComments() {
        ExoSocialActivityImpl comment;
        int i;
        int totalNumber = 3;
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity title");
        activity.setUserId(this.rootIdentity.getId());
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        for (i = 0; i < totalNumber; ++i) {
            this.sleep(1);
            this.restartTransaction();
            comment = new ExoSocialActivityImpl();
            comment.setTitle("john comment " + i);
            comment.setUserId(this.johnIdentity.getId());
            this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        }
        for (i = 0; i < totalNumber; ++i) {
            this.sleep(1);
            this.restartTransaction();
            comment = new ExoSocialActivityImpl();
            comment.setTitle("demo comment " + i);
            comment.setUserId(this.demoIdentity.getId());
            this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        }
        this.restartTransaction();
        List comments = this.activityStorage.getComments((ExoSocialActivity)activity, false, 0, 20);
        ActivityStorageTest.assertEquals((int)6, (int)comments.size());
        ExoSocialActivity baseComment = (ExoSocialActivity)comments.get(0);
        ActivityStorageTest.assertEquals((int)5, (int)this.activityStorage.getNewerComments((ExoSocialActivity)activity, baseComment, 20).size());
        ActivityStorageTest.assertEquals((int)5, (int)this.activityStorage.getNumberOfNewerComments((ExoSocialActivity)activity, baseComment));
        baseComment = (ExoSocialActivity)comments.get(2);
        ActivityStorageTest.assertEquals((int)3, (int)this.activityStorage.getNewerComments((ExoSocialActivity)activity, baseComment, 20).size());
        ActivityStorageTest.assertEquals((int)3, (int)this.activityStorage.getNumberOfNewerComments((ExoSocialActivity)activity, baseComment));
        baseComment = (ExoSocialActivity)comments.get(5);
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNewerComments((ExoSocialActivity)activity, baseComment, 20).size());
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNumberOfNewerComments((ExoSocialActivity)activity, baseComment));
    }

    public void testGetOlderComments() {
        ExoSocialActivityImpl comment;
        int i;
        int totalNumber = 10;
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity title");
        activity.setUserId(this.rootIdentity.getId());
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        for (i = 0; i < totalNumber; ++i) {
            comment = new ExoSocialActivityImpl();
            comment.setTitle("john comment " + i);
            comment.setUserId(this.johnIdentity.getId());
            this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
            this.sleep(1);
        }
        for (i = 0; i < totalNumber; ++i) {
            comment = new ExoSocialActivityImpl();
            comment.setTitle("demo comment " + i);
            comment.setUserId(this.demoIdentity.getId());
            this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
            this.sleep(1);
        }
        List comments = this.activityStorage.getComments((ExoSocialActivity)activity, false, 0, 20);
        ActivityStorageTest.assertEquals((int)20, (int)comments.size());
        ExoSocialActivity baseComment = (ExoSocialActivity)comments.get(19);
        ActivityStorageTest.assertEquals((int)19, (int)this.activityStorage.getOlderComments((ExoSocialActivity)activity, baseComment, 20).size());
        ActivityStorageTest.assertEquals((int)19, (int)this.activityStorage.getNumberOfOlderComments((ExoSocialActivity)activity, baseComment));
        baseComment = (ExoSocialActivity)comments.get(10);
        ActivityStorageTest.assertEquals((int)10, (int)this.activityStorage.getOlderComments((ExoSocialActivity)activity, baseComment, 20).size());
        ActivityStorageTest.assertEquals((int)10, (int)this.activityStorage.getNumberOfOlderComments((ExoSocialActivity)activity, baseComment));
        baseComment = (ExoSocialActivity)comments.get(0);
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getOlderComments((ExoSocialActivity)activity, baseComment, 20).size());
        ActivityStorageTest.assertEquals((int)0, (int)this.activityStorage.getNumberOfOlderComments((ExoSocialActivity)activity, baseComment));
    }

    public void testMentionersAndCommenters() throws Exception {
        ExoSocialActivity activity = this.createActivity(1);
        activity.setTitle("hello @demo @john");
        this.activityStorage.saveActivity(this.rootIdentity, activity);
        ExoSocialActivity got = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertNotNull((Object)got);
        ActivityStorageTest.assertEquals((int)2, (int)got.getMentionedIds().length);
        ExoSocialActivityImpl comment1 = new ExoSocialActivityImpl();
        comment1.setTitle("comment 1");
        comment1.setUserId(this.demoIdentity.getId());
        this.activityStorage.saveComment(activity, (ExoSocialActivity)comment1);
        ExoSocialActivityImpl comment2 = new ExoSocialActivityImpl();
        comment2.setTitle("comment 2");
        comment2.setUserId(this.johnIdentity.getId());
        this.activityStorage.saveComment(activity, (ExoSocialActivity)comment2);
        got = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertEquals((int)2, (int)got.getReplyToId().length);
        ActivityStorageTest.assertEquals((int)2, (int)got.getCommentedIds().length);
        ExoSocialActivityImpl comment3 = new ExoSocialActivityImpl();
        comment3.setTitle("hello @mary");
        comment3.setUserId(this.johnIdentity.getId());
        this.activityStorage.saveComment(activity, (ExoSocialActivity)comment3);
        got = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertEquals((int)3, (int)got.getReplyToId().length);
        ActivityStorageTest.assertEquals((int)2, (int)got.getCommentedIds().length);
        ActivityStorageTest.assertEquals((int)3, (int)got.getMentionedIds().length);
        this.activityStorage.deleteComment(activity.getId(), comment3.getId());
        got = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertEquals((int)2, (int)got.getReplyToId().length);
        ActivityStorageTest.assertEquals((int)2, (int)got.getCommentedIds().length);
        ActivityStorageTest.assertEquals((int)2, (int)got.getMentionedIds().length);
        ExoSocialActivityImpl subComment1 = new ExoSocialActivityImpl();
        subComment1.setTitle("subcomment 1");
        subComment1.setUserId(this.maryIdentity.getId());
        subComment1.setParentCommentId(comment1.getId());
        this.activityStorage.saveComment(activity, (ExoSocialActivity)subComment1);
        got = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertEquals((int)3, (int)got.getReplyToId().length);
        ActivityStorageTest.assertEquals((int)3, (int)got.getCommentedIds().length);
        ActivityStorageTest.assertEquals((int)2, (int)got.getMentionedIds().length);
    }

    public void testDeleteCommentAsActivity() throws ActivityStorageException {
        ActivityStorageTest.assertTrue((boolean)(this.activityStorage instanceof CachedActivityStorage));
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Test parent activity");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("Test comment");
        comment.setUserId(this.rootIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ExoSocialActivity cachedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertNotNull((Object)cachedActivity);
        ActivityStorageTest.assertEquals((String)activity.getTitle(), (String)cachedActivity.getTitle());
        ActivityDAO activityDAO = (ActivityDAO)this.getContainer().getComponentInstanceOfType(ActivityDAO.class);
        ActivityEntity activityEntity = (ActivityEntity)activityDAO.find((Serializable)Long.valueOf(Long.parseLong(activity.getId())));
        activityEntity.setTitle(activity.getTitle() + " modified");
        activityDAO.update((Object)activityEntity);
        cachedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertNotNull((Object)cachedActivity);
        ActivityStorageTest.assertEquals((String)activity.getTitle(), (String)cachedActivity.getTitle());
        this.activityStorage.deleteActivity(comment.getId().replace("comment", ""));
        cachedActivity = this.activityStorage.getActivity(activity.getId());
        ActivityStorageTest.assertNotNull((Object)cachedActivity);
        ActivityStorageTest.assertEquals((String)(activity.getTitle() + " modified"), (String)cachedActivity.getTitle());
    }

    public void testShouldMoveActivityUpWhenMentionedInAPost() {
        ExoSocialActivity activity1 = this.createActivity(1);
        activity1.setTitle("hello world");
        this.activityStorage.saveActivity(this.demoIdentity, activity1);
        this.restartTransaction();
        ExoSocialActivity activity2 = this.createActivity(1);
        activity2.setTitle("hello mention @demo");
        this.activityStorage.saveActivity(this.rootIdentity, activity2);
        this.restartTransaction();
        ExoSocialActivity activity3 = this.createActivity(1);
        activity3.setTitle("bye world");
        this.activityStorage.saveActivity(this.demoIdentity, activity3);
        this.restartTransaction();
        List activities = this.activityStorage.getActivities(this.demoIdentity, this.demoIdentity, 0L, 10L);
        ActivityStorageTest.assertNotNull((Object)activities);
        ActivityStorageTest.assertEquals((int)3, (int)activities.size());
        ActivityStorageTest.assertEquals((String)"bye world", (String)((ExoSocialActivity)activities.get(0)).getTitle());
        ActivityStorageTest.assertTrue((String)("Title '" + ((ExoSocialActivity)activities.get(1)).getTitle() + "' doesn't start with 'hello mention'"), (boolean)((ExoSocialActivity)activities.get(1)).getTitle().startsWith("hello mention"));
        ActivityStorageTest.assertEquals((String)"hello world", (String)((ExoSocialActivity)activities.get(2)).getTitle());
    }

    public void testViewerOwnerPosterActivities() throws Exception {
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setTitle("title @demo hi");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity1);
        ExoSocialActivityImpl activity2 = new ExoSocialActivityImpl();
        activity2.setTitle("root title");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity2);
        Space space = this.getSpaceInstance(1);
        Identity spaceIdentity2 = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        for (int i = 0; i < 5; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityStorage.saveActivity(spaceIdentity2, (ExoSocialActivity)activity);
        }
        this.createComment((ExoSocialActivity)activity2, this.demoIdentity, null, 5, 0);
        List list = this.activityStorage.getActivities(this.demoIdentity, this.johnIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)2, (int)list.size());
        list = this.activityStorage.getActivities(this.johnIdentity, this.demoIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)0, (int)list.size());
        list = this.activityStorage.getActivities(this.demoIdentity, this.demoIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)7, (int)list.size());
    }

    public void testViewerOwnerPosterInSpaceSubComments() throws Exception {
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setTitle("title @mary hi");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity1);
        ExoSocialActivityImpl activity2 = new ExoSocialActivityImpl();
        activity2.setTitle("root title");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity2);
        Space space = this.getSpaceInstance(1);
        Identity spaceIdentity2 = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        for (int i = 0; i < 5; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityStorage.saveActivity(spaceIdentity2, (ExoSocialActivity)activity);
        }
        this.createComment((ExoSocialActivity)activity2, this.demoIdentity, this.maryIdentity, 5, 5);
        List list = this.activityStorage.getActivities(this.maryIdentity, this.johnIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)2, (int)list.size());
        list = this.activityStorage.getActivities(this.johnIdentity, this.maryIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)0, (int)list.size());
        list = this.activityStorage.getActivities(this.maryIdentity, this.maryIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)2, (int)list.size());
    }

    public void testViewerOwnerPosterSubComments() throws Exception {
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setTitle("title @mary hi");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity1);
        ExoSocialActivityImpl activity2 = new ExoSocialActivityImpl();
        activity2.setTitle("root title");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity2);
        activity2.setLikeIdentityIds(new String[]{this.maryIdentity.getId()});
        this.activityStorage.updateActivity((ExoSocialActivity)activity2);
        for (int i = 0; i < 5; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.rootIdentity.getId());
            this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
            this.createComment((ExoSocialActivity)activity, this.demoIdentity, this.maryIdentity, 5, 5);
        }
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("comment demo");
        comment.setUserId(this.demoIdentity.getId());
        comment.setPosterId(this.demoIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity1, (ExoSocialActivity)comment);
        ExoSocialActivityImpl commentReply = new ExoSocialActivityImpl();
        commentReply.setTitle("comment reply @mary");
        commentReply.setUserId(this.demoIdentity.getId());
        commentReply.setPosterId(this.demoIdentity.getId());
        commentReply.setParentCommentId(comment.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity1, (ExoSocialActivity)commentReply);
        List list = this.activityStorage.getActivities(this.maryIdentity, this.maryIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)7, (int)list.size());
        list = this.activityStorage.getActivities(this.johnIdentity, this.maryIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)0, (int)list.size());
        list = this.activityStorage.getActivities(this.maryIdentity, this.johnIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)7, (int)list.size());
    }

    public void testSaveCommentWithAlreadyMentionedUsers() throws Exception {
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setTitle("Initial Activity");
        this.activityStorage.saveActivity(this.rootIdentity, (ExoSocialActivity)activity1);
        ExoSocialActivityImpl comment1 = new ExoSocialActivityImpl();
        comment1.setTitle("comment @root");
        comment1.setUserId(this.johnIdentity.getId());
        comment1.setPosterId(this.johnIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity1, (ExoSocialActivity)comment1);
        ExoSocialActivityImpl comment2 = new ExoSocialActivityImpl();
        comment2.setTitle("comment @john");
        comment2.setUserId(this.rootIdentity.getId());
        comment2.setPosterId(this.rootIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity1, (ExoSocialActivity)comment2);
        ExoSocialActivityImpl comment3 = new ExoSocialActivityImpl();
        comment3.setTitle("comment @root");
        comment3.setUserId(this.johnIdentity.getId());
        comment3.setPosterId(this.johnIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity1, (ExoSocialActivity)comment3);
        ExoSocialActivityImpl comment4 = new ExoSocialActivityImpl();
        comment4.setTitle("comment @john");
        comment4.setUserId(this.rootIdentity.getId());
        comment4.setPosterId(this.rootIdentity.getId());
        this.activityStorage.saveComment((ExoSocialActivity)activity1, (ExoSocialActivity)comment4);
        List list = this.activityStorage.getActivities(this.rootIdentity, this.rootIdentity, 0L, 10L);
        ActivityStorageTest.assertEquals((int)1, (int)list.size());
        ActivityStorageTest.assertEquals((int)2, (int)((ExoSocialActivity)list.get(0)).getMentionedIds().length);
        List comments = this.activityStorage.getComments((ExoSocialActivity)list.get(0), true, 0, 10);
        ActivityStorageTest.assertEquals((int)4, (int)comments.size());
    }

    private Space getSpaceInstance(int number) throws Exception {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{"demo"};
        String[] members = new String[]{"demo"};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceStorage.saveSpace(space, true);
        return space;
    }

    private void createActivities(int number, Identity owner) {
        this.restartTransaction();
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(owner.getId());
            this.activityStorage.saveActivity(owner, (ExoSocialActivity)activity);
            this.sleep(10);
            this.LOG.info((Object)("owner = " + owner.getRemoteId() + " PostedTime = " + activity.getPostedTime()));
        }
        this.restartTransaction();
    }

    private ExoSocialActivity createActivity(int num) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Activity " + num);
        activity.setTitleId("TitleID: " + activity.getTitle());
        activity.setType("UserActivity");
        activity.setBody("Body of " + activity.getTitle());
        activity.setBodyId("BodyId of " + activity.getTitle());
        activity.setLikeIdentityIds(new String[]{"demo", "mary"});
        activity.setMentionedIds(new String[]{"demo", "john"});
        activity.setCommentedIds(new String[0]);
        activity.setReplyToId(new String[0]);
        activity.setAppId("AppID");
        activity.setExternalId("External ID");
        return activity;
    }

    private void createComment(ExoSocialActivity existingActivity, Identity posterIdentity, Identity commentReplyIdentity, int number, int numberOfSubComments) {
        this.restartTransaction();
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(posterIdentity.getId());
            comment.setPosterId(posterIdentity.getId());
            this.activityStorage.saveComment(existingActivity, (ExoSocialActivity)comment);
            this.restartTransaction();
            for (int j = 0; j < numberOfSubComments; ++j) {
                ExoSocialActivityImpl commentReply = new ExoSocialActivityImpl();
                commentReply.setTitle("comment reply " + i + " " + j);
                commentReply.setUserId(commentReplyIdentity.getId());
                commentReply.setPosterId(commentReplyIdentity.getId());
                commentReply.setParentCommentId(comment.getId());
                this.activityStorage.saveComment(existingActivity, (ExoSocialActivity)commentReply);
                this.restartTransaction();
            }
        }
        this.restartTransaction();
    }
}

