/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.storage.entity.ProfileExperienceEntity;
import org.exoplatform.social.core.jpa.test.BaseCoreTest;

public class ProfileDAOTest
extends BaseCoreTest {
    private IdentityDAO identityDAO;
    private List<IdentityEntity> deleteIdentities = new ArrayList<IdentityEntity>();
    private IdentityEntity identity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityDAO = this.getService(IdentityDAO.class);
        this.identity = (IdentityEntity)this.identityDAO.create((Object)this.createIdentity());
        this.restartTransaction();
        this.identity = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(this.identity.getId()));
    }

    @Override
    public void tearDown() throws Exception {
        for (IdentityEntity identity : this.deleteIdentities) {
            this.identityDAO.delete((Object)identity);
        }
        this.identityDAO.delete((Object)this.identity);
        this.restartTransaction();
        super.tearDown();
    }

    public void testCreateProfile() {
        IdentityEntity profile = this.createProfile(this.identity);
        profile = (IdentityEntity)this.identityDAO.update((Object)profile);
        profile = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(profile.getId()));
        ProfileDAOTest.assertNotNull((Object)profile);
        ProfileDAOTest.assertEquals((int)1, (int)profile.getExperiences().size());
    }

    public void testUpdateProfile() {
        IdentityEntity profile = this.createProfile(this.identity);
        profile = (IdentityEntity)this.identityDAO.update((Object)profile);
        profile = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(profile.getId()));
        ProfileDAOTest.assertNotNull((Object)profile);
        ProfileDAOTest.assertEquals((String)"/profile/root", (String)((String)profile.getProperties().get("Url")));
        profile.getProperties().put("Url", "/profile/root_updated");
        this.identityDAO.update((Object)profile);
        profile = (IdentityEntity)this.identityDAO.find((Serializable)Long.valueOf(profile.getId()));
        ProfileDAOTest.assertNotNull((Object)profile);
        ProfileDAOTest.assertEquals((int)0, (int)profile.getExperiences().size());
        ProfileDAOTest.assertEquals((String)"/profile/root_updated", (String)((String)profile.getProperties().get("Url")));
    }

    private IdentityEntity createProfile(IdentityEntity profile) {
        profile.setCreatedDate(new Date());
        ProfileExperienceEntity exp = new ProfileExperienceEntity();
        exp.setCompany("eXo Platform");
        exp.setPosition("Developer");
        exp.setSkills("Java, Unit test");
        exp.setStartDate("2015-01-01");
        HashSet<ProfileExperienceEntity> exps = new HashSet<ProfileExperienceEntity>();
        exps.add(exp);
        profile.setExperiences(exps);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Url", "/profile/root");
        profile.setProperties(props);
        return profile;
    }

    private IdentityEntity createIdentity() {
        IdentityEntity identity = new IdentityEntity();
        identity.setProviderId("organization");
        identity.setRemoteId("user_test_profile");
        identity.setEnabled(true);
        identity.setDeleted(false);
        return identity;
    }
}

