/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.listeners.ManagerPropertySettingUpdatedListener;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.junit.After;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ManagerPropertySettingUpdatedListenerTest {
    @Mock
    PageStorage pageStorage;
    @Mock
    ProfilePropertyService profilePropertyService;
    @Mock
    PortalContainer portalContainer;
    @Mock
    UserACL userACL;
    private static final MockedStatic<PortalContainer> PORTAL_CONTAINER = Mockito.mockStatic(PortalContainer.class);

    @Test
    public void testOnEvent() {
        PORTAL_CONTAINER.when(PortalContainer::getInstance).thenReturn((Object)this.portalContainer);
        Mockito.lenient().when((Object)this.userACL.getSuperUser()).thenReturn((Object)"root");
        ManagerPropertySettingUpdatedListener managerPropertySettingUpdatedListener = new ManagerPropertySettingUpdatedListener(this.pageStorage, this.userACL);
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting(Long.valueOf(1L), "testProperty", "text", false, true, true, null, Long.valueOf(1L), true, false, false, true, false, false, false, new ArrayList(), Long.valueOf(System.currentTimeMillis()));
        Event event = new Event("profile-property-setting-updated", (Object)this.profilePropertyService, (Object)profilePropertySetting);
        try {
            managerPropertySettingUpdatedListener.onEvent(event);
        }
        catch (Exception e) {
            Assertions.fail();
        }
        ((PageStorage)Mockito.verify((Object)this.pageStorage, (VerificationMode)Mockito.times((int)0))).savePage((PageContext)ArgumentMatchers.any());
        PageState pageState = new PageState("MyTeam", "myteam page", false, "PagesFactory", List.of("/platform/users"), "/platform/administrators");
        PageContext pageContext = new PageContext(PageKey.parse((String)"portal::global::organizationalChart"), pageState);
        Mockito.when((Object)this.pageStorage.loadPage((PageKey)ArgumentMatchers.any())).thenReturn((Object)pageContext);
        profilePropertySetting = new ProfilePropertySetting(Long.valueOf(1L), "manager", "text", false, true, true, null, Long.valueOf(1L), true, false, false, true, false, false, false, new ArrayList(), Long.valueOf(System.currentTimeMillis()));
        event = new Event("profile-property-setting-updated", (Object)this.profilePropertyService, (Object)profilePropertySetting);
        try {
            managerPropertySettingUpdatedListener.onEvent(event);
        }
        catch (Exception e) {
            Assertions.fail();
        }
        ((PageStorage)Mockito.verify((Object)this.pageStorage, (VerificationMode)Mockito.times((int)2))).savePage((PageContext)ArgumentMatchers.any());
    }

    @After
    public void tearDown() throws Exception {
        PORTAL_CONTAINER.close();
    }
}

