/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfilePropertySettingDAO;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class IdentityManagerTest
extends AbstractCoreTest {
    private IdentityManager identityManager;
    private IdentityStorage identityStorage;
    private List<org.exoplatform.social.core.identity.model.Identity> tearDownIdentityList;
    private ActivityManager activityManager;
    private ProfilePropertyService profilePropertyService;
    private SpaceService spaceService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        IdentityManagerTest.assertNotNull((Object)this.identityManager);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        IdentityManagerTest.assertNotNull((Object)this.spaceService);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        IdentityManagerTest.assertNotNull((Object)this.activityManager);
        this.profilePropertyService = (ProfilePropertyService)this.getContainer().getComponentInstanceOfType(ProfilePropertyService.class);
        IdentityManagerTest.assertNotNull((Object)this.profilePropertyService);
        this.tearDownIdentityList = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        Identity identity = this.getService(IdentityRegistry.class).getIdentity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(identity));
    }

    @Override
    public void tearDown() throws Exception {
        for (org.exoplatform.social.core.identity.model.Identity identity : this.tearDownIdentityList) {
            this.identityManager.deleteIdentity(identity);
        }
        this.getService(ProfilePropertySettingDAO.class).deleteAll();
        super.tearDown();
    }

    public void testGetSpaceMembers() throws Exception {
        org.exoplatform.social.core.identity.model.Identity demoIdentity = this.populateIdentity("demo");
        org.exoplatform.social.core.identity.model.Identity johnIdentity = this.populateIdentity("john");
        org.exoplatform.social.core.identity.model.Identity maryIdentity = this.populateIdentity("mary");
        int number = 0;
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setGroupId("/space/space" + number);
        space.setUrl(space.getPrettyName());
        String[] spaceManagers = new String[]{demoIdentity.getRemoteId()};
        String[] members = new String[]{demoIdentity.getRemoteId()};
        String[] invitedUsers = new String[]{};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(spaceManagers);
        space.setMembers(members);
        space = this.createSpaceNonInitApps(space, demoIdentity.getRemoteId(), null);
        Space savedSpace = this.spaceService.getSpaceById(space.getId());
        IdentityManagerTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        this.spaceService.addMember(savedSpace, johnIdentity.getRemoteId());
        this.spaceService.addMember(savedSpace, maryIdentity.getRemoteId());
        ProfileFilter profileFilter = new ProfileFilter();
        ListAccess spaceMembers = this.identityManager.getSpaceIdentityByProfileFilter(savedSpace, profileFilter, SpaceMemberFilterListAccess.Type.MEMBER, true);
        IdentityManagerTest.assertEquals((int)3, (int)spaceMembers.getSize());
        this.spaceService.removeMember(savedSpace, johnIdentity.getRemoteId());
        profileFilter = new ProfileFilter();
        ListAccess got = this.identityManager.getSpaceIdentityByProfileFilter(savedSpace, profileFilter, SpaceMemberFilterListAccess.Type.MEMBER, true);
        IdentityManagerTest.assertEquals((int)2, (int)got.getSize());
    }

    public void testGetIdentityByIdWithLoadProfile() {
        String username = "root";
        org.exoplatform.social.core.identity.model.Identity tobeSavedIdentity = this.identityManager.getOrCreateIdentity("organization", "root", true);
        org.exoplatform.social.core.identity.model.Identity gotIdentity = this.identityManager.getIdentity(tobeSavedIdentity.getId(), false);
        IdentityManagerTest.assertNotNull((Object)gotIdentity);
        IdentityManagerTest.assertEquals((String)tobeSavedIdentity.getId(), (String)gotIdentity.getId());
        IdentityManagerTest.assertEquals((String)"gotIdentity.getProviderId() must return: organization", (String)"organization", (String)gotIdentity.getProviderId());
        IdentityManagerTest.assertEquals((String)"gotIdentity.getRemoteId() must return: root", (String)"root", (String)gotIdentity.getRemoteId());
        this.tearDownIdentityList.add(this.identityManager.getIdentity(tobeSavedIdentity.getId(), false));
    }

    public void testDeleteIdentity() {
        String username = "demo";
        org.exoplatform.social.core.identity.model.Identity tobeSavedIdentity = this.identityManager.getOrCreateIdentity("organization", "demo", false);
        IdentityManagerTest.assertNotNull((String)"tobeSavedIdentity.getId() must not be null", (Object)tobeSavedIdentity.getId());
        IdentityManagerTest.assertNotNull((String)"tobeSavedIdentity.getProfile().getId() must not be null", (Object)tobeSavedIdentity.getProfile().getId());
        this.identityManager.deleteIdentity(tobeSavedIdentity);
        org.exoplatform.social.core.identity.model.Identity gotIdentity = this.identityManager.getOrCreateIdentity("organization", "demo", false);
        IdentityManagerTest.assertNotNull((String)"gotIdentity must not be null because demo is in organizationService", (Object)gotIdentity);
        IdentityManagerTest.assertNotNull((String)"gotIdentity.getId() must not be null", (Object)gotIdentity.getId());
        this.tearDownIdentityList.add(gotIdentity);
    }

    public void testOrderOfGetIdentitiesByProfileFilter() throws Exception {
        String providerId = "organization";
        String[] FirstNameList = new String[]{"John", "Bob", "Alain"};
        String[] LastNameList = new String[]{"Smith", "Dupond", "Dupond"};
        for (int i = 0; i < 3; ++i) {
            String remoteId = "username" + i;
            org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity(providerId, remoteId);
            this.identityStorage.saveIdentity(identity);
            Profile profile = new Profile(identity);
            profile.setProperty("firstName", (Object)FirstNameList[i]);
            profile.setProperty("lastName", (Object)LastNameList[i]);
            profile.setProperty("fullName", (Object)(FirstNameList[i] + " " + LastNameList[i]));
            profile.setProperty("position", (Object)"developer");
            profile.setProperty("gender", (Object)"male");
            this.identityStorage.saveProfile(profile);
            identity.setProfile(profile);
            this.tearDownIdentityList.add(identity);
        }
        ProfileFilter pf = new ProfileFilter();
        ListAccess idsListAccess = null;
        pf.setSorting(new Sorting(Sorting.SortBy.FULLNAME, Sorting.OrderBy.ASC));
        idsListAccess = this.identityManager.getIdentitiesByProfileFilter(providerId, pf, false);
        IdentityManagerTest.assertNotNull((Object)idsListAccess);
        IdentityManagerTest.assertTrue((idsListAccess.getSize() >= 3 ? 1 : 0) != 0);
        IdentityManagerTest.assertEquals((String)"Alain Dupond", (String)((org.exoplatform.social.core.identity.model.Identity[])idsListAccess.load(0, 20))[0].getProfile().getFullName());
        IdentityManagerTest.assertEquals((String)"Bob Dupond", (String)((org.exoplatform.social.core.identity.model.Identity[])idsListAccess.load(0, 20))[1].getProfile().getFullName());
        org.exoplatform.social.core.identity.model.Identity[] identityArray = (org.exoplatform.social.core.identity.model.Identity[])idsListAccess.load(0, 2);
        IdentityManagerTest.assertEquals((String)this.tearDownIdentityList.get(2).getId(), (String)identityArray[0].getId());
    }

    public void testUpdateProfile() throws Exception {
        org.exoplatform.social.core.identity.model.Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Profile profile = rootIdentity.getProfile();
        profile.setProperty("position", (Object)"CEO");
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        this.identityManager.updateProfile(profile);
        org.exoplatform.social.core.identity.model.Identity identityUpdated = this.identityManager.getOrCreateIdentity(rootIdentity.getProviderId(), rootIdentity.getRemoteId());
        IdentityManagerTest.assertEquals((Object)"CEO", (Object)identityUpdated.getProfile().getProperty("position"));
        this.restartTransaction();
        RealtimeListAccess activitiesWithListAccess = this.activityManager.getActivitiesWithListAccess(rootIdentity);
        List rootActivityList = activitiesWithListAccess.loadAsList(0, activitiesWithListAccess.getSize());
        this.tearDownIdentityList.add(rootIdentity);
    }

    public void testUpdateProfileAndDetectChanges() throws Exception {
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setPropertyName("position");
        profilePropertySetting.setActive(true);
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        org.exoplatform.social.core.identity.model.Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Profile profile = rootIdentity.getProfile();
        profile.setProperty("position", (Object)"Changed POSITION");
        final ArrayList changes = new ArrayList();
        this.identityManager.registerProfileListener(new ProfileListenerPlugin(this){

            public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
                changes.add(1);
            }

            public void createProfile(ProfileLifeCycleEvent event) {
            }

            public void technicalUpdated(ProfileLifeCycleEvent event) {
            }

            public void contactSectionUpdated(ProfileLifeCycleEvent event) {
                changes.add(2);
            }

            public void bannerUpdated(ProfileLifeCycleEvent event) {
                changes.add(3);
            }

            public void avatarUpdated(ProfileLifeCycleEvent event) {
                changes.add(4);
            }

            public void aboutMeUpdated(ProfileLifeCycleEvent event) {
                changes.add(5);
            }
        });
        this.identityManager.updateProfile(profile, true);
        IdentityManagerTest.assertFalse((boolean)changes.isEmpty());
        IdentityManagerTest.assertTrue((boolean)changes.contains(2));
        profile.setProperty("position", (Object)"Changed POSITION");
        profile.setProperty("aboutMe", (Object)"Changed ABOUT_ME");
        this.identityManager.updateProfile(profile, true);
        IdentityManagerTest.assertTrue((changes.size() >= 2 ? 1 : 0) != 0);
        IdentityManagerTest.assertTrue((boolean)changes.contains(5));
        ArrayList experiences = new ArrayList();
        HashMap<String, String> company = new HashMap<String, String>();
        experiences.add(company);
        company.put("company", "oldValue");
        profile.setProperty("experiences", experiences);
        this.identityManager.updateProfile(profile, true);
        IdentityManagerTest.assertTrue((changes.size() >= 3 ? 1 : 0) != 0);
        IdentityManagerTest.assertTrue((boolean)changes.contains(1));
    }

    public void testUpdateProfileAndDetectChangeBanner() throws Exception {
        org.exoplatform.social.core.identity.model.Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Profile profile = rootIdentity.getProfile();
        final ArrayList changes = new ArrayList();
        this.identityManager.registerProfileListener(new ProfileListenerPlugin(this){

            public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
                changes.add(1);
            }

            public void createProfile(ProfileLifeCycleEvent event) {
            }

            public void technicalUpdated(ProfileLifeCycleEvent event) {
            }

            public void contactSectionUpdated(ProfileLifeCycleEvent event) {
                changes.add(2);
            }

            public void bannerUpdated(ProfileLifeCycleEvent event) {
                changes.add(3);
            }

            public void avatarUpdated(ProfileLifeCycleEvent event) {
                changes.add(4);
            }

            public void aboutMeUpdated(ProfileLifeCycleEvent event) {
                changes.add(5);
            }
        });
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", inputStream, System.currentTimeMillis());
        profile.setProperty("banner", (Object)bannerAttachment);
        this.identityManager.updateProfile(profile, true);
        IdentityManagerTest.assertEquals((int)1, (int)changes.size());
        IdentityManagerTest.assertTrue((boolean)changes.contains(3));
    }

    public void testUpdateProfileActivity() throws Exception {
        org.exoplatform.social.core.identity.model.Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root", false);
        Profile profile = rootIdentity.getProfile();
        profile.setProperty("position", (Object)"CEO");
        IdentityManagerTest.assertEquals((int)0, (int)profile.getListUpdateTypes().size());
        this.identityManager.updateProfile(profile);
        IdentityManagerTest.assertEquals((int)0, (int)profile.getListUpdateTypes().size());
        profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        IdentityManagerTest.assertEquals((int)1, (int)profile.getListUpdateTypes().size());
        org.exoplatform.social.core.identity.model.Identity identityUpdated = this.identityManager.getOrCreateIdentity(rootIdentity.getProviderId(), rootIdentity.getRemoteId());
        IdentityManagerTest.assertEquals((Object)"CEO", (Object)identityUpdated.getProfile().getProperty("position"));
    }

    private void populateData() {
        this.populateIdentities(5, true);
    }

    private void populateData(String remoteId) {
        String providerId = "organization";
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity(providerId, remoteId);
        this.identityStorage.saveIdentity(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)("FirstName " + remoteId));
        profile.setProperty("lastName", (Object)("LastName" + remoteId));
        profile.setProperty("fullName", (Object)("FirstName " + remoteId + " LastName" + remoteId));
        profile.setProperty("position", (Object)"developer");
        profile.setProperty("gender", (Object)"male");
        this.identityStorage.saveProfile(profile);
        identity.setProfile(profile);
        this.tearDownIdentityList.add(identity);
    }

    private void populateIdentities(int numberOfItems, boolean addedToTearDownList) {
        String providerId = "organization";
        for (int i = 0; i < numberOfItems; ++i) {
            String remoteId = "username" + i;
            org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity(providerId, remoteId);
            this.identityStorage.saveIdentity(identity);
            Profile profile = new Profile(identity);
            profile.setProperty("firstName", (Object)("FirstName" + i));
            profile.setProperty("lastName", (Object)("LastName" + i));
            profile.setProperty("fullName", (Object)("FirstName" + i + " LastName" + i));
            profile.setProperty("position", (Object)"developer");
            profile.setProperty("gender", (Object)"male");
            this.identityStorage.saveProfile(profile);
            identity.setProfile(profile);
            if (!addedToTearDownList) continue;
            this.tearDownIdentityList.add(identity);
        }
    }

    private org.exoplatform.social.core.identity.model.Identity populateIdentity(String remoteId) {
        return this.populateIdentity(remoteId, true);
    }

    private org.exoplatform.social.core.identity.model.Identity populateIdentity(String remoteId, boolean addedToTearDownList) {
        String providerId = "organization";
        org.exoplatform.social.core.identity.model.Identity identity = new org.exoplatform.social.core.identity.model.Identity(providerId, remoteId);
        this.identityStorage.saveIdentity(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)remoteId);
        profile.setProperty("lastName", (Object)"gtn");
        profile.setProperty("fullName", (Object)(remoteId + " gtn"));
        profile.setProperty("position", (Object)"developer");
        profile.setProperty("gender", (Object)"male");
        this.identityStorage.saveProfile(profile);
        if (addedToTearDownList) {
            this.tearDownIdentityList.add(identity);
        }
        return identity;
    }

    public void testIdentityExisted() {
        String remoteId = "notfound";
        String providerId = "organization";
        boolean existed = this.identityManager.identityExisted(providerId, remoteId);
        IdentityManagerTest.assertFalse((boolean)existed);
        remoteId = "root";
        providerId = "organization";
        existed = this.identityManager.identityExisted(providerId, remoteId);
        IdentityManagerTest.assertTrue((boolean)existed);
    }

    public void testCacheManagement() throws ActivityStorageException {
        org.exoplatform.social.core.identity.model.Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Profile rootProfile = rootIdentity.getProfile();
        String newFirstName = "New First Name";
        rootProfile.setProperty("firstName", (Object)"New First Name");
        this.identityStorage.saveProfile(rootProfile);
        org.exoplatform.social.core.identity.model.Identity gotRootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        IdentityManagerTest.assertNotNull((String)"gotRootIdentity.getId() must not be null", (Object)gotRootIdentity.getId());
        IdentityManagerTest.assertEquals((String)"gotRootIdentity.getProfile().getProperty(Profile.FIRST_NAME) must be updated: New First Name", (Object)"New First Name", (Object)gotRootIdentity.getProfile().getProperty("firstName"));
    }

    public void testGetIdentitiesByGroupsIdsAccessList() throws Exception {
        ProfileFilter pf = new ProfileFilter();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("/platform/administrators");
        pf.setGroupIds(groupIds);
        List identities = this.identityManager.getIdentitiesByProfileFilter("organization", pf);
        IdentityManagerTest.assertTrue((String)("Number of identities must be " + identities.size()), (identities.size() > 0 ? 1 : 0) != 0);
        ProfileFilter pf1 = new ProfileFilter();
        HashMap<String, String> profileSettings = new HashMap<String, String>();
        profileSettings.put("fullName", "john");
        pf1.setProfileSettings(profileSettings);
        pf1.setGroupIds(groupIds);
        List identities1 = this.identityManager.getIdentitiesByProfileFilter("organization", pf1);
        IdentityManagerTest.assertTrue((String)("Number of identities must be " + identities1.size()), (identities.size() > 0 ? 1 : 0) != 0);
    }
}

