/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.HashMap;
import junit.framework.TestCase;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.processor.I18NActivityUtils;

public class I18NActivityUtilsTest
extends TestCase {
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetParamValues() throws Exception {
        String input = "v1&#v2#v2#v3";
        String[] got = I18NActivityUtils.getParamValues((String)input);
        I18NActivityUtilsTest.assertEquals((int)3, (int)got.length);
        input = "#v2#v3";
        got = I18NActivityUtils.getParamValues((String)input);
        I18NActivityUtilsTest.assertEquals((int)3, (int)got.length);
    }

    public void testGetParamValuesWithNULL() throws Exception {
        String input = null;
        String[] got = I18NActivityUtils.getParamValues(input);
        I18NActivityUtilsTest.assertNull((Object)got);
    }

    public void testGetResourceValuesWhenEmpty() throws Exception {
        ExoSocialActivity a = this.createActivity();
        I18NActivityUtilsTest.assertNull((Object)I18NActivityUtils.getResourceValues((ExoSocialActivity)a));
    }

    public void testAddResourceKey() throws Exception {
        ExoSocialActivity a = this.createActivity();
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)"key1", (String[])new String[]{"val1"});
        I18NActivityUtilsTest.assertNotNull((Object)a.getTemplateParams());
        String[] values = I18NActivityUtils.getResourceValues((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)1, (int)values.length);
        I18NActivityUtilsTest.assertEquals((String)"key1", (String)a.getTitleId());
        String[] keys = I18NActivityUtils.getResourceKeys((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)1, (int)keys.length);
        I18NActivityUtilsTest.assertEquals((String)"key1", (String)keys[0]);
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)"key2", (String[])new String[]{"val1"});
        values = I18NActivityUtils.getResourceValues((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)2, (int)values.length);
        I18NActivityUtilsTest.assertEquals((String)a.getTitleId(), (String)"key1,key2");
        keys = I18NActivityUtils.getResourceKeys((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)2, (int)keys.length);
        I18NActivityUtilsTest.assertEquals((String)"key1", (String)keys[0]);
        I18NActivityUtilsTest.assertEquals((String)"key2", (String)keys[1]);
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)"key3", (String[])new String[]{"val1", "val2"});
        values = I18NActivityUtils.getResourceValues((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)3, (int)values.length);
        I18NActivityUtilsTest.assertEquals((String)"val1#val2", (String)values[2]);
        I18NActivityUtilsTest.assertEquals((String)a.getTitleId(), (String)"key1,key2,key3");
        keys = I18NActivityUtils.getResourceKeys((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)3, (int)keys.length);
        I18NActivityUtilsTest.assertEquals((String)"key1", (String)keys[0]);
        I18NActivityUtilsTest.assertEquals((String)"key2", (String)keys[1]);
        I18NActivityUtilsTest.assertEquals((String)"key3", (String)keys[2]);
    }

    public void testSpecialCharacters() throws Exception {
        ExoSocialActivity a = this.createActivity();
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)"key3", (String[])new String[]{"val1", "#val2"});
        String[] values = I18NActivityUtils.getResourceValues((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)1, (int)values.length);
        I18NActivityUtilsTest.assertEquals((String)"val1#${_}val2", (String)values[0]);
        I18NActivityUtilsTest.assertEquals((String)a.getTitleId(), (String)"key3");
        String[] keys = I18NActivityUtils.getResourceKeys((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)1, (int)keys.length);
        I18NActivityUtilsTest.assertEquals((String)"key3", (String)keys[0]);
        values = I18NActivityUtils.getParamValues((String)values[0]);
        I18NActivityUtilsTest.assertEquals((int)2, (int)values.length);
        I18NActivityUtilsTest.assertEquals((String)"val1", (String)values[0]);
        I18NActivityUtilsTest.assertEquals((String)"#val2", (String)values[1]);
    }

    public void testAddResourceKeyWithNullValue() throws Exception {
        ExoSocialActivity a = this.createActivity();
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)"key1", (String[])new String[]{""});
        I18NActivityUtilsTest.assertNotNull((Object)a.getTemplateParams());
        String[] values = I18NActivityUtils.getResourceValues((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)1, (int)values.length);
        I18NActivityUtilsTest.assertEquals((String)"key1", (String)a.getTitleId());
        String[] keys = I18NActivityUtils.getResourceKeys((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)1, (int)keys.length);
        I18NActivityUtilsTest.assertEquals((String)"", (String)values[0]);
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)"key2", null);
        values = I18NActivityUtils.getResourceValues((ExoSocialActivity)a);
        keys = I18NActivityUtils.getResourceKeys((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)2, (int)keys.length);
        I18NActivityUtilsTest.assertEquals((String)a.getTitleId(), (String)"key1,key2");
        I18NActivityUtilsTest.assertEquals((int)2, (int)keys.length);
        I18NActivityUtilsTest.assertEquals((String)"key1", (String)keys[0]);
        I18NActivityUtilsTest.assertEquals((String)"key2", (String)keys[1]);
        I18NActivityUtilsTest.assertEquals((String)"", (String)values[0]);
        I18NActivityUtilsTest.assertEquals((String)"", (String)values[1]);
        I18NActivityUtils.addResourceKey((ExoSocialActivity)a, (String)"key3", (String[])new String[]{"", null});
        values = I18NActivityUtils.getResourceValues((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)3, (int)values.length);
        I18NActivityUtilsTest.assertEquals((String)"", (String)values[0]);
        I18NActivityUtilsTest.assertEquals((String)"", (String)values[1]);
        I18NActivityUtilsTest.assertEquals((String)"#", (String)values[2]);
        I18NActivityUtilsTest.assertEquals((String)a.getTitleId(), (String)"key1,key2,key3");
        keys = I18NActivityUtils.getResourceKeys((ExoSocialActivity)a);
        I18NActivityUtilsTest.assertEquals((int)3, (int)keys.length);
        I18NActivityUtilsTest.assertEquals((String)"key1", (String)keys[0]);
        I18NActivityUtilsTest.assertEquals((String)"key2", (String)keys[1]);
        I18NActivityUtilsTest.assertEquals((String)"key3", (String)keys[2]);
    }

    private ExoSocialActivity createActivity() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title value");
        activity.setBody("body value");
        activity.isComment(false);
        activity.setType("ks-forum:spaces");
        activity.setTemplateParams(new HashMap());
        return activity;
    }
}

