/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.observer.service;

import io.meeds.social.observe.plugin.ObserverPlugin;
import io.meeds.social.observe.service.ObserverService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.junit.Assert;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml")})
public class ObserverServiceTest
extends AbstractKernelTest {
    private static final String NOT_FOUND_OBJECT_ID = "notFound";
    private static final String OBJECT_TYPE = "fake";
    private ObserverService observerService;
    protected String objectType = "fake";
    protected String objectId;
    protected List<String> allowedObjectId;
    protected long[] allowedIdentityIds;
    protected long spaceId = Math.round(Math.random() * 10000.0);
    protected long audienceId = Math.round(Math.random() * 20000.0);
    protected long identityId = Math.round(Math.random() * 30000.0);

    protected void setUp() throws Exception {
        super.setUp();
        this.observerService = (ObserverService)this.getContainer().getComponentInstanceOfType(ObserverService.class);
        this.observerService.removePlugin(OBJECT_TYPE);
        this.observerService.addPlugin((ObserverPlugin)new TestObserverPlugin());
        ++this.spaceId;
        ++this.audienceId;
        ++this.identityId;
        this.objectType = OBJECT_TYPE;
        this.objectId = this.spaceId + "-" + this.audienceId;
        this.allowedObjectId = new ArrayList<String>();
        this.allowedObjectId.add(this.objectId);
        this.allowedIdentityIds = new long[0];
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public void testCreateObserver() throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        ObserverServiceTest.assertFalse((boolean)this.observerService.isObserved(this.identityId, this.objectType, this.objectId));
        Assert.assertThrows(IllegalAccessException.class, () -> this.observerService.createObserver(this.identityId, OBJECT_TYPE, this.objectId));
        this.allowedIdentityIds = new long[]{this.identityId};
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.observerService.createObserver(this.identityId, OBJECT_TYPE, NOT_FOUND_OBJECT_ID));
        this.observerService.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverServiceTest.assertTrue((boolean)this.observerService.isObserved(this.identityId, this.objectType, this.objectId));
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.observerService.createObserver(this.identityId, OBJECT_TYPE, this.objectId));
    }

    public void testDeleteObserver() throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.observerService.deleteObserver(this.identityId, OBJECT_TYPE, NOT_FOUND_OBJECT_ID));
        ObserverServiceTest.assertFalse((boolean)this.observerService.isObserved(this.identityId, this.objectType, this.objectId));
        this.allowedIdentityIds = new long[]{this.identityId};
        this.observerService.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverServiceTest.assertTrue((boolean)this.observerService.isObserved(this.identityId, this.objectType, this.objectId));
        this.observerService.deleteObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverServiceTest.assertFalse((boolean)this.observerService.isObserved(this.identityId, this.objectType, this.objectId));
        this.observerService.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverServiceTest.assertTrue((boolean)this.observerService.isObserved(this.identityId, this.objectType, this.objectId));
        this.observerService.deleteObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverServiceTest.assertFalse((boolean)this.observerService.isObserved(this.identityId, this.objectType, this.objectId));
    }

    public void testIsObservable() {
        ObserverServiceTest.assertFalse((boolean)this.observerService.isObservable(this.identityId, OBJECT_TYPE, NOT_FOUND_OBJECT_ID));
        ObserverServiceTest.assertFalse((boolean)this.observerService.isObservable(this.identityId, OBJECT_TYPE, this.objectId));
        this.allowedIdentityIds = new long[]{this.identityId};
        ObserverServiceTest.assertTrue((boolean)this.observerService.isObservable(this.identityId, OBJECT_TYPE, this.objectId));
        ObserverServiceTest.assertFalse((boolean)this.observerService.isObservable(this.identityId, OBJECT_TYPE, NOT_FOUND_OBJECT_ID));
    }

    public void testGetObservedObjects() {
        ++this.identityId;
        long identityId1 = this.identityId++;
        long identityId2 = this.identityId;
        this.allowedIdentityIds = new long[]{identityId1, identityId2};
        List observedObjects = this.observerService.getObservedObjects(identityId1, 0L, 10L);
        ObserverServiceTest.assertNotNull((Object)observedObjects);
        ObserverServiceTest.assertTrue((boolean)observedObjects.isEmpty());
        String[] objectId1s = new String[]{"obj1" + identityId1, "obj2" + identityId1};
        Arrays.stream(objectId1s).forEach(id -> {
            this.allowedObjectId.add((String)id);
            try {
                this.observerService.createObserver(identityId1, OBJECT_TYPE, id);
                this.observerService.createObserver(identityId2, OBJECT_TYPE, id);
            }
            catch (Exception e) {
                ObserverServiceTest.fail((Throwable)e);
            }
        });
        String[] objectId2s = new String[]{"obj1" + identityId2, "obj2" + identityId2};
        Arrays.stream(objectId2s).forEach(id -> {
            this.allowedObjectId.add((String)id);
            try {
                this.observerService.createObserver(identityId2, OBJECT_TYPE, id);
            }
            catch (Exception e) {
                ObserverServiceTest.fail((Throwable)e);
            }
        });
        observedObjects = this.observerService.getObservedObjects(identityId1, 0L, 10L);
        ObserverServiceTest.assertNotNull((Object)observedObjects);
        ObserverServiceTest.assertEquals((int)2, (int)observedObjects.size());
        observedObjects = this.observerService.getObservedObjects(identityId2, 0L, 10L);
        ObserverServiceTest.assertNotNull((Object)observedObjects);
        ObserverServiceTest.assertEquals((int)4, (int)observedObjects.size());
    }

    public void testGetObserverIdentityIds() {
        ++this.identityId;
        long identityId1 = this.identityId++;
        long identityId2 = this.identityId;
        this.allowedIdentityIds = new long[]{identityId1, identityId2};
        List observerIdentityIds = this.observerService.getObserverIdentityIds(this.objectType, this.objectId);
        ObserverServiceTest.assertNotNull((Object)observerIdentityIds);
        ObserverServiceTest.assertTrue((boolean)observerIdentityIds.isEmpty());
        String[] objectId1s = new String[]{"obj1" + identityId1, "obj2" + identityId1};
        Arrays.stream(objectId1s).forEach(id -> {
            this.allowedObjectId.add((String)id);
            try {
                this.observerService.createObserver(identityId1, OBJECT_TYPE, id);
                this.observerService.createObserver(identityId2, OBJECT_TYPE, id);
            }
            catch (Exception e) {
                ObserverServiceTest.fail((Throwable)e);
            }
        });
        String[] objectId2s = new String[]{"obj1" + identityId2, "obj2" + identityId2};
        Arrays.stream(objectId2s).forEach(id -> {
            this.allowedObjectId.add((String)id);
            try {
                this.observerService.createObserver(identityId2, OBJECT_TYPE, id);
            }
            catch (Exception e) {
                ObserverServiceTest.fail((Throwable)e);
            }
        });
        observerIdentityIds = this.observerService.getObserverIdentityIds(this.objectType, objectId1s[0]);
        ObserverServiceTest.assertNotNull((Object)observerIdentityIds);
        ObserverServiceTest.assertEquals((int)2, (int)observerIdentityIds.size());
        observerIdentityIds = this.observerService.getObserverIdentityIds(this.objectType, objectId1s[1]);
        ObserverServiceTest.assertNotNull((Object)observerIdentityIds);
        ObserverServiceTest.assertEquals((int)2, (int)observerIdentityIds.size());
        observerIdentityIds = this.observerService.getObserverIdentityIds(this.objectType, objectId2s[0]);
        ObserverServiceTest.assertNotNull((Object)observerIdentityIds);
        ObserverServiceTest.assertEquals((int)1, (int)observerIdentityIds.size());
        observerIdentityIds = this.observerService.getObserverIdentityIds(this.objectType, objectId2s[1]);
        ObserverServiceTest.assertNotNull((Object)observerIdentityIds);
        ObserverServiceTest.assertEquals((int)1, (int)observerIdentityIds.size());
    }

    public class TestObserverPlugin
    extends ObserverPlugin {
        public boolean canObserve(long identityId, String id) throws ObjectNotFoundException {
            if (!ObserverServiceTest.this.allowedObjectId.contains(id)) {
                throw new ObjectNotFoundException("Not viewable");
            }
            return Arrays.binarySearch(ObserverServiceTest.this.allowedIdentityIds, identityId) >= 0;
        }

        public long getAudienceId(String id) throws ObjectNotFoundException {
            if (!ObserverServiceTest.this.allowedObjectId.contains(id)) {
                throw new ObjectNotFoundException("No audience");
            }
            return ObserverServiceTest.this.audienceId;
        }

        public long getSpaceId(String id) throws ObjectNotFoundException {
            if (!ObserverServiceTest.this.allowedObjectId.contains(id)) {
                throw new ObjectNotFoundException("No space");
            }
            return ObserverServiceTest.this.spaceId;
        }

        public String getObjectType() {
            return ObserverServiceTest.this.objectType;
        }
    }
}

