/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.plugin.databind;

import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.plugin.databind.SpaceTemplateDatabindPlugin;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceTemplateDatabindPluginTest {
    @Mock
    private Identity userIdentity;
    @Mock
    private SpaceTemplateService spaceTemplateService;
    @Mock
    private DatabindService databindService;
    @Mock
    private FileService fileService;
    @Mock
    private TranslationService translationService;
    @Mock
    private AttachmentService attachmentService;
    @Mock
    private UserACL userAcl;
    @Mock
    private IdentityManager identityManager;
    private SpaceTemplateDatabindPlugin spaceTemplateDatabindPlugin;

    @Before
    public void init() {
        this.spaceTemplateDatabindPlugin = new SpaceTemplateDatabindPlugin();
        this.spaceTemplateDatabindPlugin.spaceTemplateService = this.spaceTemplateService;
        this.spaceTemplateDatabindPlugin.translationService = this.translationService;
        this.spaceTemplateDatabindPlugin.fileService = this.fileService;
    }

    @Test
    public void getObjectType() {
        Assert.assertEquals((Object)"SpaceTemplate", (Object)this.spaceTemplateDatabindPlugin.getObjectType());
    }

    @Test
    public void canHandleDatabind() {
        Assert.assertTrue((boolean)this.spaceTemplateDatabindPlugin.canHandleDatabind("SpaceTemplate", "1"));
        Assert.assertFalse((boolean)this.spaceTemplateDatabindPlugin.canHandleDatabind("ObjectInstance", "1"));
    }

    @Test
    public void serialize() throws Exception {
        ZipOutputStream zipOutputStream = (ZipOutputStream)Mockito.mock(ZipOutputStream.class);
        SpaceTemplate spaceTemplate = (SpaceTemplate)Mockito.mock(SpaceTemplate.class);
        TranslationField translationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)spaceTemplate.getLayout()).thenReturn((Object)"layout");
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(Mockito.anyLong(), Mockito.anyString(), (Locale)Mockito.any(Locale.class), Mockito.anyBoolean())).thenReturn((Object)spaceTemplate);
        Mockito.when((Object)this.translationService.getTranslationField(Mockito.anyString(), Mockito.anyLong(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)translationField);
        HashMap<Locale, String> labels = new HashMap<Locale, String>();
        labels.put(Locale.getDefault(), "test");
        Mockito.when((Object)translationField.getLabels()).thenReturn(labels);
        this.spaceTemplateDatabindPlugin.serialize("1", zipOutputStream, "root");
        ((SpaceTemplateService)Mockito.verify((Object)this.spaceTemplateService, (VerificationMode)Mockito.times((int)1))).getSpaceTemplate(1L, "root", Locale.getDefault(), true);
    }

    @Test
    public void deserialize() throws Exception {
        File zipFile = this.createZipFileWithTwoJsonFiles();
        Mockito.when((Object)this.spaceTemplateService.createSpaceTemplate((SpaceTemplate)Mockito.any())).thenReturn((Object)new SpaceTemplate());
        CompletableFuture futureReport = this.spaceTemplateDatabindPlugin.deserialize(zipFile, null, "admin");
        DatabindReport report = (DatabindReport)((CompletableFuture)futureReport.thenApply(Pair::getLeft)).join();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccess());
        Assert.assertEquals((long)2L, (long)report.getProcessedItems().size());
        Assert.assertTrue((boolean)report.getProcessedItems().contains("layout1"));
        Assert.assertTrue((boolean)report.getProcessedItems().contains("layout2"));
        ((SpaceTemplateService)Mockito.verify((Object)this.spaceTemplateService, (VerificationMode)Mockito.times((int)2))).createSpaceTemplate((SpaceTemplate)Mockito.any());
    }

    private File createZipFileWithTwoJsonFiles() throws IOException {
        File tempFile = File.createTempFile("test", ".zip");
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            this.addJsonToZip(zos, "space1/config.json", "{\"name\":\"12345\",\"layout\":\"layout1\",\"names\":{\"en\":\"Test Page 1\"},\"descriptions\":{\"en\":\"Desc 1\"}}");
            this.addJsonToZip(zos, "space2/config.json", "{\"name\":\"67890\",\"layout\":\"layout2\",\"names\":{\"en\":\"Test Page 2\"},\"descriptions\":{\"en\":\"Desc 2\"}}");
        }
        return tempFile;
    }

    private void addJsonToZip(ZipOutputStream zos, String fileName, String jsonContent) throws IOException {
        ZipEntry entry = new ZipEntry(fileName);
        zos.putNextEntry(entry);
        zos.write(jsonContent.getBytes());
        zos.closeEntry();
    }
}

