/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.upgrade;

import io.meeds.social.notification.upgrade.NotificationUpgradePlugin$AjcClosure1;
import io.meeds.social.notification.upgrade.NotificationUpgradePlugin$AjcClosure3;
import io.meeds.social.notification.upgrade.NotificationUpgradePlugin$AjcClosure5;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotificationUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG;
    private static final String NOTIFICATION_PLUGIN_ID_LIKE_PARAM = "pluginIdPart";
    private static final String NOTIFICATION_PLUGIN_ID_CONCAT_PARAM = "pluginIdToConcat";
    private static final String NOTIFICATION_CHANNEL_IDS_PARAM = "channelIds";
    private static final String COUNT_UPGRADED_USERS_QUERY = "SELECT COUNT(DISTINCT s.context.id) FROM SettingsEntity s WHERE s.value LIKE :pluginIdPart";
    private static final String COUNT_NOT_UPGRADED_USERS_QUERY = "SELECT COUNT(DISTINCT s.context.id) FROM SettingsEntity s WHERE s.name LIKE 'exo:%Channel' AND s.value NOT LIKE :pluginIdPart";
    private static final String UPGRADE_USERS_NOTIFICATIONS_QUERY = "UPDATE SettingsEntity s SET s.value = CONCAT(s.value, :pluginIdToConcat) WHERE s.name IN (:channelIds) AND s.value NOT LIKE :pluginIdPart";
    private EntityManagerService entityManagerService;
    private UserSettingService userSettingService;
    private String notificationChannelId;
    private String notificationPluginId;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public NotificationUpgradePlugin(EntityManagerService entityManagerService, UserSettingService userSettingService, SettingService settingService, InitParams initParams) {
        super(settingService, initParams);
        this.entityManagerService = entityManagerService;
        this.userSettingService = userSettingService;
        this.notificationChannelId = this.getParamValue(initParams, "notificationChannelId");
        this.notificationPluginId = this.getParamValue(initParams, "notificationPluginId");
    }

    public void beforeUpgrade() {
        if (PropertyManager.isDevelopping() && !StringUtils.equals((CharSequence)this.getName(), (CharSequence)this.notificationPluginId)) {
            LOG.warn("Upgrade Plugin Name '{}' should use the same name as Notification Plugin Identifier '{}'", new Object[]{this.getName(), this.notificationPluginId});
        }
    }

    public boolean isEnabled() {
        return super.isEnabled() && StringUtils.isNotBlank((CharSequence)this.notificationPluginId);
    }

    public boolean isExecuteOnlyOnce() {
        return true;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        int usersToUpgradeCount = this.countUsersToUpgrade();
        if (usersToUpgradeCount == 0) {
            LOG.debug("Notification Plugin '{}' Setting upgrade will not proceed since no user has specific Notifications settings.", new Object[]{this.notificationPluginId});
        } else {
            LOG.info("Start:: Upgrade Notification Plugin Setting '{}' for {} users.", new Object[]{this.notificationPluginId, usersToUpgradeCount});
            Set activeChannels = StringUtils.isBlank((CharSequence)this.notificationChannelId) ? this.userSettingService.getDefaultSettings().getChannelActives() : Collections.singleton(this.notificationChannelId);
            this.upgradeUsersNotifications(activeChannels);
            int upgradedUsers = this.countUpgradedUsers();
            if (upgradedUsers < usersToUpgradeCount) {
                throw new IllegalStateException(String.format("End:: Upgrade Notification Plugin Setting '%s' didn't upgraded all users settings: %s/%s", this.notificationPluginId, upgradedUsers, usersToUpgradeCount));
            }
            LOG.info("End:: Upgrade Notification Plugin Setting '{}' for {}/{} users.", new Object[]{this.notificationPluginId, upgradedUsers, usersToUpgradeCount});
        }
    }

    @ExoTransactional
    public int upgradeUsersNotifications(Set<String> channelIds) {
        Set<String> set = channelIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), set);
        Object[] objectArray = new Object[]{this, set, joinPoint};
        NotificationUpgradePlugin$AjcClosure1 notificationUpgradePlugin$AjcClosure1 = new NotificationUpgradePlugin$AjcClosure1(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(notificationUpgradePlugin$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int countUpgradedUsers() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        NotificationUpgradePlugin$AjcClosure3 notificationUpgradePlugin$AjcClosure3 = new NotificationUpgradePlugin$AjcClosure3(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(notificationUpgradePlugin$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int countUsersToUpgrade() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        NotificationUpgradePlugin$AjcClosure5 notificationUpgradePlugin$AjcClosure5 = new NotificationUpgradePlugin$AjcClosure5(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(notificationUpgradePlugin$AjcClosure5.linkClosureAndJoinPoint(69648)));
    }

    private String getParamValue(InitParams initParams, String paramName) {
        if (initParams == null || !initParams.containsKey((Object)paramName)) {
            return null;
        }
        return initParams.getValueParam(paramName).getValue();
    }

    static {
        NotificationUpgradePlugin.ajc$preClinit();
        LOG = ExoLogger.getLogger(NotificationUpgradePlugin.class);
    }

    static /* synthetic */ int upgradeUsersNotifications_aroundBody0(NotificationUpgradePlugin ajc$this, Set channelIds, JoinPoint joinPoint) {
        List<String> channelValues = channelIds.stream().map(channelId -> "exo:" + channelId + "Channel").toList();
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        Query query = entityManager.createQuery(UPGRADE_USERS_NOTIFICATIONS_QUERY);
        query.setParameter(NOTIFICATION_CHANNEL_IDS_PARAM, channelValues);
        query.setParameter(NOTIFICATION_PLUGIN_ID_LIKE_PARAM, (Object)("%" + ajc$this.notificationPluginId + "%"));
        query.setParameter(NOTIFICATION_PLUGIN_ID_CONCAT_PARAM, (Object)("," + ajc$this.notificationPluginId));
        return query.executeUpdate();
    }

    static /* synthetic */ int countUpgradedUsers_aroundBody2(NotificationUpgradePlugin ajc$this, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        TypedQuery query = entityManager.createQuery(COUNT_UPGRADED_USERS_QUERY, Long.class);
        query.setParameter(NOTIFICATION_PLUGIN_ID_LIKE_PARAM, (Object)("%" + ajc$this.notificationPluginId + "%"));
        try {
            Long queryResult = (Long)query.getSingleResult();
            return queryResult == null ? 0 : queryResult.intValue();
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    static /* synthetic */ int countUsersToUpgrade_aroundBody4(NotificationUpgradePlugin ajc$this, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        TypedQuery query = entityManager.createQuery(COUNT_NOT_UPGRADED_USERS_QUERY, Long.class);
        query.setParameter(NOTIFICATION_PLUGIN_ID_LIKE_PARAM, (Object)("%" + ajc$this.notificationPluginId + "%"));
        try {
            Long queryResult = (Long)query.getSingleResult();
            return queryResult == null ? 0 : queryResult.intValue();
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NotificationUpgradePlugin.java", NotificationUpgradePlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "upgradeUsersNotifications", "io.meeds.social.notification.upgrade.NotificationUpgradePlugin", "java.util.Set", NOTIFICATION_CHANNEL_IDS_PARAM, "", "int"), 136);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "countUpgradedUsers", "io.meeds.social.notification.upgrade.NotificationUpgradePlugin", "", "", "", "int"), 147);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "countUsersToUpgrade", "io.meeds.social.notification.upgrade.NotificationUpgradePlugin", "", "", "", "int"), 160);
    }
}

