/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class ActivityMentionMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        ActivityMentionMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        ActivityMentionMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityMentionPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"ActivityMentionPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"ActivityMentionPlugin"));
    }

    public void testActivityMention() throws Exception {
        this.makeActivity(this.maryIdentity, "hello @john and @demo");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        NotificationInfo mentionNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.demoIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, "You were mentioned by " + this.maryIdentity.getProfile().getFullName());
        this.assertBody(info, "New mention of you");
    }

    public void TestCommentMention() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.maryIdentity, "mary post activity on root stream");
        this.assertMadeMailDigestNotifications(1);
        this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        this.notificationService.clearAll();
        this.makeComment(activity, this.demoIdentity, "hello @john and @root");
        this.assertMadeMailDigestNotifications(4);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        NotificationInfo commentNotification = list.get(3);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(commentNotification.setTo(this.johnIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, "You were mentioned by " + this.demoIdentity.getProfile().getFullName());
        this.assertBody(info, "New mention of you");
    }

    public void testDigest() throws Exception {
        ArrayList<NotificationInfo> toJohn = new ArrayList<NotificationInfo>();
        ExoSocialActivity maryActivity = this.makeActivity(this.maryIdentity, "mary mention @john and @demo");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list.get(0));
        this.notificationService.clearAll();
        this.makeComment(maryActivity, this.demoIdentity, "demo mention @john");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list1 = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list1.get(0));
        this.notificationService.clearAll();
        this.makeComment(this.activityManager.getActivity(maryActivity.getId()), this.rootIdentity, "root mention @john");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list2 = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list2.get(0));
        this.notificationService.clearAll();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        toJohn.set(0, ((NotificationInfo)toJohn.get(0)).setTo(this.johnIdentity.getRemoteId()));
        ctx.setNotificationInfos(toJohn);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("mary") + ", " + this.getFullName("demo") + ", " + this.getFullName("root") + " have mentioned you in an activity: mary mention " + this.getFullName("john") + " and " + this.getFullName("demo"));
    }

    public void testDigestWithDuplicateUser() throws Exception {
        ArrayList<NotificationInfo> toJohn = new ArrayList<NotificationInfo>();
        ExoSocialActivity maryActivity = this.makeActivity(this.maryIdentity, "mary mention @john and @demo");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list.get(0));
        this.notificationService.clearAll();
        this.makeComment(maryActivity, this.demoIdentity, "demo mention @john");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list1 = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list1.get(0));
        this.notificationService.clearAll();
        this.makeComment(this.activityManager.getActivity(maryActivity.getId()), this.demoIdentity, "root mention @john");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list2 = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list2.get(0));
        this.notificationService.clearAll();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        toJohn.set(0, ((NotificationInfo)toJohn.get(0)).setTo(this.johnIdentity.getRemoteId()));
        ctx.setNotificationInfos(toJohn);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("mary") + ", " + this.getFullName("demo") + " have mentioned you in an activity: mary mention " + this.getFullName("john") + " and " + this.getFullName("demo"));
    }

    public void testDigestWithDeletedActivity() throws Exception {
        ArrayList<NotificationInfo> toJohn = new ArrayList<NotificationInfo>();
        ExoSocialActivity maryActivity = this.makeActivity(this.maryIdentity, "mary mention @john and @demo");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list.get(0));
        this.notificationService.clearAll();
        ExoSocialActivity demoComment = this.makeComment(maryActivity, this.demoIdentity, "demo mention @john");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list1 = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list1.get(0));
        this.notificationService.clearAll();
        this.makeComment(this.activityManager.getActivity(maryActivity.getId()), this.rootIdentity, "root mention @john");
        this.end();
        this.begin();
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list2 = this.assertMadeMailDigestNotifications(this.johnIdentity.getRemoteId(), 1);
        toJohn.add(list2.get(0));
        this.notificationService.clearAll();
        this.activityManager.deleteComment(maryActivity, demoComment);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        toJohn.set(0, ((NotificationInfo)toJohn.get(0)).setTo(this.johnIdentity.getRemoteId()));
        ctx.setNotificationInfos(toJohn);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("mary") + ", " + this.getFullName("root") + " have mentioned you in an activity: mary mention " + this.getFullName("john") + " and " + this.getFullName("demo"));
    }
}

