/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class LikeCommentMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        LikeCommentMailBuilderTest.assertNotNull((Object)channel);
        LikeCommentMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"LikeCommentPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"LikeCommentPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"LikeCommentPlugin"));
    }

    public void testSimpleCase() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        ExoSocialActivity comment = this.makeComment(activity, this.rootIdentity, this.getName());
        this.activityManager.saveLike(comment, this.demoIdentity);
        this.assertMadeMailDigestNotifications(1);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo likeNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(likeNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, this.getFullName("demo") + " likes your comment testSimpleCase");
        this.assertBody(info, "New like on your activity stream");
    }

    public void testDigest() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        ExoSocialActivity comment = this.makeComment(activity, this.rootIdentity, this.getName());
        this.activityManager.saveLike(comment, this.maryIdentity);
        this.activityManager.saveLike(comment, this.demoIdentity);
        this.activityManager.saveLike(comment, this.johnIdentity);
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 3);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("mary") + ", " + this.getFullName("demo") + ", " + this.getFullName("john") + " have liked your comment: testDigest");
    }

    public void testDigestWithUnLike() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        ExoSocialActivity comment = this.makeComment(activity, this.rootIdentity, this.getName());
        this.notificationService.clearAll();
        this.assertMadeMailDigestNotifications(0);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 0);
        this.activityManager.saveLike(comment, this.demoIdentity);
        this.activityManager.saveLike(comment, this.johnIdentity);
        this.assertMadeMailDigestNotifications(2);
        list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        this.activityManager.deleteLike(comment, this.johnIdentity);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("demo") + " has liked your comment: testDigestWithUnLike");
    }
}

