/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.social.notification.AbstractPluginTest;

public class ReceiveRequestMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        ReceiveRequestMailBuilderTest.assertNotNull((Object)channel);
        ReceiveRequestMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"RelationshipReceivedRequestPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"RelationshipReceivedRequestPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"RelationshipReceivedRequestPlugin"));
    }

    public void testSimpleCase() throws Exception {
        this.makeRelationship(this.demoIdentity, this.rootIdentity);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo ntf = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(ntf.setTo("root"));
        MessageInfo message = this.buildMessageInfo(ctx);
        this.assertBody(message, "New connection request");
        this.assertSubject(message, this.demoIdentity.getProfile().getFullName() + " wants to connect with you on " + MailUtils.getSenderName());
        this.notificationService.clearAll();
    }

    public void testDigestWithPluginON() throws Exception {
        this.turnOFF(this.getPlugin());
        this.makeRelationship(this.johnIdentity, this.rootIdentity);
        this.assertMadeMailDigestNotifications(0);
        this.turnON(this.getPlugin());
        this.makeRelationship(this.demoIdentity, this.rootIdentity);
        this.makeRelationship(this.maryIdentity, this.rootIdentity);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        for (NotificationInfo m : list) {
            m.setTo(this.rootIdentity.getRemoteId());
            messages.add(m);
        }
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "You've received a connection request from " + this.getFullName("demo") + ", " + this.getFullName("mary") + ".");
        this.notificationService.clearAll();
    }

    public void testDigestWithFeatureON() throws Exception {
        this.turnFeatureOff();
        this.makeRelationship(this.demoIdentity, this.rootIdentity);
        this.assertMadeMailDigestNotifications(0);
        this.turnFeatureOn();
        this.makeRelationship(this.johnIdentity, this.rootIdentity);
        this.makeRelationship(this.maryIdentity, this.rootIdentity);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        for (NotificationInfo m : list) {
            m.setTo(this.rootIdentity.getRemoteId());
            messages.add(m);
        }
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "You've received a connection request from " + this.getFullName("john") + ", " + this.getFullName("mary") + ".");
        this.notificationService.clearAll();
    }

    public void testDigestCancelRequest() throws Exception {
        this.makeRelationship(this.demoIdentity, this.rootIdentity);
        this.makeRelationship(this.maryIdentity, this.rootIdentity);
        this.makeRelationship(this.johnIdentity, this.rootIdentity);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 3);
        for (NotificationInfo m : list) {
            m.setTo(this.rootIdentity.getRemoteId());
            messages.add(m);
        }
        this.cancelRelationship(this.rootIdentity, this.demoIdentity);
        this.cancelRelationship(this.rootIdentity, this.johnIdentity);
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "You've received a connection request from " + this.getFullName("mary") + ".");
        this.notificationService.clearAll();
    }
}

