/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.AbstractPluginTest;

public class SpaceInvitationMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        SpaceInvitationMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        SpaceInvitationMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"SpaceInvitationPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"SpaceInvitationPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"SpaceInvitationPlugin"));
    }

    public void testSimpleCase() throws Exception {
        Space space = this.getSpaceInstance(1);
        space.setEditor(this.rootIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(1);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.maryIdentity.getRemoteId(), 1);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(list.get(0).setTo(this.rootIdentity.getRemoteId()));
        MessageInfo message = this.buildMessageInfo(ctx);
        this.assertSubject(message, "You've been invited to join " + space.getDisplayName() + " space");
        this.assertBody(message, "You've received an invitation to join");
        this.notificationService.clearAll();
    }

    public void testDigestWithPluginON() throws Exception {
        this.turnOFF(this.getPlugin());
        Space space = this.getSpaceInstance(1);
        space.setEditor(this.rootIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(0);
        this.turnON(this.getPlugin());
        Space space2 = this.getSpaceInstance(2);
        space2.setEditor(this.rootIdentity.getRemoteId());
        Space space3 = this.getSpaceInstance(3);
        space3.setEditor(this.rootIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space2, this.maryIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space3, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> ntfs = this.assertMadeMailDigestNotifications(this.maryIdentity.getRemoteId(), 2);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        for (NotificationInfo m : ntfs) {
            m.setTo(this.maryIdentity.getRemoteId());
            messages.add(m);
        }
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "You have been asked to joing the following spaces: my space 2, my space 3.");
        this.notificationService.clearAll();
    }

    public void testDigestWithFeatureON() throws Exception {
        this.turnFeatureOff();
        Space space1 = this.getSpaceInstance(1);
        space1.setEditor(this.rootIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space1, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(0);
        this.turnFeatureOn();
        Space space2 = this.getSpaceInstance(2);
        space2.setEditor(this.rootIdentity.getRemoteId());
        Space space3 = this.getSpaceInstance(3);
        space3.setEditor(this.rootIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space2, this.maryIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space3, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> ntfs = this.assertMadeMailDigestNotifications(this.maryIdentity.getRemoteId(), 2);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        for (NotificationInfo m : ntfs) {
            m.setTo(this.maryIdentity.getRemoteId());
            messages.add(m);
        }
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "You have been asked to joing the following spaces: my space 2, my space 3.");
        this.notificationService.clearAll();
    }

    public void testDigestCancelInvitation() throws Exception {
        Space space1 = this.getSpaceInstance(1);
        Space space2 = this.getSpaceInstance(2);
        Space space3 = this.getSpaceInstance(3);
        Space space4 = this.getSpaceInstance(4);
        Space space5 = this.getSpaceInstance(5);
        space1.setEditor(this.rootIdentity.getRemoteId());
        space2.setEditor(this.rootIdentity.getRemoteId());
        space3.setEditor(this.rootIdentity.getRemoteId());
        space4.setEditor(this.rootIdentity.getRemoteId());
        space5.setEditor(this.rootIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space1, this.demoIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space2, this.demoIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space3, this.demoIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space4, this.demoIdentity.getRemoteId());
        this.spaceService.addInvitedUser(space5, this.demoIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(5);
        List<NotificationInfo> ntfs = this.assertMadeMailDigestNotifications(this.demoIdentity.getRemoteId(), 5);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        for (NotificationInfo m : ntfs) {
            m.setTo(this.demoIdentity.getRemoteId());
            messages.add(m);
        }
        this.spaceService.removeInvitedUser(space2, this.demoIdentity.getRemoteId());
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "You have been asked to joing the following spaces: my space 1, my space 3, my space 4 and 1 others.");
        this.notificationService.clearAll();
    }
}

