/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityCommentMailBuilderTest
extends AbstractPluginTest {
    private static final String IMAGE_HTML = "<img data-plugin-name='insertImage' src='test' />";
    private static final String ACTIVITY_TITLE_WITH_IMAGE = "my activity's title<img data-plugin-name='insertImage' src='test' />, for today";
    private static final String ACTIVITY_TITLE = "my activity's title post today.";
    private static final String COMMENT_TITLE = "my comment's title add today.";
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        ActivityCommentMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        ActivityCommentMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityCommentPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"ActivityCommentPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"ActivityCommentPlugin"));
    }

    public void testSimpleCase() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE);
        this.assertMadeMailDigestNotifications(1);
        this.notificationService.clearAll();
        this.makeComment(activity, this.demoIdentity, COMMENT_TITLE);
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo commentNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(commentNotification.setTo(this.demoIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, this.demoIdentity.getProfile().getFullName() + " commented one of your activities");
        this.assertBody(info, "New comment on your activity");
    }

    public void testSimpleCaseInlineImage() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE_WITH_IMAGE);
        this.assertMadeMailDigestNotifications(1);
        this.notificationService.clearAll();
        this.makeComment(activity, this.demoIdentity, COMMENT_TITLE);
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo commentNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(commentNotification.setTo(this.demoIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, this.demoIdentity.getProfile().getFullName() + " commented one of your activities");
        this.assertBody(info, "New comment on your activity");
        this.assertBody(info, SocialNotificationUtils.getImagePlaceHolder((String)"en"));
    }

    public void testSimpleCaseTwoComments() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE);
        this.assertMadeMailDigestNotifications(1);
        this.notificationService.clearAll();
        this.makeComment(activity, this.maryIdentity, COMMENT_TITLE);
        this.assertMadeMailDigestNotifications(1);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo commentNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(commentNotification.setTo(this.maryIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, this.maryIdentity.getProfile().getFullName() + " commented one of your activities");
        this.assertBody(info, "New comment on your activity");
    }

    public void testDigest() throws Exception {
        ExoSocialActivity maryActivity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE);
        this.assertMadeMailDigestNotifications(1);
        this.notificationService.clearAll();
        ArrayList<NotificationInfo> toRoot = new ArrayList<NotificationInfo>();
        this.makeComment(maryActivity, this.demoIdentity, "demo add comment");
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list1 = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        toRoot.add(list1.get(0));
        this.notificationService.clearAll();
        this.makeComment(this.activityManager.getActivity(maryActivity.getId()), this.johnIdentity, "john add comment");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list2 = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        toRoot.add(list2.get(0));
        this.notificationService.clearAll();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        toRoot.set(0, ((NotificationInfo)toRoot.get(0)).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(toRoot);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("demo") + ", " + this.getFullName("john") + " have commented on your activity: my activity&#39;s title post today.demo : demo add comment...");
    }

    public void testDigestWithDeletedComment() throws Exception {
        ExoSocialActivity maryActivity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE);
        this.assertMadeMailDigestNotifications(1);
        this.notificationService.clearAll();
        ArrayList<NotificationInfo> toRoot = new ArrayList<NotificationInfo>();
        this.makeComment(maryActivity, this.demoIdentity, "demo add comment");
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list1 = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        toRoot.add(list1.get(0));
        this.notificationService.clearAll();
        ExoSocialActivity johnComment = this.makeComment(this.activityManager.getActivity(maryActivity.getId()), this.johnIdentity, "john add comment");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list2 = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        toRoot.add(list2.get(0));
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(toRoot);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("demo") + ", " + this.getFullName("john") + " have commented on your activity: my activity&#39;s title post today.demo : demo add comment...");
        this.notificationService.clearAll();
        this.activityManager.deleteComment(maryActivity, johnComment);
        this.assertMadeMailDigestNotifications(0);
    }
}

