/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.mock;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Set;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;

public class MockResourceBundleService
implements ResourceBundleService {
    private static Log LOG = ExoLogger.getLogger(MockResourceBundleService.class);
    private static final String RESOURCE_LOCATION = "jar:/";
    ConfigurationManager configurationService;
    ResourceBundle resourceBundle;
    List<String> locals = new ArrayList<String>();

    public MockResourceBundleService() {
        this.configurationService = (ConfigurationManager)CommonsUtils.getService(ConfigurationManager.class);
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = new TestResourceBundle(this);
        }
        return this.resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readTextECToListByInput(InputStream input) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Scanner scanner = new Scanner(input, "UTF-8");
        try {
            while (scanner.hasNextLine()) {
                String s = scanner.nextLine();
                list.add(s);
            }
        }
        catch (Exception exception) {
        }
        finally {
            scanner.close();
            input.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResourceBundle(String name, Locale locale) {
        String id = name.replace(".", "/") + "_" + locale.getLanguage() + ".properties";
        String defaultId = name.replace(".", "/") + "_" + String.valueOf(Locale.ENGLISH) + ".properties";
        ResourceBundle resourceBundle = this.getResourceBundle();
        if (!this.locals.contains(id)) {
            InputStream inputStream = null;
            Properties list = null;
            try {
                inputStream = this.configurationService.getInputStream(RESOURCE_LOCATION + id);
                list = new Properties();
                list.load(inputStream);
            }
            catch (Exception e) {
                LOG.warn("Could not find the resource bundle for the language {}, falling back to the default language {}", new Object[]{locale.getLanguage(), Locale.ENGLISH});
                try {
                    inputStream = this.configurationService.getInputStream(RESOURCE_LOCATION + defaultId);
                    list = new Properties();
                    list.load(inputStream);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (list != null) {
                Set<Object> keys = list.keySet();
                for (Object key : keys) {
                    ((TestResourceBundle)resourceBundle).addData(key.toString(), list.get(key).toString());
                }
            }
            this.locals.add(id);
        }
        return resourceBundle;
    }

    public ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader cl) {
        return null;
    }

    public ResourceBundle getResourceBundle(String[] name, Locale locale) {
        return null;
    }

    public ResourceBundle getResourceBundle(String[] name, Locale locale, ClassLoader cl) {
        return null;
    }

    public ResourceBundleData getResourceBundleData(String id) {
        return null;
    }

    public ResourceBundleData removeResourceBundleData(String id) {
        return null;
    }

    public void saveResourceBundle(ResourceBundleData data) {
    }

    public PageList<ResourceBundleData> findResourceDescriptions(Query q) {
        return null;
    }

    public ResourceBundleData createResourceBundleDataInstance() {
        return null;
    }

    public String[] getSharedResourceBundleNames() {
        return null;
    }

    private class TestResourceBundle
    extends ResourceBundle {
        private Map<String, String> data = new HashMap<String, String>();

        private TestResourceBundle(MockResourceBundleService mockResourceBundleService) {
        }

        public void addData(String key, String value) {
            this.data.put(key, value);
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.data.get(key);
        }

        @Override
        protected Set<String> handleKeySet() {
            return this.data.keySet();
        }

        @Override
        public Enumeration<String> getKeys() {
            return new Enumeration<String>(){
                Iterator<String> it;
                {
                    this.it = TestResourceBundle.this.data.keySet().iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.it.hasNext();
                }

                @Override
                public String nextElement() {
                    return this.it.next();
                }
            };
        }
    }
}

