/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.AbstractPluginTest;

public class ActivitySpaceStreamMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        ActivitySpaceStreamMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        ActivitySpaceStreamMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"PostActivitySpaceStreamPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"PostActivitySpaceStreamPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"PostActivitySpaceStreamPlugin"));
    }

    public void testDigestWithDeletedActivity() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.spaceService.addMember(space, this.demoIdentity.getRemoteId());
        this.spaceService.addMember(space, this.johnIdentity.getRemoteId());
        this.spaceService.addMember(space, this.maryIdentity.getRemoteId());
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), true);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("demo post activity on space 1");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add(activity);
        ExoSocialActivityImpl activity2 = new ExoSocialActivityImpl();
        activity2.setTitle("john post activity on space 1");
        activity2.setUserId(this.johnIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity2);
        this.tearDownActivityList.add(activity2);
        this.assertMadeMailDigestNotifications(6);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
        this.tearDownActivityList.remove(activity);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("john") + " posted in my space 1.");
    }
}

