/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.AbstractPluginTest;

public class RequestJoinSpaceMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        RequestJoinSpaceMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        RequestJoinSpaceMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"RequestJoinSpacePlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"RequestJoinSpacePlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"RequestJoinSpacePlugin"));
    }

    public void testSimpleCase() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.spaceService.addPendingUser(space, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(1);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo ntf = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(ntf.setTo(this.rootIdentity.getRemoteId()));
        MessageInfo message = this.buildMessageInfo(ctx);
        this.assertSubject(message, this.maryIdentity.getProfile().getFullName() + " has requested access to my space 1...");
        this.assertBody(message, "New access requirement to your space");
        this.notificationService.clearAll();
    }

    public void testDigestWithPluginON() throws Exception {
        this.turnOFF(this.getPlugin());
        Space space = this.getSpaceInstance(1);
        this.spaceService.addPendingUser(space, this.demoIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(0);
        this.turnON(this.getPlugin());
        this.spaceService.addPendingUser(space, this.johnIdentity.getRemoteId());
        this.spaceService.addPendingUser(space, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        for (NotificationInfo m : list) {
            m.setTo(this.rootIdentity.getRemoteId());
            messages.add(m);
        }
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "The following users have asked to join the my space 1 space: " + this.getFullName("john") + ", " + this.getFullName("mary") + ".");
        this.notificationService.clearAll();
    }

    public void testDigestWithFeatureON() throws Exception {
        this.turnFeatureOff();
        Space space = this.getSpaceInstance(1);
        this.spaceService.addPendingUser(space, this.demoIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(0);
        this.turnFeatureOn();
        this.spaceService.addPendingUser(space, this.johnIdentity.getRemoteId());
        this.spaceService.addPendingUser(space, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        for (NotificationInfo m : list) {
            m.setTo(this.rootIdentity.getRemoteId());
            messages.add(m);
        }
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "The following users have asked to join the my space 1 space: " + this.getFullName("john") + ", " + this.getFullName("mary") + ".");
        this.notificationService.clearAll();
    }

    public void testDigestCancelRequest() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.spaceService.addPendingUser(space, this.demoIdentity.getRemoteId());
        this.spaceService.addPendingUser(space, this.johnIdentity.getRemoteId());
        this.spaceService.addPendingUser(space, this.maryIdentity.getRemoteId());
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 3);
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        for (NotificationInfo m : list) {
            m.setTo(this.rootIdentity.getRemoteId());
            messages.add(m);
        }
        this.spaceService.removePendingUser(space, this.johnIdentity.getRemoteId());
        StringWriter writer = new StringWriter();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfos(messages);
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "The following users have asked to join the my space 1 space: " + this.getFullName("demo") + ", " + this.getFullName("mary") + ".");
        this.notificationService.clearAll();
    }
}

