/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web.twitter;

import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.twitter.TwitterAccessTokenContext;
import io.meeds.oauth.twitter.TwitterProcessor;
import io.meeds.oauth.utils.OAuthUtils;
import io.meeds.oauth.web.OAuthProviderFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

public class TwitterFilter
extends OAuthProviderFilter<TwitterAccessTokenContext> {
    @Override
    protected OAuthProviderType<TwitterAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("TWITTER", TwitterAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_twitterRequestToken");
    }

    @Override
    protected OAuthPrincipal<TwitterAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<TwitterAccessTokenContext> interactionState) {
        User twitterUser;
        TwitterAccessTokenContext accessTokenContext = interactionState.getAccessTokenContext();
        Twitter twitter = ((TwitterProcessor)this.getOauthProviderProcessor()).getAuthorizedTwitterInstance(accessTokenContext);
        try {
            twitterUser = twitter.verifyCredentials();
        }
        catch (TwitterException te) {
            throw new OAuthException(OAuthExceptionCode.TWITTER_ERROR, "Error when obtaining user", (Throwable)te);
        }
        OAuthPrincipal<TwitterAccessTokenContext> oauthPrincipal = OAuthUtils.convertTwitterUserToOAuthPrincipal(twitterUser, accessTokenContext, this.getOAuthProvider());
        return oauthPrincipal;
    }
}

