/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.spi;

import io.meeds.oauth.spi.AccessTokenContext;
import io.meeds.oauth.spi.OAuthPrincipalProcessor;
import io.meeds.oauth.spi.OAuthProviderProcessor;
import io.meeds.oauth.utils.OAuthUtils;

public class OAuthProviderType<T extends AccessTokenContext> {
    private final String key;
    private final boolean enabled;
    private final String userNameAttrName;
    private final OAuthProviderProcessor<T> oauthProviderProcessor;
    private final OAuthPrincipalProcessor oauthPrincipalProcessor;
    private final String initOAuthURL;
    private final String friendlyName;

    public OAuthProviderType(String key, boolean enabled, String userNameAttrName, OAuthProviderProcessor<T> oauthProviderProcessor, OAuthPrincipalProcessor principalProcessor, String initOAuthURL, String friendlyName) {
        this.key = key;
        this.enabled = enabled;
        this.userNameAttrName = userNameAttrName;
        this.oauthProviderProcessor = oauthProviderProcessor;
        this.oauthPrincipalProcessor = principalProcessor;
        this.initOAuthURL = initOAuthURL;
        this.friendlyName = friendlyName;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUserNameAttrName() {
        return this.userNameAttrName;
    }

    public OAuthProviderProcessor<T> getOauthProviderProcessor() {
        return this.oauthProviderProcessor;
    }

    public OAuthPrincipalProcessor getOauthPrincipalProcessor() {
        return this.oauthPrincipalProcessor;
    }

    public String getInitOAuthURL(String contextPath, String requestURI) {
        requestURI = OAuthUtils.encodeParam(requestURI);
        return contextPath + this.initOAuthURL + "?_oauthInteraction=start&_initialURI=" + requestURI;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String toString() {
        return "OAuthProviderType [ " + ("key=" + this.key) + (", enabled=" + this.enabled) + (", userNameAttrName=" + this.userNameAttrName) + (", oauthProviderProcessor=" + String.valueOf(this.oauthProviderProcessor)) + (", oauthPrincipalProcessor=" + String.valueOf(this.oauthPrincipalProcessor)) + (", initOAuthURL=" + this.initOAuthURL) + (", friendlyName=" + this.friendlyName) + " ]";
    }
}

