/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.utils;

import com.google.api.services.oauth2.model.Userinfo;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.facebook.FacebookAccessTokenContext;
import io.meeds.oauth.google.GoogleAccessTokenContext;
import io.meeds.oauth.openid.OpenIdAccessTokenContext;
import io.meeds.oauth.social.FacebookPrincipal;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.twitter.TwitterAccessTokenContext;
import io.meeds.oauth.utils.HttpResponseContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthUtils {
    private OAuthUtils() {
    }

    public static OAuthPrincipal<FacebookAccessTokenContext> convertFacebookPrincipalToOAuthPrincipal(FacebookPrincipal facebookPrincipal, String avatar, OAuthProviderType<FacebookAccessTokenContext> facebookProviderType, FacebookAccessTokenContext fbAccessTokenContext) {
        return new OAuthPrincipal<FacebookAccessTokenContext>(null, facebookPrincipal.getFirstName(), facebookPrincipal.getLastName(), facebookPrincipal.getAttribute("name"), facebookPrincipal.getEmail(), avatar, fbAccessTokenContext, facebookProviderType);
    }

    public static OAuthPrincipal<TwitterAccessTokenContext> convertTwitterUserToOAuthPrincipal(twitter4j.User twitterUser, TwitterAccessTokenContext accessToken, OAuthProviderType<TwitterAccessTokenContext> twitterProviderType) {
        String lastName;
        String firstName;
        String fullName = twitterUser.getName();
        String avatar = twitterUser.getBiggerProfileImageURL();
        int spaceIndex = fullName.lastIndexOf(32);
        if (spaceIndex != -1) {
            firstName = fullName.substring(0, spaceIndex);
            lastName = fullName.substring(spaceIndex + 1);
        } else {
            firstName = fullName;
            lastName = null;
        }
        return new OAuthPrincipal<TwitterAccessTokenContext>(twitterUser.getScreenName(), firstName, lastName, fullName, null, avatar, accessToken, twitterProviderType);
    }

    public static OAuthPrincipal<GoogleAccessTokenContext> convertGoogleInfoToOAuthPrincipal(Userinfo userInfo, GoogleAccessTokenContext accessToken, OAuthProviderType<GoogleAccessTokenContext> googleProviderType) {
        return new OAuthPrincipal<GoogleAccessTokenContext>(null, userInfo.getGivenName(), userInfo.getFamilyName(), userInfo.getName(), userInfo.getEmail(), userInfo.getPicture(), accessToken, googleProviderType);
    }

    public static OAuthPrincipal<OpenIdAccessTokenContext> convertOpenIdInfoToOAuthPrincipal(JSONObject userInfo, OpenIdAccessTokenContext accessTokenContext, OAuthProviderType<OpenIdAccessTokenContext> openIdProviderType) {
        try {
            String email;
            String string = email = userInfo.has("email") ? userInfo.getString("email") : accessTokenContext.getCustomClaims().get("email");
            if (email == null) {
                throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, "Error when reading user info, the email is not present, so we are unable to identify the user.");
            }
            String givenName = userInfo.has("given_name") ? userInfo.getString("given_name") : accessTokenContext.getCustomClaims().get("given_name");
            String familyName = userInfo.has("family_name") ? userInfo.getString("family_name") : accessTokenContext.getCustomClaims().get("family_name");
            Object name = userInfo.has("name") ? userInfo.getString("name") : givenName + " " + familyName;
            String picture = userInfo.has("picture") ? userInfo.getString("picture") : null;
            HashMap<String, String> customClaims = new HashMap<String, String>();
            if (userInfo.has("custom_claims")) {
                JSONArray customClaimsArray = userInfo.getJSONArray("custom_claims");
                for (int i = 0; i < customClaimsArray.length(); ++i) {
                    JSONObject customClaim = customClaimsArray.getJSONObject(i);
                    customClaim.toMap().entrySet().stream().forEach(entry -> customClaims.put((String)entry.getKey(), entry.getValue().toString()));
                }
            }
            return new OAuthPrincipal<OpenIdAccessTokenContext>(null, givenName, familyName, (String)name, email, picture, accessTokenContext, openIdProviderType, customClaims);
        }
        catch (JSONException jsonException) {
            throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Error during user info reading: response format is ko");
        }
    }

    public static User convertOAuthPrincipalToGateInUser(OAuthPrincipal principal) {
        UserImpl gateinUser = new UserImpl(OAuthUtils.refineUserName(principal.getUserName()));
        gateinUser.setFirstName(principal.getFirstName());
        gateinUser.setLastName(principal.getLastName());
        gateinUser.setEmail(principal.getEmail());
        gateinUser.setDisplayName(principal.getDisplayName());
        return gateinUser;
    }

    public static String getURLToRedirectAfterLinkAccount(HttpServletRequest request, HttpSession session) {
        String urlToRedirect = (String)session.getAttribute("_urlToRedirectAfterLinkSocialAccount");
        if (urlToRedirect == null) {
            urlToRedirect = request.getContextPath();
        } else {
            session.removeAttribute("_urlToRedirectAfterLinkSocialAccount");
        }
        return urlToRedirect;
    }

    public static String createQueryString(Map<String, String> params) {
        StringBuilder queryString = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String encodedParamValue;
            String paramName = entry.getKey();
            String paramValue = entry.getValue();
            if (first) {
                first = false;
            } else {
                queryString.append("&");
            }
            queryString.append(paramName).append("=");
            try {
                if (paramValue == null) {
                    throw new RuntimeException("paramValue is null for paramName=" + paramName);
                }
                encodedParamValue = URLEncoder.encode(paramValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, (Throwable)e);
            }
            queryString.append(encodedParamValue);
        }
        return queryString.toString();
    }

    public static String encodeParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, (Throwable)uee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponseContext readUrlContent(URLConnection connection) throws IOException {
        StringBuilder result = new StringBuilder();
        HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
        int statusCode = httpURLConnection.getResponseCode();
        try (Reader reader = null;){
            int nrOfChars;
            try {
                reader = new InputStreamReader(connection.getInputStream());
            }
            catch (IOException ioe) {
                if (httpURLConnection.getErrorStream() != null) {
                    reader = new InputStreamReader(httpURLConnection.getErrorStream());
                }
                HttpResponseContext httpResponseContext = new HttpResponseContext(statusCode, "");
                if (reader != null) {
                    reader.close();
                }
                return httpResponseContext;
            }
            char[] buffer = new char[50];
            while ((nrOfChars = reader.read(buffer)) != -1) {
                result.append(buffer, 0, nrOfChars);
            }
            String response = result.toString();
            HttpResponseContext httpResponseContext = new HttpResponseContext(statusCode, response);
            return httpResponseContext;
        }
    }

    public static Map<String, String> formUrlDecode(String encodedData) {
        String[] elements;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String element : elements = encodedData.split("&")) {
            String paramValue;
            String paramName;
            String[] pair = element.split("=");
            if (pair.length == 2) {
                paramName = pair[0];
                try {
                    paramValue = URLDecoder.decode(pair[1], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new RuntimeException("Unexpected name-value pair in response: " + element);
            }
            params.put(paramName, paramValue);
        }
        return params;
    }

    public static String refineUserName(String username) {
        String ALLOWED_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012456789._";
        int replaced = 95;
        if (username == null || username.isEmpty()) {
            return "";
        }
        char[] chars = username.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012456789._".indexOf(chars[i]) != -1) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }
}

