/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpacesAdministrationService;

public class MockSpacesAdministrationService
implements SpacesAdministrationService {
    private List<MembershipEntry> spacesAdministrators = new ArrayList<MembershipEntry>();

    public List<MembershipEntry> getSpacesAdministratorsMemberships() {
        return this.spacesAdministrators;
    }

    public void updateSpacesAdministratorsMemberships(List<MembershipEntry> permissionsExpressions) {
        if (permissionsExpressions != null) {
            this.spacesAdministrators = new ArrayList<MembershipEntry>(permissionsExpressions);
        } else {
            this.spacesAdministrators.clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuperManager(String username) {
        UserACL userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        if (StringUtils.isBlank((CharSequence)username)) return false;
        if (IdentityConstants.ANONIM.equals(username)) return false;
        if (IdentityConstants.SYSTEM.equals(username)) {
            return false;
        }
        if (username.equals(userAcl.getSuperUser())) {
            return true;
        }
        Identity identity = userAcl.getUserIdentity(username);
        if (identity == null) return false;
        if (identity.isMemberOf(userAcl.getAdminGroups())) return true;
        if (!this.getSpacesAdministratorsMemberships().stream().anyMatch(arg_0 -> ((Identity)identity).isMemberOf(arg_0))) return false;
        return true;
    }
}

