/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.favorite;

import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.plugin.ActivityFavoriteACLPlugin;
import org.exoplatform.social.core.plugin.SpaceFavoriteACLPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.FavoriteACLPlugin;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.rest.impl.favorite.FavoriteRest;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class FavoriteRestTest
extends AbstractResourceTest {
    private Identity johnIdentity;
    private Identity maryIdentity;
    private MetadataService metadataService;
    private SpaceService spaceService;
    private ActivityManager activityManager;
    private MetadataDAO metadataDAO;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        FavoriteService favoriteService = (FavoriteService)this.getContainer().getComponentInstanceOfType(FavoriteService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        try {
            InitParams params = new InitParams();
            ObjectParameter parameter = new ObjectParameter();
            parameter.setName("metadataType");
            parameter.setObject((Object)FavoriteService.METADATA_TYPE);
            params.addParameter((Parameter)parameter);
            this.metadataService.addMetadataTypePlugin(new MetadataTypePlugin(params));
            SpaceFavoriteACLPlugin favoriteACLPlugin = new SpaceFavoriteACLPlugin(this.spaceService, this.identityManager);
            ActivityFavoriteACLPlugin favoriteACLPlugin1 = new ActivityFavoriteACLPlugin(this.activityManager);
            favoriteService.addFavoriteACLPlugin((FavoriteACLPlugin)favoriteACLPlugin);
            favoriteService.addFavoriteACLPlugin((FavoriteACLPlugin)favoriteACLPlugin1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.registry(new FavoriteRest(favoriteService));
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.identityManager.hardDeleteIdentity(this.johnIdentity);
        this.metadataDAO.deleteAll();
        super.tearDown();
    }

    public void testCreateFavorites() throws Exception {
        String objectType = "objectType";
        String objectId = "objectId";
        String parentObjectId = "parentObjectId";
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        this.startSessionAs(this.johnIdentity.getRemoteId());
        ContainerResponse response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId) + "?parentObjectId=" + parentObjectId, null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId), null);
        FavoriteRestTest.assertEquals((int)409, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId) + "?ignoreWhenExisting=true", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId) + "?parentObjectId=" + parentObjectId + "&ignoreWhenExisting=true", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        List metadataItemsByObject = this.metadataService.getMetadataItemsByObject(new MetadataObject(objectType, objectId));
        FavoriteRestTest.assertEquals((int)1, (int)metadataItemsByObject.size());
        MetadataItem metadataItem = (MetadataItem)metadataItemsByObject.get(0);
        FavoriteRestTest.assertEquals((long)userIdentityId, (long)metadataItem.getCreatorId());
        FavoriteRestTest.assertEquals((String)objectId, (String)metadataItem.getObjectId());
        FavoriteRestTest.assertEquals((String)objectType, (String)metadataItem.getObjectType());
        FavoriteRestTest.assertEquals((String)parentObjectId, (String)metadataItem.getParentObjectId());
    }

    public void testCreateFavoritesACL() throws Exception {
        Space space1 = new Space();
        space1.setDisplayName("space1");
        space1.setRegistration("validation");
        space1.setVisibility("public");
        space1 = this.spaceService.createSpace(space1, this.johnIdentity.getRemoteId());
        Space createdSpace = this.spaceService.getSpaceByPrettyName(space1.getPrettyName());
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(this.johnIdentity.getId());
        activity.setTitle("activity 1");
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space1.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.startSessionAs(this.maryIdentity.getRemoteId());
        ContainerResponse response = this.getResponse("POST", this.getURLResource("favorites/space/" + createdSpace.getId()) + "?parentObjectId=parentObjectId", null);
        FavoriteRestTest.assertEquals((int)401, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/activity/" + activity.getId()) + "?parentObjectId=parentObjectId", null);
        FavoriteRestTest.assertEquals((int)401, (int)response.getStatus());
        this.spaceService.addMember(space1, this.maryIdentity.getRemoteId());
        response = this.getResponse("POST", this.getURLResource("favorites/space/" + createdSpace.getId()) + "?parentObjectId=parentObjectId", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/activity/" + activity.getId()) + "?parentObjectId=parentObjectId", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testDeleteFavorite() throws Exception {
        String objectType = "objectType";
        String objectId = "objectId";
        this.startSessionAs(this.johnIdentity.getRemoteId());
        ContainerResponse response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId), null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        this.startSessionAs(this.johnIdentity.getRemoteId());
        response = this.getResponse("DELETE", this.getURLResource("favorites/" + objectType + "/" + objectId), null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("DELETE", this.getURLResource("favorites/user/name"), null);
        FavoriteRestTest.assertEquals((int)404, (int)response.getStatus());
        response = this.getResponse("DELETE", this.getURLResource("favorites/user/name") + "?ignoreNotExisting=true", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
    }
}

