/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.rest;

import io.meeds.social.cms.model.ContentLink;
import io.meeds.social.cms.model.ContentLinkList;
import io.meeds.social.cms.model.ContentObject;
import io.meeds.social.cms.model.ContentObjectIdentifier;
import io.meeds.social.cms.rest.ContentLinkRest;
import io.meeds.social.cms.service.ContentLinkService;
import io.meeds.social.util.JsonUtils;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={ContentLinkRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@RunWith(value=SpringRunner.class)
public class ContentLinkRestTest {
    private static final String REST_PATH = "/contentLinks/%s/%s?fieldName=%s";
    private static final String CONTENT_TYPE = "contentTest";
    private static final String CONTENT_ID = "contentId";
    private static final String FIELD_NAME = "description";
    private static final String TEST_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private ContentLinkService contentLinkService;
    private MockMvc mockMvc;

    @Before
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void getLinksWhenForbidden() {
        Mockito.when((Object)this.contentLinkService.getLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID, FIELD_NAME), Locale.ENGLISH, TEST_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)String.format(REST_PATH, CONTENT_TYPE, CONTENT_ID, FIELD_NAME), (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getLinks() {
        ContentLink link = new ContentLink(CONTENT_TYPE, CONTENT_ID, Locale.ENGLISH, "title", "uri");
        List<ContentLink> links = Collections.singletonList(link);
        Mockito.when((Object)this.contentLinkService.getLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID, FIELD_NAME), Locale.ENGLISH, TEST_USER)).thenReturn(links);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)String.format(REST_PATH, CONTENT_TYPE, CONTENT_ID, FIELD_NAME), (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.content().json(JsonUtils.toJsonString(links)));
    }

    @Test
    public void testSaveLinksWhenForbidden() {
        ContentObjectIdentifier link = new ContentObjectIdentifier(CONTENT_TYPE, CONTENT_ID);
        ContentLinkList linkList = new ContentLinkList(Collections.singletonList(link));
        ((ContentLinkService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.contentLinkService)).saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID, FIELD_NAME), linkList.getLinks(), TEST_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)String.format(REST_PATH, CONTENT_TYPE, CONTENT_ID, FIELD_NAME), (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)linkList)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testSaveLinks() {
        ContentObjectIdentifier link = new ContentObjectIdentifier(CONTENT_TYPE, CONTENT_ID);
        ContentLinkList linkList = new ContentLinkList(Collections.singletonList(link));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)String.format(REST_PATH, CONTENT_TYPE, CONTENT_ID, FIELD_NAME), (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)linkList)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNoContent());
        ((ContentLinkService)Mockito.verify((Object)this.contentLinkService)).saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID, FIELD_NAME), linkList.getLinks(), TEST_USER);
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)TEST_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

