/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.resource.rest;

import io.meeds.social.resource.rest.SkinRest;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={SkinRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@RunWith(value=SpringRunner.class)
public class SkinRestTest {
    private static final String SKIN_ID = "test";
    private static final String SKIN_URL = "skin-url";
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private SkinService skinService;
    @Mock
    private SkinConfig skin;
    @Mock
    private SkinURL skinUrl;
    private MockMvc mockMvc;

    @Before
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void getSkinWhenPortalAndNotFound() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/skins/portal/test", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getSkinWhenPortalSkin() throws Exception {
        Mockito.when((Object)this.skinService.getPortalSkin(SKIN_ID, null)).thenReturn((Object)this.skin);
        Mockito.when((Object)this.skin.createURL()).thenReturn((Object)this.skinUrl);
        Mockito.when((Object)this.skinUrl.toString(Orientation.LT)).thenReturn((Object)SKIN_URL);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/skins/portal/test", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().is3xxRedirection());
    }

    @Test
    public void getSkinWhenPortletSkin() throws Exception {
        Mockito.when((Object)this.skinService.getSkin("layout/test", null)).thenReturn((Object)this.skin);
        Mockito.when((Object)this.skin.createURL()).thenReturn((Object)this.skinUrl);
        Mockito.when((Object)this.skinUrl.toString(Orientation.LT)).thenReturn((Object)SKIN_URL);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/skins/layout/test", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().is3xxRedirection());
    }
}

