/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.service.rest.NotificationsRestService;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class NotificationsRestServiceTest
extends AbstractResourceTest {
    private ActivityManagerImpl activityManager;
    private SpaceService spaceService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IdentityStorage identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.activityManager = (ActivityManagerImpl)this.getContainer().getComponentInstanceOfType(ActivityManagerImpl.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        identityStorage.saveIdentity(this.rootIdentity);
        identityStorage.saveIdentity(this.johnIdentity);
        identityStorage.saveIdentity(this.maryIdentity);
        identityStorage.saveIdentity(this.demoIdentity);
        this.addResource(NotificationsRestService.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(NotificationsRestService.class);
    }

    public void testReplyActivity() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ContainerResponse response = this.service("GET", "/social/notifications/redirectUrl/reply_activity/" + activity.getId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
    }

    public void testViewFullDiscussion() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ContainerResponse response = this.service("GET", "/social/notifications/redirectUrl/view_full_activity/" + activity.getId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
    }

    public void testInviteToConnect() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/inviteToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
    }

    public void testInviteToConnectNotAuthorized() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/inviteToConnect/" + this.demoIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testInviteToConnectNotAuthorizedWhenUserIsReceiver() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/inviteToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testConfirmInvitationToConnect() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/confirmInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
    }

    public void testConfirmInvitationToConnectNotAuthorized() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/confirmInvitationToConnect/" + this.demoIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testConfirmInvitationToConnectNotAuthorizedWhenUserIsSender() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/confirmInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testIgnoreInvitationToConnect() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
    }

    public void testIgnoreInvitationToConnectNotAuthorized() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToConnect/" + this.demoIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testIgnoreInvitationToConnectNotAuthorizedWhenUserIsSender() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testAcceptInvitationToJoinSpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.restartTransaction();
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/acceptInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.restartTransaction();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertTrue((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        NotificationsRestServiceTest.assertFalse((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testAcceptInvitationToJoinSpaceNotAuthorized() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.restartTransaction();
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/acceptInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.restartTransaction();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testIgnoreInvitationToJoinSpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.restartTransaction();
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.restartTransaction();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        NotificationsRestServiceTest.assertFalse((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testIgnoreInvitationToJoinSpaceNotAuthorized() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.restartTransaction();
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.restartTransaction();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testValidateRequestToJoinSpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listPendings = Arrays.asList(space.getPendingUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listPendings.contains("james"));
        this.restartTransaction();
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/validateRequestToJoinSpace/" + space.getId() + "/james;jsessionid=0C004882C60E5BF3AB8EDCA4FD1467F1", "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.restartTransaction();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertTrue((boolean)listMembers.contains("james"));
        listPendings = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getPendingUsers());
        NotificationsRestServiceTest.assertFalse((boolean)listPendings.contains("james"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testValidateRequestToJoinSpaceNotAuthorized() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listPendings = Arrays.asList(space.getPendingUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listPendings.contains("james"));
        this.restartTransaction();
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/social/notifications/validateRequestToJoinSpace/" + space.getId() + "/james", "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.restartTransaction();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("james"));
        listPendings = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getPendingUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listPendings.contains("james"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testRedirectUrl() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ContainerResponse response = this.service("GET", "/social/notifications/redirectUrl/view_full_activity/" + activity.getId(), "", null, null);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        response = this.service("GET", "/social/notifications/redirectUrl/user/" + this.demoIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        Space space = this.getSpaceInstance(1);
        response = this.service("GET", "/social/notifications/redirectUrl/space/" + space.getId(), "", null, null);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
        this.spaceService.deleteSpace(space.getId());
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName("my_space_" + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("validation");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        Space createdSpace = this.spaceService.createSpace(space, "john");
        String[] invitedUsers = new String[]{"root"};
        String[] pendingUsers = new String[]{"james"};
        Arrays.stream(pendingUsers).forEach(u -> this.spaceService.addPendingUser(createdSpace, u));
        Arrays.stream(invitedUsers).forEach(u -> this.spaceService.addInvitedUser(createdSpace, u));
        return createdSpace;
    }
}

