/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import io.meeds.social.space.model.SpaceDirectorySettings;
import io.meeds.social.space.service.SpaceDirectoryService;
import io.meeds.social.util.JsonUtils;
import java.io.IOException;
import java.util.UUID;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class SpacesListPortlet
extends GenericDispatchedViewPortlet {
    private static final String SETTING_NAME = "name";
    private UserACL userAcl;
    private SpaceDirectoryService spaceDirectoryService;

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        boolean canModifySettings = this.canModifySettings();
        request.setAttribute("canEdit", (Object)canModifySettings);
        if (canModifySettings) {
            request.setAttribute("isPublicPage", (Object)this.isPublicPage());
        }
        super.doView(request, response);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletPreferences preferences = request.getPreferences();
        String settingName = preferences.getValue(SETTING_NAME, "");
        response.getWriter().write(settingName);
        response.setContentType("text/plain");
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (!this.canModifySettings()) {
            throw new PortletException("User is not allowed to save settings");
        }
        PortletPreferences preferences = request.getPreferences();
        String settings = request.getParameter("settings");
        preferences.setValue("settings", settings);
        String publicAccess = request.getParameter("publicAccess");
        if (StringUtils.isNotBlank((CharSequence)publicAccess) && this.isAdministrator()) {
            boolean enablePublicAccess = StringUtils.equals((CharSequence)publicAccess, (CharSequence)"true");
            if (enablePublicAccess) {
                String settingName = this.getOrCreateSettingName(preferences);
                this.getSpaceDirectoryService().saveSpacesDirectorySettings(settingName, this.getSpaceDirectorySettings(settings));
                response.setProperty("X-Setting-Name", settingName);
            } else {
                String settingName = preferences.getValue(SETTING_NAME, null);
                if (settingName != null) {
                    this.getSpaceDirectoryService().removeSpacesDirectorySettings(settingName);
                    preferences.reset(SETTING_NAME);
                }
            }
        }
        preferences.store();
        response.setPortletMode(PortletMode.VIEW);
    }

    private SpaceDirectorySettings getSpaceDirectorySettings(String settings) {
        SpaceDirectorySettings spaceDirectorySettings = (SpaceDirectorySettings)JsonUtils.fromJsonString((String)settings, SpaceDirectorySettings.class);
        Page currentPage = this.getCurrentPage();
        if (currentPage != null) {
            spaceDirectorySettings.setPageReference(currentPage.getPageKey().format());
        }
        return spaceDirectorySettings;
    }

    private String getOrCreateSettingName(PortletPreferences preferences) throws ReadOnlyException {
        String settingName = preferences.getValue(SETTING_NAME, null);
        if (StringUtils.isBlank((CharSequence)settingName)) {
            settingName = UUID.randomUUID().toString();
            preferences.setValue(SETTING_NAME, settingName);
        }
        return settingName;
    }

    private boolean canModifySettings() {
        Page currentPage = this.getCurrentPage();
        return currentPage != null && this.getUserAcl().hasEditPermission(currentPage, this.getCurrentIdentity());
    }

    private boolean isPublicPage() {
        PortalConfig site = this.getCurrentSite();
        return site != null && PortalConfig.PORTAL_TYPE.equalsIgnoreCase(site.getType()) && ("public".equals(site.getName()) || site.getAccessPermissions() != null && ArrayUtils.contains((Object[])site.getAccessPermissions(), (Object)"Everyone")) && this.getSpaceDirectoryService().isPagePublicallyAccessible(this.getCurrentPage());
    }

    private Page getCurrentPage() {
        PortalRequestContext requestContext = PortalRequestContext.getCurrentInstance();
        return requestContext == null ? null : requestContext.getPage();
    }

    private PortalConfig getCurrentSite() {
        PortalRequestContext requestContext = PortalRequestContext.getCurrentInstance();
        return requestContext == null ? null : requestContext.getPortalConfig();
    }

    private boolean isAdministrator() {
        return this.getUserAcl().isAdministrator(this.getCurrentIdentity());
    }

    private Identity getCurrentIdentity() {
        return ConversationState.getCurrent() == null ? null : ConversationState.getCurrent().getIdentity();
    }

    private UserACL getUserAcl() {
        if (this.userAcl == null) {
            this.userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        }
        return this.userAcl;
    }

    private SpaceDirectoryService getSpaceDirectoryService() {
        if (this.spaceDirectoryService == null) {
            this.spaceDirectoryService = (SpaceDirectoryService)ExoContainerContext.getService(SpaceDirectoryService.class);
        }
        return this.spaceDirectoryService;
    }
}

