/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import io.meeds.social.portlet.CMSPortlet;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.security.SecureRandom;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.rest.api.RestUtils;

public class CmsPortletWithMetadata
extends CMSPortlet {
    public static final String OBJECT_TYPE = "cmsPortlet";
    public static final String TRANSLATION_IDENTIFIER = "translationIdentifier";
    private TranslationService translationService;
    private AttachmentService attachmentService;
    private final SecureRandom random = new SecureRandom();

    protected void setViewRequestAttributes(String name, RenderRequest request, RenderResponse response) {
        Long initTranslationIdentifier;
        PortletPreferences preferences = request.getPreferences();
        String currentTranslationIdentifier = preferences.getValue(TRANSLATION_IDENTIFIER, null);
        if (currentTranslationIdentifier == null) {
            Long randomIdentifier = this.random.nextLong() & Long.MAX_VALUE;
            currentTranslationIdentifier = String.valueOf(randomIdentifier);
            this.savePreference(TRANSLATION_IDENTIFIER, currentTranslationIdentifier);
            request.setAttribute(TRANSLATION_IDENTIFIER, (Object)currentTranslationIdentifier);
        }
        Long l = initTranslationIdentifier = preferences.getValue("data.init", null) != null ? Long.valueOf(Long.parseLong(preferences.getValue("data.init", null))) : null;
        if (initTranslationIdentifier != null) {
            try {
                String finalCurrentTranslationIdentifier = currentTranslationIdentifier;
                Map translations = this.getTranslationService().getAllTranslationFields(OBJECT_TYPE, initTranslationIdentifier.longValue());
                translations.entrySet().forEach(entry -> {
                    String translationKey = (String)entry.getKey();
                    TranslationField translationField = (TranslationField)entry.getValue();
                    if (!translationField.getLabels().isEmpty()) {
                        try {
                            this.getTranslationService().saveTranslationLabels(OBJECT_TYPE, Long.parseLong(finalCurrentTranslationIdentifier), translationKey, translationField.getLabels());
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            this.getAttachmentService().copyAttachments(OBJECT_TYPE, initTranslationIdentifier.toString(), OBJECT_TYPE, currentTranslationIdentifier, null, RestUtils.getCurrentUserIdentityId());
            this.savePreference("data.init", null);
        }
    }

    private TranslationService getTranslationService() {
        if (this.translationService == null) {
            this.translationService = (TranslationService)ExoContainerContext.getService(TranslationService.class);
        }
        return this.translationService;
    }

    private AttachmentService getAttachmentService() {
        if (this.attachmentService == null) {
            this.attachmentService = (AttachmentService)ExoContainerContext.getService(AttachmentService.class);
        }
        return this.attachmentService;
    }
}

