/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure11;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure9;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.util.StorageUtil;

@Singleton
public class ProjectServiceImpl
implements ProjectService {
    private static final Log LOG;
    public static final String PREFIX_CLONE = "Copy of ";
    @Inject
    private ProjectStorage projectStorage;
    @Inject
    StatusService statusService;
    @Inject
    TaskService taskService;
    @Inject
    DAOHandler daoHandler;
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public ProjectServiceImpl() {
    }

    public ProjectServiceImpl(StatusService statusService, TaskService taskService, DAOHandler daoHandler, ProjectStorage projectStorage, ListenerService listenerService) {
        this.daoHandler = daoHandler;
        this.statusService = statusService;
        this.taskService = taskService;
        this.projectStorage = projectStorage;
        this.listenerService = listenerService;
    }

    @Override
    @ExoTransactional
    public ProjectDto createProject(ProjectDto project) {
        ProjectDto projectDto = project;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)projectDto);
        Object[] objectArray = new Object[]{this, projectDto, joinPoint};
        ProjectServiceImpl$AjcClosure1 projectServiceImpl$AjcClosure1 = new ProjectServiceImpl$AjcClosure1(objectArray);
        return (ProjectDto)ExoTransactionalAspect.aspectOf().around(projectServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public ProjectDto createProject(ProjectDto project, long parentId) throws EntityNotFoundException {
        ProjectDto projectDto = project;
        long l = parentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)projectDto, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, projectDto, Conversions.longObject((long)l), joinPoint};
        ProjectServiceImpl$AjcClosure3 projectServiceImpl$AjcClosure3 = new ProjectServiceImpl$AjcClosure3(objectArray);
        return (ProjectDto)ExoTransactionalAspect.aspectOf().around(projectServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public ProjectDto updateProject(ProjectDto proj) {
        ProjectDto projectDto = proj;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)projectDto);
        Object[] objectArray = new Object[]{this, projectDto, joinPoint};
        ProjectServiceImpl$AjcClosure5 projectServiceImpl$AjcClosure5 = new ProjectServiceImpl$AjcClosure5(objectArray);
        return (ProjectDto)ExoTransactionalAspect.aspectOf().around(projectServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void updateProjectNoReturn(ProjectDto proj) {
        ProjectDto projectDto = proj;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)projectDto);
        Object[] objectArray = new Object[]{this, projectDto, joinPoint};
        ProjectServiceImpl$AjcClosure7 projectServiceImpl$AjcClosure7 = new ProjectServiceImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(projectServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeProject(long id, boolean deleteChild) throws EntityNotFoundException {
        long l = id;
        boolean bl = deleteChild;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), Conversions.booleanObject((boolean)bl), joinPoint};
        ProjectServiceImpl$AjcClosure9 projectServiceImpl$AjcClosure9 = new ProjectServiceImpl$AjcClosure9(objectArray);
        ExoTransactionalAspect.aspectOf().around(projectServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public ProjectDto cloneProject(long id, boolean cloneTask) throws Exception {
        long l = id;
        boolean bl = cloneTask;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), Conversions.booleanObject((boolean)bl), joinPoint};
        ProjectServiceImpl$AjcClosure11 projectServiceImpl$AjcClosure11 = new ProjectServiceImpl$AjcClosure11(objectArray);
        return (ProjectDto)ExoTransactionalAspect.aspectOf().around(projectServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @Override
    public ProjectDto getProject(Long id) throws EntityNotFoundException {
        ProjectDto project = this.projectStorage.getProject(id);
        if (project == null) {
            throw new EntityNotFoundException((long)id, (Class<?>)ProjectDto.class);
        }
        return project;
    }

    @Override
    public List<ProjectDto> getSubProjects(long parentId, int offset, int limit) {
        try {
            ProjectDto parent = this.getProject(parentId);
            return this.projectStorage.getSubProjects(parentId, offset, limit);
        }
        catch (Exception ex) {
            return new ArrayList<ProjectDto>();
        }
    }

    @Override
    public List<ProjectDto> findProjects(ProjectQuery query, int offset, int limit) {
        return this.projectStorage.findProjects(query, offset, limit);
    }

    @Override
    public int countProjects(ProjectQuery query) {
        return this.projectStorage.countProjects(query);
    }

    @Override
    public List<ProjectDto> findProjects(List<String> memberships, String keyword, OrderBy order, int offset, int limit) {
        return this.projectStorage.findProjects(memberships, keyword, order, offset, limit);
    }

    @Override
    public List<ProjectDto> findCollaboratedProjects(String userName, String keyword, int offset, int limit) {
        return this.projectStorage.findCollaboratedProjects(userName, keyword, offset, limit);
    }

    @Override
    public List<ProjectDto> findNotEmptyProjects(List<String> memberships, String keyword, int offset, int limit) {
        return this.projectStorage.findNotEmptyProjects(memberships, keyword, offset, limit);
    }

    @Override
    public int countCollaboratedProjects(String userName, String keyword) {
        return this.projectStorage.countCollaboratedProjects(userName, keyword);
    }

    @Override
    public int countNotEmptyProjects(List<String> memberships, String keyword) {
        return this.projectStorage.countNotEmptyProjects(memberships, keyword);
    }

    @Override
    public int countProjects(List<String> memberships, String keyword) {
        return this.projectStorage.countProjects(memberships, keyword);
    }

    @Override
    public Set<String> getManager(long projectId) {
        return this.projectStorage.getManager(projectId);
    }

    @Override
    public Set<String> getParticipator(long projectId) {
        return this.projectStorage.getParticipator(projectId);
    }

    static {
        ProjectServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(ProjectServiceImpl.class);
    }

    static final /* synthetic */ ProjectDto createProject_aroundBody0(ProjectServiceImpl ajc$this, ProjectDto project, JoinPoint joinPoint) {
        ProjectDto proj = ajc$this.projectStorage.createProject(project);
        return proj;
    }

    static final /* synthetic */ ProjectDto createProject_aroundBody2(ProjectServiceImpl ajc$this, ProjectDto project, long parentId, JoinPoint joinPoint) {
        ProjectDto parentProject = ajc$this.projectStorage.getProject(parentId);
        if (parentProject != null) {
            project.setParent(parentProject);
            project.setParticipator(new HashSet<String>(parentProject.getParticipator()));
            project.setManager(new HashSet<String>(parentProject.getManager()));
            project.setLastModifiedDate(System.currentTimeMillis());
            project = ajc$this.createProject(project);
            List<StatusDto> prSt = ajc$this.statusService.getStatuses(parentProject.getId());
            for (StatusDto st : prSt) {
                ajc$this.statusService.createStatus(project, st.getName());
            }
            return project;
        }
        LOG.info((Object)("Can not find project for parent with ID: " + parentId));
        throw new EntityNotFoundException(parentId, (Class<?>)ProjectDto.class);
    }

    static final /* synthetic */ ProjectDto updateProject_aroundBody4(ProjectServiceImpl ajc$this, ProjectDto proj, JoinPoint joinPoint) {
        proj.setLastModifiedDate(System.currentTimeMillis());
        return ajc$this.projectStorage.updateProject(proj);
    }

    static final /* synthetic */ void updateProjectNoReturn_aroundBody6(ProjectServiceImpl ajc$this, ProjectDto proj, JoinPoint joinPoint) {
        proj.setLastModifiedDate(System.currentTimeMillis());
        ajc$this.projectStorage.updateProjectNoReturn(proj);
    }

    static final /* synthetic */ void removeProject_aroundBody8(ProjectServiceImpl ajc$this, long id, boolean deleteChild, JoinPoint joinPoint) {
        ProjectDto project = ajc$this.getProject(id);
        if (project == null) {
            throw new EntityNotFoundException(id, (Class<?>)ProjectDto.class);
        }
        ajc$this.projectStorage.removeProject(id, deleteChild);
    }

    static final /* synthetic */ ProjectDto cloneProject_aroundBody10(ProjectServiceImpl ajc$this, long id, boolean cloneTask, JoinPoint joinPoint) {
        Set<String> participators;
        ProjectDto project = ajc$this.getProject(id);
        ProjectDto newProject = project.clone(cloneTask);
        Set<String> managers = ajc$this.getManager(id);
        if (managers != null && !managers.isEmpty()) {
            newProject.setManager(managers);
        }
        if ((participators = ajc$this.getParticipator(id)) != null && !participators.isEmpty()) {
            newProject.setParticipator(participators);
        }
        newProject.setId(0L);
        newProject.setName(PREFIX_CLONE + newProject.getName());
        newProject = ajc$this.createProject(newProject);
        List<StatusDto> statuses = ajc$this.statusService.getStatuses(id);
        if (statuses != null) {
            for (StatusDto st : statuses) {
                StatusDto s = ajc$this.statusService.createStatus(newProject, st.getName());
                if (!cloneTask) continue;
                TaskQuery taskQuery = new TaskQuery();
                taskQuery.setStatus(StorageUtil.statusToEntity(st));
                for (TaskDto t : ajc$this.taskService.findTasks(taskQuery, 0, -1)) {
                    TaskDto newTask = t.clone();
                    newTask.setId(0L);
                    newTask.setStatus(s);
                    newTask.setCoworker(ajc$this.taskService.getCoworker(t.getId()));
                    newTask.setTitle(PREFIX_CLONE + newTask.getTitle());
                    ajc$this.taskService.createTask(newTask);
                }
            }
        }
        return newProject;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProjectServiceImpl.java", ProjectServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createProject", "org.exoplatform.task.service.impl.ProjectServiceImpl", "org.exoplatform.task.dto.ProjectDto", "project", "", "org.exoplatform.task.dto.ProjectDto"), 85);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createProject", "org.exoplatform.task.service.impl.ProjectServiceImpl", "org.exoplatform.task.dto.ProjectDto:long", "project:parentId", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.ProjectDto"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateProject", "org.exoplatform.task.service.impl.ProjectServiceImpl", "org.exoplatform.task.dto.ProjectDto", "proj", "", "org.exoplatform.task.dto.ProjectDto"), 120);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateProjectNoReturn", "org.exoplatform.task.service.impl.ProjectServiceImpl", "org.exoplatform.task.dto.ProjectDto", "proj", "", "void"), 127);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeProject", "org.exoplatform.task.service.impl.ProjectServiceImpl", "long:boolean", "id:deleteChild", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 134);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cloneProject", "org.exoplatform.task.service.impl.ProjectServiceImpl", "long:boolean", "id:cloneTask", "java.lang.Exception", "org.exoplatform.task.dto.ProjectDto"), 144);
    }
}

