/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.task.domain.Task;

@Entity(name="TaskChangeLog")
@ExoEntity
@Table(name="TASK_CHANGE_LOGS")
@NamedQueries(value={@NamedQuery(name="TaskChangeLog.findChangeLogByTaskId", query="SELECT log FROM TaskChangeLog log WHERE log.task.id = :taskId ORDER BY log.createdTime DESC"), @NamedQuery(name="TaskChangeLog.countChangeLogByTaskId", query="SELECT count(log) FROM TaskChangeLog log WHERE log.task.id = :taskId"), @NamedQuery(name="TaskChangeLog.removeChangeLogByTaskId", query="DELETE FROM TaskChangeLog log WHERE log.task.id = :taskId")})
public class ChangeLog
implements Comparable<ChangeLog> {
    @Id
    @SequenceGenerator(name="SEQ_TASK_CHANGE_LOG_ID", sequenceName="SEQ_TASK_CHANGE_LOG_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_CHANGE_LOG_ID")
    @Column(name="CHANGE_LOG_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="TASK_ID")
    private Task task;
    private String author;
    @Column(name="ACTION_NAME")
    private String actionName;
    private String target;
    @Column(name="CREATED_TIME")
    private long createdTime = System.currentTimeMillis();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String change) {
        this.actionName = change;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public int compareTo(ChangeLog o) {
        return (int)(this.getCreatedTime() - o.getCreatedTime());
    }

    public ChangeLog clone() {
        ChangeLog log = new ChangeLog();
        log.setId(this.getId());
        log.setTask(this.getTask().clone());
        log.setAuthor(this.getAuthor());
        log.setActionName(this.getActionName());
        log.setCreatedTime(this.getCreatedTime());
        log.setTarget(this.getTarget());
        return log;
    }
}

