/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;

@Entity(name="TaskStatus")
@Table(name="TASK_STATUS")
@NamedQueries(value={@NamedQuery(name="Status.findLowestRankStatusByProject", query="SELECT s FROM TaskStatus s WHERE s.project.id = :projectId AND s.rank = (SELECT MIN(s2.rank) FROM TaskStatus s2 WHERE s2.project.id = :projectId)"), @NamedQuery(name="Status.findHighestRankStatusByProject", query="SELECT s FROM TaskStatus s WHERE s.project.id = :projectId AND s.rank = (SELECT MAX(s2.rank) FROM TaskStatus s2 WHERE s2.project.id = :projectId)"), @NamedQuery(name="Status.findByName", query="SELECT s FROM TaskStatus s WHERE s.name = :name AND s.project.id = :projectID"), @NamedQuery(name="Status.findStatusByProject", query="SELECT s FROM TaskStatus s WHERE s.project.id = :projectId ORDER BY s.rank ASC")})
public class Status
implements Comparable<Status>,
Serializable {
    private static final long serialVersionUID = -3079376553215147896L;
    @Id
    @SequenceGenerator(name="SEQ_TASK_STATUS_STATUS_ID", sequenceName="SEQ_TASK_STATUS_STATUS_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_STATUS_STATUS_ID")
    @Column(name="STATUS_ID")
    private long id;
    private String name;
    @Column(name="STATUS_RANK")
    private Integer rank;
    @OneToMany(mappedBy="status", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Task> tasks;
    @ManyToOne
    @JoinColumn(name="PROJECT_ID")
    private Project project;

    public Status() {
    }

    public Status(long id, String name) {
        this.id = id;
        this.name = name;
    }

    public Status(long id, String name, Integer rank, Project project) {
        this.id = id;
        this.name = name;
        this.rank = rank;
        this.project = project;
    }

    public Status(String name, Integer rank, Project project) {
        this.name = name;
        this.rank = rank;
        this.project = project;
    }

    public Status clone() {
        return new Status(this.getId(), this.getName(), this.getRank(), this.getProject().clone());
    }

    @Override
    public int compareTo(Status o) {
        if (this.getRank() == null) {
            return o.getRank() == null ? 0 : -1;
        }
        if (o.getRank() == null) {
            return 1;
        }
        return this.getRank().compareTo(o.getRank());
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getRank() {
        return this.rank;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRank(Integer rank) {
        this.rank = rank;
    }

    @Generated
    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Status)) {
            return false;
        }
        Status other = (Status)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Integer this$rank = this.getRank();
        Integer other$rank = other.getRank();
        if (this$rank == null ? other$rank != null : !((Object)this$rank).equals(other$rank)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Status;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        Integer $rank = this.getRank();
        result = result * 59 + ($rank == null ? 43 : ((Object)$rank).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Status(id=" + this.getId() + ", name=" + this.getName() + ", rank=" + this.getRank() + ", tasks=" + String.valueOf(this.getTasks()) + ", project=" + String.valueOf(this.getProject()) + ")";
    }
}

