/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.task.AbstractTest;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.LabelHandler;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.util.ListUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLabelDAO
extends AbstractTest {
    private LabelHandler lblDAO;
    private DAOHandler taskService;
    private final String username = "root";

    @Before
    public void setup() {
        PortalContainer container = PortalContainer.getInstance();
        this.taskService = (DAOHandler)container.getComponentInstanceOfType(DAOHandler.class);
        this.lblDAO = this.taskService.getLabelHandler();
    }

    @After
    public void tearDown() {
        this.deleteAll();
    }

    @Test
    public void testAddTask() throws Exception {
        Project project = new Project();
        project.setName("project");
        this.taskService.getProjectHandler().create((Object)project);
        Label label = new Label("test label", "root", project);
        label = (Label)this.lblDAO.create((Object)label);
        Task task = new Task();
        task.setTitle("task1");
        this.taskService.getTaskHandler().create((Object)task);
        LabelTaskMapping map = new LabelTaskMapping(label, task);
        this.taskService.getLabelTaskMappingHandler().create((Object)map);
        ListAccess tasks = this.taskService.getTaskHandler().findTasksByLabel(0L, null, "root", null);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
    }

    @Test
    public void testRemoveTask() throws Exception {
        Project project = new Project();
        project.setName("project");
        this.taskService.getProjectHandler().create((Object)project);
        Label label = new Label("test label", "root", project);
        label = (Label)this.lblDAO.create((Object)label);
        Task task = new Task();
        task.setTitle("test");
        this.taskService.getTaskHandler().create((Object)task);
        LabelTaskMapping map = new LabelTaskMapping(label, task);
        this.taskService.getLabelTaskMappingHandler().create((Object)map);
        ListAccess tasks = this.taskService.getTaskHandler().findTasksByLabel(label.getId(), null, "root", null);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        this.endRequestLifecycle();
        this.initializeContainerAndStartRequestLifecycle();
        this.lblDAO.delete((Object)((Label)this.lblDAO.find((Serializable)Long.valueOf(label.getId()))));
        tasks = this.taskService.getTaskHandler().findTasksByLabel(label.getId(), null, "root", null);
        Assert.assertEquals((long)0L, (long)tasks.getSize());
    }

    @Test
    public void testUpdate() {
        Project project = new Project();
        project.setName("project");
        this.taskService.getProjectHandler().create((Object)project);
        Label label = new Label("test label", "root", project);
        label = (Label)this.lblDAO.create((Object)label);
        Assert.assertNotNull((Object)label);
        label = (Label)this.lblDAO.find((Serializable)Long.valueOf(label.getId()));
        Assert.assertNotNull((Object)label);
        label.setColor("white");
        this.lblDAO.update((Object)label);
        label = (Label)this.lblDAO.find((Serializable)Long.valueOf(label.getId()));
        Assert.assertEquals((Object)"white", (Object)label.getColor());
        label.setName("label2");
        this.lblDAO.update((Object)label);
        label = (Label)this.lblDAO.find((Serializable)Long.valueOf(label.getId()));
        Assert.assertEquals((Object)"label2", (Object)label.getName());
        Label parent = new Label("parent label", "root", project);
        this.lblDAO.create((Object)parent);
        label.setParent(parent);
        this.lblDAO.update((Object)label);
        label = (Label)this.lblDAO.find((Serializable)Long.valueOf(label.getId()));
        Assert.assertEquals((long)parent.getId(), (long)label.getParent().getId());
    }

    @Test
    public void testFindLabelByTask() throws Exception {
        Project project = new Project();
        project.setName("project1");
        this.taskService.getProjectHandler().create((Object)project);
        Status status = new Status();
        status.setName("status1");
        status.setRank(Integer.valueOf(1));
        status.setProject(project);
        this.taskService.getStatusHandler().create((Object)status);
        Task task = new Task();
        task.setTitle("task1");
        task.setStatus(status);
        this.taskService.getTaskHandler().create((Object)task);
        Label label1 = new Label("test label1", "root", project);
        this.lblDAO.create((Object)label1);
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(label1);
        mapping.setTask(task);
        this.taskService.getLabelTaskMappingHandler().create((Object)mapping);
        Assert.assertEquals((long)1L, (long)this.lblDAO.findLabelsByTask(task.getId().longValue(), project.getId()).getSize());
    }

    @Test
    public void testRemoveLabel() throws Exception {
        Project project = new Project();
        project.setName("project");
        this.taskService.getProjectHandler().create((Object)project);
        Task task = new Task();
        task.setTitle("task1");
        this.taskService.getTaskHandler().create((Object)task);
        Task task2 = new Task();
        task2.setTitle("task2");
        this.taskService.getTaskHandler().create((Object)task2);
        Label label1 = new Label("test label1", "root", project);
        this.lblDAO.create((Object)label1);
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(label1);
        mapping.setTask(task);
        LabelTaskMapping mapping2 = new LabelTaskMapping();
        mapping2.setLabel(label1);
        mapping2.setTask(task2);
        this.taskService.getLabelTaskMappingHandler().create((Object)mapping);
        this.taskService.getLabelTaskMappingHandler().create((Object)mapping2);
        this.endRequestLifecycle();
        this.initializeContainerAndStartRequestLifecycle();
        Assert.assertNotNull((Object)this.lblDAO.find((Serializable)Long.valueOf(label1.getId())));
        ListAccess tasks = this.taskService.getTaskHandler().findTasksByLabel(label1.getId(), null, "root", null);
        Assert.assertEquals((long)2L, (long)tasks.getSize());
        this.lblDAO.delete((Object)((Label)this.lblDAO.find((Serializable)Long.valueOf(label1.getId()))));
        Assert.assertNull((Object)this.lblDAO.find((Serializable)Long.valueOf(label1.getId())));
        tasks = this.taskService.getTaskHandler().findTasksByLabel(label1.getId(), null, "root", null);
        Assert.assertEquals((long)0L, (long)tasks.getSize());
    }

    @Test
    public void testQuery() throws Exception {
        Project project = new Project();
        project.setName("project1");
        this.taskService.getProjectHandler().create((Object)project);
        Status status = new Status();
        status.setName("status1");
        status.setRank(Integer.valueOf(1));
        status.setProject(project);
        this.taskService.getStatusHandler().create((Object)status);
        Task task = new Task();
        task.setTitle("task1");
        task.setStatus(status);
        this.taskService.getTaskHandler().create((Object)task);
        Label label1 = new Label("test label1", "root", project);
        Label label2 = new Label("test label2", "demo", project);
        this.lblDAO.create((Object)label1);
        this.lblDAO.create((Object)label2);
        ListAccess labels = this.lblDAO.findLabelsByUser("root");
        List<Label> list = Arrays.asList((Label[])ListUtil.load((ListAccess)labels, (int)0, (int)-1));
        Assert.assertEquals((long)1L, (long)labels.getSize());
        Assert.assertEquals((Object)label1.getName(), (Object)list.get(0).getName());
        labels = this.lblDAO.findLabelsByUser("demo");
        list = Arrays.asList((Label[])ListUtil.load((ListAccess)labels, (int)0, (int)-1));
        Assert.assertEquals((long)1L, (long)labels.getSize());
        Assert.assertEquals((Object)label2.getName(), (Object)list.get(0).getName());
        LabelTaskMapping mapping = new LabelTaskMapping(label1, task);
        this.taskService.getLabelTaskMappingHandler().create((Object)mapping);
        labels = this.lblDAO.findLabelsByTask(task.getId().longValue(), project.getId());
        Assert.assertEquals((long)1L, (long)labels.getSize());
    }
}

