/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.storage;

import java.util.Date;
import java.util.Set;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.task.AbstractTest;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.storage.CommentStorage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommentStorageTest
extends AbstractTest {
    private static final String USERNAME = "root";
    private TaskService taskService;
    private CommentStorage commentStorage;
    private TaskHandler taskDAO;
    private CommentHandler commentDAO;

    @Before
    public void init() {
        PortalContainer container = PortalContainer.getInstance();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        this.taskService = (TaskService)container.getComponentInstanceOfType(TaskService.class);
        this.commentStorage = (CommentStorage)container.getComponentInstanceOfType(CommentStorage.class);
        DAOHandler daoHandler = (DAOHandler)container.getComponentInstanceOfType(DAOHandler.class);
        this.taskDAO = daoHandler.getTaskHandler();
        this.commentDAO = daoHandler.getCommentHandler();
    }

    @After
    public void cleanData() {
        this.endRequestLifecycle();
        this.commentDAO.deleteAll();
        this.taskDAO.deleteAll();
    }

    @Test
    public void testMentionedUsers() throws EntityNotFoundException {
        TaskDto task = this.newDefaultSimpleTask();
        task = this.taskService.createTask(task);
        this.commentStorage.addComment(task, USERNAME, "test1 @john test2 @mary test3 @ root");
        Set mentionedUsers = this.taskService.getMentionedUsers(task.getId());
        Assert.assertEquals((long)2L, (long)mentionedUsers.size());
        Assert.assertTrue((boolean)mentionedUsers.contains("john"));
        Assert.assertTrue((boolean)mentionedUsers.contains("mary"));
        CommentDto comment2 = this.commentStorage.addComment(task, USERNAME, "@john @demo ");
        mentionedUsers = this.taskService.getMentionedUsers(task.getId());
        Assert.assertEquals((long)3L, (long)mentionedUsers.size());
        this.commentStorage.removeComment(comment2.getId());
        mentionedUsers = this.taskService.getMentionedUsers(task.getId());
        Assert.assertEquals((long)2L, (long)mentionedUsers.size());
    }

    @Test
    public void testFindTaskByMentionedUser() throws Exception {
        TaskDto task = this.newDefaultSimpleTask();
        task = this.taskService.createTask(task);
        this.commentStorage.addComment(task, USERNAME, "test comment @mary test");
        TaskQuery query = new TaskQuery();
        query.setIsTodoOf("mary");
        ListAccess tasks = this.taskDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        query = new TaskQuery();
        query.setIsIncomingOf("mary");
        tasks = this.taskDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        TaskDto task2 = this.taskService.createTask(this.newDefaultSimpleTask());
        task2.setAssignee("mary");
        this.taskService.updateTask(task2);
        query = new TaskQuery();
        query.setIsTodoOf("mary");
        tasks = this.taskDAO.findTasks(query);
        Assert.assertEquals((long)2L, (long)tasks.getSize());
        query = new TaskQuery();
        query.setIsIncomingOf("mary");
        tasks = this.taskDAO.findTasks(query);
        Assert.assertEquals((long)2L, (long)tasks.getSize());
        query = new TaskQuery();
        query.setIsTodoOf(USERNAME);
        tasks = this.taskDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
    }

    private TaskDto newDefaultSimpleTask() {
        TaskDto task = new TaskDto();
        task.setTitle("Default task");
        task.setAssignee(USERNAME);
        task.setCreatedBy(USERNAME);
        task.setCreatedTime(new Date());
        return task;
    }
}

