/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.Arrays;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.task.integration.ProjectGroupVisibilityPlugin;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ProjectGroupVisibilityPluginTest {
    @Test
    public void shouldHasPermissionWhenUserIsSuperUser() {
        UserACL userACL = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)userACL.getSuperUser()).thenReturn((Object)"john");
        ProjectGroupVisibilityPlugin plugin = new ProjectGroupVisibilityPlugin(userACL);
        Identity userIdentity = new Identity("john", Arrays.asList(new MembershipEntry("/platform/users", "manager")));
        GroupImpl groupPlatform = new GroupImpl();
        groupPlatform.setId("/platform");
        GroupImpl groupPlatformUsers = new GroupImpl();
        groupPlatformUsers.setId("/platform/users");
        boolean hasPermissionOnPlatform = plugin.hasPermission(userIdentity, (Group)groupPlatform);
        boolean hasPermissionOnPlatformUsers = plugin.hasPermission(userIdentity, (Group)groupPlatformUsers);
        Assert.assertTrue((boolean)hasPermissionOnPlatform);
        Assert.assertTrue((boolean)hasPermissionOnPlatformUsers);
    }

    @Test
    public void shouldHasPermissionWhenUserIsPlatformAdministrator() {
        UserACL userACL = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)userACL.getSuperUser()).thenReturn((Object)"root");
        Mockito.when((Object)userACL.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        ProjectGroupVisibilityPlugin plugin = new ProjectGroupVisibilityPlugin(userACL);
        Identity userIdentity = new Identity("john", Arrays.asList(new MembershipEntry("/platform/administrators", "manager")));
        GroupImpl groupPlatform = new GroupImpl();
        groupPlatform.setId("/platform");
        GroupImpl groupPlatformUsers = new GroupImpl();
        groupPlatformUsers.setId("/platform/users");
        boolean hasPermissionOnPlatform = plugin.hasPermission(userIdentity, (Group)groupPlatform);
        boolean hasPermissionOnPlatformUsers = plugin.hasPermission(userIdentity, (Group)groupPlatformUsers);
        Assert.assertTrue((boolean)hasPermissionOnPlatform);
        Assert.assertTrue((boolean)hasPermissionOnPlatformUsers);
    }

    @Test
    public void shouldHasPermissionWhenUserIsInGivenGroup() {
        UserACL userACL = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)userACL.getSuperUser()).thenReturn((Object)"root");
        Mockito.when((Object)userACL.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        ProjectGroupVisibilityPlugin plugin = new ProjectGroupVisibilityPlugin(userACL);
        Identity userIdentity = new Identity("john", Arrays.asList(new MembershipEntry("/platform/developers", "manager"), new MembershipEntry("/platform/testers", "member"), new MembershipEntry("/spaces/marketing", "member"), new MembershipEntry("/spaces/sales", "manager"), new MembershipEntry("/organization/rh", "*")));
        GroupImpl groupPlatform = new GroupImpl();
        groupPlatform.setId("/platform");
        GroupImpl groupPlatformDevelopers = new GroupImpl();
        groupPlatformDevelopers.setId("/platform/developers");
        GroupImpl groupPlatformTesters = new GroupImpl();
        groupPlatformTesters.setId("/platform/testers");
        GroupImpl groupSpaces = new GroupImpl();
        groupSpaces.setId("/spaces");
        GroupImpl groupSpacesMarketing = new GroupImpl();
        groupSpacesMarketing.setId("/spaces/marketing");
        GroupImpl groupSpacesSales = new GroupImpl();
        groupSpacesSales.setId("/spaces/sales");
        GroupImpl groupSpacesEngineering = new GroupImpl();
        groupSpacesEngineering.setId("/spaces/engineering");
        GroupImpl groupOrganization = new GroupImpl();
        groupOrganization.setId("/organization");
        GroupImpl groupOrganizationRh = new GroupImpl();
        groupOrganizationRh.setId("/organization/rh");
        boolean hasPermissionOnPlatform = plugin.hasPermission(userIdentity, (Group)groupPlatform);
        boolean hasPermissionOnPlatformDevelopers = plugin.hasPermission(userIdentity, (Group)groupPlatformDevelopers);
        boolean hasPermissionOnPlatformTesters = plugin.hasPermission(userIdentity, (Group)groupPlatformTesters);
        boolean hasPermissionOnSpaces = plugin.hasPermission(userIdentity, (Group)groupSpaces);
        boolean hasPermissionOnSpacesMarketing = plugin.hasPermission(userIdentity, (Group)groupSpacesMarketing);
        boolean hasPermissionOnSpacesSales = plugin.hasPermission(userIdentity, (Group)groupSpacesSales);
        boolean hasPermissionOnSpacesEngineering = plugin.hasPermission(userIdentity, (Group)groupSpacesEngineering);
        boolean hasPermissionOnOrganization = plugin.hasPermission(userIdentity, (Group)groupOrganization);
        boolean hasPermissionOnOrganizationRh = plugin.hasPermission(userIdentity, (Group)groupOrganizationRh);
        Assert.assertTrue((boolean)hasPermissionOnPlatform);
        Assert.assertTrue((boolean)hasPermissionOnPlatformDevelopers);
        Assert.assertFalse((boolean)hasPermissionOnPlatformTesters);
        Assert.assertTrue((boolean)hasPermissionOnSpaces);
        Assert.assertFalse((boolean)hasPermissionOnSpacesMarketing);
        Assert.assertTrue((boolean)hasPermissionOnSpacesSales);
        Assert.assertFalse((boolean)hasPermissionOnSpacesEngineering);
        Assert.assertTrue((boolean)hasPermissionOnOrganization);
        Assert.assertTrue((boolean)hasPermissionOnOrganizationRh);
    }
}

