/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import java.io.Serializable;
import java.util.Date;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.LabelHandler;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.UserSettingDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.CommentServiceImpl;
import org.exoplatform.task.storage.CommentStorage;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.StatusStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.storage.impl.CommentStorageImpl;
import org.exoplatform.task.util.StorageUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class CommentServiceTest {
    MockedStatic<ExoContainerContext> containerContext;
    StatusService statusService;
    CommentService commentService;
    ProjectStorage projectStorage;
    @Mock
    CommentStorage commentStorage;
    TaskStorage taskStorage;
    ListenerService listenerService;
    @Mock
    TaskHandler taskHandler;
    @Mock
    ProjectHandler projectHandler;
    @Mock
    StatusHandler statusHandler;
    @Mock
    LabelHandler labelHandler;
    @Mock
    UserService userService;
    @Mock
    CommentHandler commentHandler;
    @Mock
    DAOHandler daoHandler;
    @Mock
    StatusStorage statusStorage;
    @Captor
    ArgumentCaptor<Comment> commentCaptor;
    PortalContainer container;

    @Before
    public void setUp() {
        this.container = PortalContainer.getInstance();
        this.commentStorage = new CommentStorageImpl(this.daoHandler, this.projectStorage);
        this.commentService = new CommentServiceImpl(this.commentStorage, this.listenerService);
        this.containerContext = Mockito.mockStatic(ExoContainerContext.class);
        this.containerContext.when(() -> ExoContainerContext.getService((Class)((Class)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            Class clazz = (Class)invocation.getArgument(0, Class.class);
            if (clazz.equals(DAOHandler.class)) {
                return this.daoHandler;
            }
            return this.container.getComponentInstanceOfType(clazz);
        });
        Mockito.when((Object)this.daoHandler.getCommentHandler()).thenReturn((Object)this.commentHandler);
        Mockito.when((Object)this.daoHandler.getTaskHandler()).thenReturn((Object)this.taskHandler);
        Mockito.when((Object)this.daoHandler.getStatusHandler()).thenReturn((Object)this.statusHandler);
        Mockito.when((Object)this.daoHandler.getProjectHandler()).thenReturn((Object)this.projectHandler);
        Mockito.when((Object)((Comment)this.commentHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_COMMENT_ID)))).thenReturn((Object)TestUtils.getDefaultComment());
        Mockito.when((Object)((Task)this.taskHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_TASK_ID)))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.lenient().when((Object)((Comment)this.commentHandler.create((Object)((Comment)ArgumentMatchers.any())))).thenAnswer(invocation -> {
            long id = (long)(Math.random() * 9.223372036854776E18);
            Comment c = (Comment)invocation.getArgument(0, Comment.class);
            c.setId(Long.valueOf(id));
            Mockito.when((Object)((Comment)this.commentHandler.find((Serializable)Long.valueOf(id)))).thenReturn((Object)c);
            return c;
        });
    }

    @After
    public void tearDown() {
        this.commentService = null;
        this.containerContext.close();
        this.containerContext = null;
    }

    @Test
    public void testAddComment() throws EntityNotFoundException {
        Comment comment = TestUtils.getDefaultComment();
        this.commentService.addComment(StorageUtil.taskToDto((Task)comment.getTask(), (ProjectStorage)this.projectStorage), comment.getAuthor(), comment.getComment());
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)1))).create((Object)((Comment)this.commentCaptor.capture()));
        Comment result = (Comment)this.commentCaptor.getValue();
        Assert.assertEquals((Object)"Bla bla", (Object)result.getComment());
    }

    @Test
    public void testRemoveComment() throws EntityNotFoundException {
        Comment comment = TestUtils.getDefaultComment();
        Mockito.when((Object)((Comment)this.daoHandler.getCommentHandler().find((Serializable)Long.valueOf(TestUtils.EXISTING_COMMENT_ID)))).thenReturn((Object)comment);
        this.commentService.removeComment(TestUtils.EXISTING_COMMENT_ID);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)1))).delete((Object)((Comment)this.commentCaptor.capture()));
        Assert.assertEquals((long)TestUtils.EXISTING_COMMENT_ID, (long)((Comment)this.commentCaptor.getValue()).getId());
    }

    @Test
    public void testAddCommentsByTask() throws EntityNotFoundException {
        String username = "Tib";
        CommentDto newComment = TestUtils.getDefaultCommentDto();
        this.commentService.addComment(TestUtils.getDefaultTaskDto(), newComment.getAuthor(), newComment.getComment());
        this.commentService.getComments(TestUtils.EXISTING_TASK_ID, 0, 1);
        this.commentService.countComments(TestUtils.EXISTING_TASK_ID);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)1))).create((Object)((Comment)this.commentCaptor.capture()));
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)((Comment)this.commentCaptor.getValue()).getTask().getId());
        Assert.assertEquals((Object)username, (Object)((Comment)this.commentCaptor.getValue()).getAuthor());
        Assert.assertEquals((Object)newComment.getComment(), (Object)((Comment)this.commentCaptor.getValue()).getComment());
    }

    @Test
    public void testAddSubComments() throws EntityNotFoundException {
        String username = "Tib";
        String comment = "Bla bla bla bla bla";
        String authorSubComment = "Tib2";
        String subCommentContent = "Bla bla bla bla bla sub comment";
        CommentDto newComment = new CommentDto();
        newComment.setTask(TestUtils.getDefaultTaskDto());
        newComment.setAuthor(username);
        newComment.setComment(comment);
        newComment.setCreatedTime(new Date());
        UserSettingDto userSettingDto = TestUtils.getDefaultUserSettingDto();
        Assert.assertEquals((Object)"user", (Object)userSettingDto.getUsername());
        Assert.assertEquals((Object)true, (Object)userSettingDto.isShowHiddenLabel());
        Assert.assertEquals((Object)true, (Object)userSettingDto.isShowHiddenProject());
        this.commentService.addComment(StorageUtil.taskToDto((Task)TestUtils.getDefaultTask(), (ProjectStorage)this.projectStorage), username, comment);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)1))).create((Object)((Comment)this.commentCaptor.capture()));
        Comment parentComment = (Comment)this.commentCaptor.getValue();
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)parentComment.getTask().getId());
        Assert.assertEquals((Object)username, (Object)parentComment.getAuthor());
        Assert.assertEquals((Object)comment, (Object)parentComment.getComment());
        long parentCommentId = parentComment.getId();
        this.commentService.addComment(StorageUtil.taskToDto((Task)TestUtils.getDefaultTask(), (ProjectStorage)this.projectStorage), parentCommentId, authorSubComment, subCommentContent);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)2))).create((Object)((Comment)this.commentCaptor.capture()));
        Comment subComment = (Comment)this.commentCaptor.getValue();
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)subComment.getTask().getId());
        Assert.assertEquals((Object)authorSubComment, (Object)subComment.getAuthor());
        Assert.assertEquals((Object)subCommentContent, (Object)subComment.getComment());
    }
}

