/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.task.plugin;

import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import io.meeds.task.plugin.ProjectContentLinkPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.util.UserUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProjectContentLinkPluginTest {
    @Mock
    private ProjectService projectService;
    @Mock
    private PortalContainer container;
    @Mock
    private ContentLinkPluginService contentLinkPluginService;
    @Mock
    private Identity identity;
    @InjectMocks
    private ProjectContentLinkPlugin plugin;

    @Test
    public void testInitShouldRegisterPlugin() {
        Mockito.when((Object)((ContentLinkPluginService)this.container.getComponentInstanceOfType(ContentLinkPluginService.class))).thenReturn((Object)this.contentLinkPluginService);
        this.plugin.init();
        ((ContentLinkPluginService)Mockito.verify((Object)this.contentLinkPluginService)).addPlugin((ContentLinkPlugin)this.plugin);
    }

    @Test
    public void testGetExtension() {
        Assert.assertEquals((Object)new ContentLinkExtension("project", "contentLink.project", "fa fa-clipboard-list", "project"), (Object)this.plugin.getExtension());
    }

    @Test
    public void testSearchShouldDelegateToProjectServiceAndMapResults() {
        String keyword = "test";
        int offset = 0;
        int limit = 10;
        Locale locale = Locale.ENGLISH;
        List<String> memberships = Arrays.asList("member:/platform/users", "manager:/platform/administrators");
        ProjectDto project1 = (ProjectDto)Mockito.mock(ProjectDto.class);
        Mockito.when((Object)project1.getId()).thenReturn((Object)1L);
        Mockito.when((Object)project1.getName()).thenReturn((Object)"Project 1");
        ProjectDto project2 = (ProjectDto)Mockito.mock(ProjectDto.class);
        Mockito.when((Object)project2.getId()).thenReturn((Object)2L);
        Mockito.when((Object)project2.getName()).thenReturn((Object)"Project 2");
        List<ProjectDto> projects = Arrays.asList(project1, project2);
        Mockito.when((Object)this.projectService.findProjects(ArgumentMatchers.anyList(), (String)ArgumentMatchers.eq((Object)keyword), (OrderBy)ArgumentMatchers.any(), ArgumentMatchers.eq((int)offset), ArgumentMatchers.eq((int)limit))).thenReturn(projects);
        try (MockedStatic mocked = Mockito.mockStatic(UserUtil.class);){
            mocked.when(() -> UserUtil.getMemberships((Identity)this.identity)).thenReturn(memberships);
            List results = this.plugin.search(keyword, this.identity, locale, offset, limit);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)2L, (long)results.size());
            ContentLinkSearchResult r1 = (ContentLinkSearchResult)results.get(0);
            ContentLinkSearchResult r2 = (ContentLinkSearchResult)results.get(1);
            Assert.assertEquals((Object)"project", (Object)r1.getObjectType());
            Assert.assertEquals((Object)"1", (Object)r1.getObjectId());
            Assert.assertEquals((Object)"Project 1", (Object)r1.getTitle());
            Assert.assertEquals((Object)this.plugin.getExtension().getIcon(), (Object)r1.getIcon());
            Assert.assertEquals((Object)this.plugin.getExtension().isDrawer(), (Object)r1.isDrawer());
            Assert.assertEquals((Object)"project", (Object)r2.getObjectType());
            Assert.assertEquals((Object)"2", (Object)r2.getObjectId());
            Assert.assertEquals((Object)"Project 2", (Object)r2.getTitle());
            Assert.assertEquals((Object)this.plugin.getExtension().getIcon(), (Object)r2.getIcon());
            Assert.assertEquals((Object)this.plugin.getExtension().isDrawer(), (Object)r2.isDrawer());
        }
    }

    @Test
    public void testSearchWhenNoProjects() {
        String keyword = "nothing";
        int offset = 0;
        int limit = 5;
        Locale locale = Locale.ENGLISH;
        List<String> memberships = Collections.singletonList("member:/platform/users");
        Mockito.when((Object)this.projectService.findProjects(ArgumentMatchers.anyList(), (String)ArgumentMatchers.eq((Object)keyword), (OrderBy)ArgumentMatchers.any(), ArgumentMatchers.eq((int)offset), ArgumentMatchers.eq((int)limit))).thenReturn(Collections.emptyList());
        try (MockedStatic mocked = Mockito.mockStatic(UserUtil.class);){
            mocked.when(() -> UserUtil.getMemberships((Identity)this.identity)).thenReturn(memberships);
            List results = this.plugin.search(keyword, this.identity, locale, offset, limit);
            Assert.assertNotNull((Object)results);
            Assert.assertTrue((boolean)results.isEmpty());
        }
    }

    @Test
    public void testGetContentTitleWhenProjectExists() {
        String objectId = "123";
        long projectId = 123L;
        Locale locale = Locale.ENGLISH;
        ProjectDto project = (ProjectDto)Mockito.mock(ProjectDto.class);
        Mockito.when((Object)project.getName()).thenReturn((Object)"My Project");
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(projectId))).thenReturn((Object)project);
        String title = this.plugin.getContentTitle(objectId, locale);
        Assert.assertEquals((Object)"My Project", (Object)title);
    }

    @Test
    public void testGetContentTitleWhenProjectIsNull() {
        String objectId = "456";
        long projectId = 456L;
        Locale locale = Locale.ENGLISH;
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(projectId))).thenReturn(null);
        String title = this.plugin.getContentTitle(objectId, locale);
        Assert.assertEquals((Object)"", (Object)title);
        ((ProjectService)Mockito.verify((Object)this.projectService)).getProject(Long.valueOf(projectId));
    }

    @Test
    public void testGetContentTitleWhenEntityNotFound() {
        String objectId = "789";
        long projectId = 789L;
        Locale locale = Locale.ENGLISH;
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(projectId))).thenThrow(new Throwable[]{new EntityNotFoundException(projectId, ProjectDto.class)});
        String title = this.plugin.getContentTitle(objectId, locale);
        Assert.assertEquals((Object)"", (Object)title);
        ((ProjectService)Mockito.verify((Object)this.projectService)).getProject(Long.valueOf(projectId));
    }
}

