/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneId;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RewardPeriodTest {
    @Test
    public void testGetCurrentPeriod() {
        ZoneId zoneId = ZoneId.of("America/Rio_Branco");
        RewardSettings rewardSettings = new RewardSettings();
        rewardSettings.setPeriodType(RewardPeriodType.MONTH);
        rewardSettings.setTimeZone(zoneId.getId());
        RewardPeriod currentPeriod = RewardPeriod.getCurrentPeriod((RewardSettings)rewardSettings);
        Assert.assertEquals((Object)RewardPeriodType.MONTH, (Object)currentPeriod.getRewardPeriodType());
        Assert.assertEquals((Object)zoneId.getId(), (Object)currentPeriod.getTimeZone());
        Assert.assertEquals((Object)LocalDate.ofInstant(Instant.ofEpochSecond((currentPeriod.getEndDateInSeconds() + currentPeriod.getStartDateInSeconds()) / 2L), zoneId), (Object)currentPeriod.getPeriodMedianDate());
        Assert.assertEquals((long)YearMonth.now().atDay(1).atStartOfDay(zoneId).toEpochSecond(), (long)currentPeriod.getStartDateInSeconds());
        Assert.assertEquals((long)YearMonth.now().plusMonths(1L).atDay(1).atStartOfDay(zoneId).toEpochSecond(), (long)currentPeriod.getEndDateInSeconds());
    }

    @Test
    public void testGetPeriodQuarter() {
        ZoneId zoneId = ZoneId.of("America/Rio_Branco");
        RewardSettings rewardSettings = new RewardSettings();
        rewardSettings.setPeriodType(RewardPeriodType.QUARTER);
        rewardSettings.setTimeZone(zoneId.getId());
        LocalDate date = LocalDate.of(2022, Month.SEPTEMBER, 1);
        RewardPeriod period = RewardPeriod.getPeriodOfTime((RewardSettings)rewardSettings, (LocalDate)date);
        Assert.assertEquals((long)1656651600L, (long)period.getStartDateInSeconds());
        Assert.assertEquals((Object)"1 Jul 2022", (Object)period.getStartDateFormatted("en"));
        Assert.assertEquals((long)1664600400L, (long)period.getEndDateInSeconds());
        Assert.assertEquals((Object)"1 Oct 2022", (Object)period.getEndDateFormatted("en"));
        Assert.assertEquals((Object)RewardPeriodType.QUARTER, (Object)period.getRewardPeriodType());
        Assert.assertEquals((Object)zoneId.getId(), (Object)period.getTimeZone());
        Assert.assertEquals((Object)LocalDate.of(2022, Month.AUGUST, 16), (Object)period.getPeriodMedianDate());
    }

    @Test
    public void testGetPeriodMonth() {
        ZoneId zoneId = ZoneId.of("America/Rio_Branco");
        RewardSettings rewardSettings = new RewardSettings();
        rewardSettings.setPeriodType(RewardPeriodType.MONTH);
        rewardSettings.setTimeZone(zoneId.getId());
        LocalDate date = LocalDate.of(2022, Month.SEPTEMBER, 1);
        RewardPeriod period = RewardPeriod.getPeriodOfTime((RewardSettings)rewardSettings, (LocalDate)date);
        Assert.assertEquals((long)1662008400L, (long)period.getStartDateInSeconds());
        Assert.assertEquals((Object)"1 Sep 2022", (Object)period.getStartDateFormatted("en"));
        Assert.assertEquals((long)1664600400L, (long)period.getEndDateInSeconds());
        Assert.assertEquals((Object)"1 Oct 2022", (Object)period.getEndDateFormatted("en"));
        Assert.assertEquals((Object)RewardPeriodType.MONTH, (Object)period.getRewardPeriodType());
        Assert.assertEquals((Object)zoneId.getId(), (Object)period.getTimeZone());
        Assert.assertEquals((Object)LocalDate.of(2022, Month.SEPTEMBER, 16), (Object)period.getPeriodMedianDate());
    }

    @Test
    public void testGetPeriodYear() {
        ZoneId zoneId = ZoneId.of("America/Rio_Branco");
        RewardSettings rewardSettings = new RewardSettings();
        rewardSettings.setPeriodType(RewardPeriodType.YEAR);
        rewardSettings.setTimeZone(zoneId.getId());
        LocalDate date = LocalDate.of(2022, Month.SEPTEMBER, 1);
        RewardPeriod period = RewardPeriod.getPeriodOfTime((RewardSettings)rewardSettings, (LocalDate)date);
        Assert.assertEquals((long)1641013200L, (long)period.getStartDateInSeconds());
        Assert.assertEquals((Object)"1 Jan 2022", (Object)period.getStartDateFormatted("en"));
        Assert.assertEquals((long)1672549200L, (long)period.getEndDateInSeconds());
        Assert.assertEquals((Object)"1 Jan 2023", (Object)period.getEndDateFormatted("en"));
        Assert.assertEquals((Object)RewardPeriodType.YEAR, (Object)period.getRewardPeriodType());
        Assert.assertEquals((Object)zoneId.getId(), (Object)period.getTimeZone());
        Assert.assertEquals((Object)LocalDate.of(2022, Month.JULY, 2), (Object)period.getPeriodMedianDate());
    }
}

