/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.rest;

import io.meeds.wallet.model.AddressAlreadyInUseException;
import io.meeds.wallet.model.FundsRequest;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletAddressLabel;
import io.meeds.wallet.model.WalletProvider;
import io.meeds.wallet.model.WalletState;
import io.meeds.wallet.model.WalletType;
import io.meeds.wallet.service.WalletAccountService;
import io.meeds.wallet.service.WalletService;
import io.meeds.wallet.utils.WalletUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/account")
@Tag(name="/wallet/api/account", description="Manages wallets objects associated to users, spaces and admin")
@RolesAllowed(value={"users"})
public class WalletAccountREST
implements ResourceContainer {
    private static final String WALLET_NOT_FOUND_MESSAGE = "Wallet was not found with address {}";
    private static final String EMPTY_ADDRESS_MESSAGE = "Bad request sent to server with empty address";
    private static final Log LOG = ExoLogger.getLogger(WalletAccountREST.class);
    private WalletService walletService;
    private WalletAccountService accountService;

    public WalletAccountREST(WalletService walletService, WalletAccountService accountService) {
        this.walletService = walletService;
        this.accountService = accountService;
    }

    @Path(value="detailsById")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the user or space wallet identified by username or space pretty name", method="GET", description="returns the associated Wallet object, if not found it will return an empty object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getWalletByTypeAndID(@Parameter(description="username or space pretty name", required=true) @QueryParam(value="id") String remoteId, @Parameter(description="'user' or 'space'", required=true) @QueryParam(value="type") String type) {
        if (StringUtils.isBlank((CharSequence)remoteId) || StringUtils.isBlank((CharSequence)type)) {
            LOG.warn("Bad request sent to server with id '{}' and type '{}'", new Object[]{remoteId, type});
            return Response.status((int)400).build();
        }
        try {
            Wallet wallet = this.accountService.getWalletByTypeAndId(type, remoteId, WalletUtils.getCurrentUserId());
            if (wallet != null) {
                return Response.ok((Object)wallet).build();
            }
            return Response.ok((Object)"{}").build();
        }
        catch (Exception e) {
            LOG.error("Error getting wallet by id {} and type {}", new Object[]{remoteId, type});
            return Response.serverError().build();
        }
    }

    @Path(value="detailsByAddress")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the user or space wallet identified by an address", method="GET", description="returns the associated Wallet object, if not found it will return an empty object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getWalletByAddress(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address) {
        try {
            if (StringUtils.isBlank((CharSequence)address)) {
                LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
                return Response.status((int)400).build();
            }
            String currentUser = WalletUtils.getCurrentUserId();
            Wallet wallet = this.accountService.getWalletByAddress(address, currentUser);
            if (wallet != null) {
                if (WalletType.isSpace((String)wallet.getType())) {
                    wallet.setSpaceAdministrator(WalletUtils.isUserSpaceManager((String)wallet.getId(), (String)currentUser));
                }
                WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
                return Response.ok((Object)wallet).build();
            }
            return Response.ok((Object)"{}").build();
        }
        catch (Exception e) {
            LOG.error("Error getting wallet by address {}", new Object[]{address});
            return Response.serverError().build();
        }
    }

    @Path(value="enable")
    @GET
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Enable or disable a wallet identified by its address", method="GET", description="returns empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response enableWalletByAddress(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address, @Parameter(description="true to enable wallet, else false", required=true) @QueryParam(value="enable") boolean enable) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        try {
            this.accountService.enableWalletByAddress(address, enable, WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't delete address '{}' association", new Object[]{address, e});
            return Response.serverError().build();
        }
    }

    @Path(value="setInitializationStatus")
    @GET
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Modify initialization status of wallet", method="GET", description="returns empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response setInitializationStatus(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address, @Parameter(description="initialization status: new, modified, pending, initialized or denied", required=true) @QueryParam(value="status") String status) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((CharSequence)status)) {
            LOG.warn((Object)"Bad request sent to server with empty 'status' parameter");
            return Response.status((int)400).build();
        }
        try {
            this.accountService.setInitializationStatus(address, WalletState.valueOf((String)status.toUpperCase()), WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't set wallet initialized status '{}'", new Object[]{status, e});
            return Response.serverError().build();
        }
    }

    @Path(value="deleteWallet")
    @GET
    @RolesAllowed(value={"users"})
    @Operation(summary="Modify initialization status of wallet to delete", method="GET", description="returns empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteWallet(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        try {
            this.accountService.setInitializationStatus(address, WalletState.DELETED, WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't set wallet status '{}'", new Object[]{WalletState.DELETED, e});
            return Response.serverError().build();
        }
    }

    @Path(value="requestAuthorization")
    @GET
    @Operation(summary="Modify initialization status from DENIED to MODIFIED", description="This is used in case when a wallet has been denied access, in that case, a new authorization request can be done", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response requestAuthorization(@Parameter(description="wallet address to change its status", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        try {
            this.accountService.setInitializationStatus(address, WalletState.MODIFIED, WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't request authorization for wallet {}", new Object[]{address, e});
            return Response.serverError().build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveBackupState")
    @RolesAllowed(value={"users"})
    @Operation(summary="Saves wallet backup state", method="POST", description="Saves wallet backup state and returns the modified wallet")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveWalletBackupState(@Parameter(description="wallet technical id", required=true) @FormParam(value="walletId") long walletId, @Parameter(description="whether wallet backedUp or not", required=true) @FormParam(value="backedUp") boolean backedUp) {
        if (walletId <= 0L) {
            LOG.warn((Object)"Bad request sent to server with wrong wallet technical id");
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        LOG.debug("User '{}' is saving wallet with id {} backup state {}", new Object[]{currentUserId, walletId, backedUp});
        try {
            Wallet wallet = this.accountService.saveWalletBackupState(currentUserId, walletId, backedUp);
            return Response.ok((Object)wallet).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not allowed to change backup state of wallet with id {}", new Object[]{currentUserId, walletId, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while saving wallet backup state: User {} attempts to change backup state wallet with id {}", new Object[]{currentUserId, walletId, e});
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveAddress")
    @RolesAllowed(value={"users"})
    @Operation(summary="Associates a wallet address to a user or a space", method="POST", description="Associates a wallet address to a user or a space and returns the generated password for newly saved wallet")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="409", description="Conflicted operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveWallet(@Parameter(description="wallet details to save", required=true) Wallet wallet) {
        if (wallet == null) {
            LOG.warn((Object)"Bad request sent to server with empty data");
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        LOG.debug("User '{}' is saving new wallet address for {} '{}' with address '{}'", new Object[]{currentUserId, wallet.getType(), wallet.getId(), wallet.getAddress()});
        try {
            Wallet storedWallet = this.accountService.getWalletByTypeAndId(wallet.getType(), wallet.getId(), currentUserId);
            if (storedWallet == null || StringUtils.isBlank((CharSequence)storedWallet.getAddress())) {
                this.accountService.saveWalletAddress(wallet, currentUserId);
                return Response.ok((Object)wallet.getPassPhrase()).build();
            }
            storedWallet.setAddress(wallet.getAddress());
            storedWallet.setBackedUp(false);
            this.accountService.saveWalletAddress(storedWallet, currentUserId);
            return Response.ok((Object)storedWallet.getPassPhrase()).build();
        }
        catch (AddressAlreadyInUseException e) {
            LOG.warn("User '{}' is attempting to add a wallet address {} that is already in use", new Object[]{currentUserId, wallet.getAddress()});
            return Response.status((int)409).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not allowed to save wallet {}", new Object[]{currentUserId, wallet, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while saving address: User " + currentUserId + " attempts to save address of " + wallet.getType() + " '" + wallet.getId() + "' using address " + wallet.getAddress()), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="provider")
    @RolesAllowed(value={"users"})
    @Operation(summary="Switches user wallet provider", method="POST", description="Switches user wallet provider and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveWalletProvider(@Parameter(description="New Wallet provider", required=true) @FormParam(value="provider") WalletProvider provider, @Parameter(description="Selected Wallet Address of provider") @FormParam(value="address") String address, @Parameter(description="Signed Raw message by external Wallet Provider") @FormParam(value="rawMessage") String rawMessage, @Parameter(description="Signed message by external Wallet Provider") @FormParam(value="signedMessage") String signedMessage, @Context HttpServletRequest request) {
        if (provider == null) {
            return Response.status((int)400).entity((Object)"Bad request sent to server with empty provider").build();
        }
        if (provider != WalletProvider.INTERNAL_WALLET) {
            if (StringUtils.isBlank((CharSequence)address)) {
                return Response.status((int)400).entity((Object)EMPTY_ADDRESS_MESSAGE).build();
            }
            if (StringUtils.isBlank((CharSequence)rawMessage) || StringUtils.isBlank((CharSequence)signedMessage)) {
                return Response.status((int)400).entity((Object)"Must Sign a raw message to verify that user has the private key of selected address").build();
            }
        }
        long currentUserIdentityId = WalletUtils.getCurrentUserIdentityId();
        LOG.debug("User '{}' is saving new provider for his wallet", new Object[]{currentUserIdentityId});
        try {
            if (provider == WalletProvider.INTERNAL_WALLET) {
                this.accountService.switchToInternalWallet(currentUserIdentityId);
            } else {
                String token = WalletUtils.getToken((HttpSession)request.getSession());
                if (!StringUtils.contains((CharSequence)rawMessage, (CharSequence)token)) {
                    return Response.status((int)400).entity((Object)"Bad request sent to server with invalid signed message").build();
                }
                this.accountService.switchWalletProvider(currentUserIdentityId, provider, address, rawMessage, signedMessage);
            }
            return Response.noContent().build();
        }
        catch (AddressAlreadyInUseException e) {
            LOG.warn("User '{}' is attempting to add a wallet address {} that is already in use", new Object[]{currentUserIdentityId, address, e});
            return Response.status((int)409).build();
        }
        catch (Exception e) {
            LOG.warn("Unknown error occurred while switching identity '{}' wallet provider to '{}' ", new Object[]{currentUserIdentityId, provider, e});
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="savePrivateKey")
    @RolesAllowed(value={"users"})
    @Operation(summary="Save encrypted private key of a wallet", method="POST", description="Save encrypted private key of a wallet and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response savePrivateKey(@Parameter(description="wallet address to save its encrypted private key", required=true) @FormParam(value="address") String address, @Parameter(description="encrypted wallet private key", required=true) @FormParam(value="privateKey") String privateKey) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            LOG.warn((Object)"Empty private key content");
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        LOG.info("User '{}' is saving new wallet private key for address {}", new Object[]{currentUserId, address});
        try {
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet == null) {
                LOG.debug(WALLET_NOT_FOUND_MESSAGE, new Object[]{address});
                return Response.status((int)400).build();
            }
            this.accountService.savePrivateKeyByTypeAndId(wallet.getType(), wallet.getId(), privateKey, currentUserId);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error saving wallet private key by user '{}' for address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while saving wallet private key: User {} attempts to save wallet private key of address '{}'", new Object[]{currentUserId, address, e});
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getPrivateKey")
    @RolesAllowed(value={"users"})
    @Operation(summary="Get encrypted private key of a wallet", method="GET", description="returns encoded wallet private key in String format")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPrivateKey(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        try {
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet == null) {
                LOG.debug(WALLET_NOT_FOUND_MESSAGE, new Object[]{address});
                return Response.status((int)400).build();
            }
            String privateKeyEncrypted = this.accountService.getPrivateKeyByTypeAndId(wallet.getType(), wallet.getId(), currentUserId);
            return Response.ok((Object)privateKeyEncrypted).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error getting wallet private key by user '{}' for address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while user {} attempts to get wallet private key with address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="removePrivateKey")
    @RolesAllowed(value={"users"})
    @Operation(summary="Removes associated private key of a wallet", method="GET", description="Removes associated private key of a wallet and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response removePrivateKey(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        LOG.info("User '{}' is removing wallet private key stored on server for address {}", new Object[]{currentUserId, address});
        try {
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet == null) {
                LOG.debug(WALLET_NOT_FOUND_MESSAGE, new Object[]{address});
                return Response.status((int)400).build();
            }
            this.accountService.removePrivateKeyByTypeAndId(wallet.getType(), wallet.getId(), currentUserId);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error removing wallet private key by user '{}' for address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while saving wallet private key: User {} attempts to save wallet private key of address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)500).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="saveOrDeleteAddressLabel")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Saves or deletes a label associated to an address", method="POST", description="Saves or deletes a label associated to an address. If label is empty, then deletes it, else saves it. returns saved label object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveOrDeleteAddressLabel(@RequestBody(description="blockchain address label", required=true) WalletAddressLabel label) {
        if (label == null) {
            LOG.warn((Object)"Bad request sent to server with empty data");
            return Response.status((int)400).build();
        }
        try {
            label = this.accountService.saveOrDeleteAddressLabel(label, WalletUtils.getCurrentUserId());
            return Response.ok((Object)label).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while saving address label: User " + WalletUtils.getCurrentUserId() + ", label: {}", new Object[]{label, e});
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="requestFunds")
    @RolesAllowed(value={"users"})
    @Operation(summary="Sends a fund request to a user or space", method="POST", description="Sends a fund request to a user or space and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response requestFunds(@Parameter(description="funds request object", required=true) FundsRequest fundsRequest) {
        if (fundsRequest == null) {
            LOG.warn((Object)"Bad request sent to server with empty funds request");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((CharSequence)fundsRequest.getAddress())) {
            LOG.warn((Object)"Bad request sent to server with empty sender address");
            return Response.status((int)400).build();
        }
        String receipientRemoteId = fundsRequest.getReceipient();
        String receipientType = fundsRequest.getReceipientType();
        if (StringUtils.isBlank((CharSequence)receipientRemoteId) || StringUtils.isBlank((CharSequence)receipientType)) {
            LOG.warn((Object)"Bad request sent to server with empty receipient");
            return Response.status((int)400).build();
        }
        try {
            this.walletService.requestFunds(fundsRequest, WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)401).build();
        }
        catch (IllegalStateException e) {
            LOG.error((Object)("Unknown error occurred while user '" + WalletUtils.getCurrentUserId() + "' requesting funds for wallet  '" + fundsRequest.getAddress() + "'"), (Throwable)e);
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while user '" + WalletUtils.getCurrentUserId() + "' requesting funds for wallet  '" + fundsRequest.getAddress() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="markFundRequestAsSent")
    @RolesAllowed(value={"users"})
    @Operation(summary="Mark a web notification of funds request as sent", method="GET", description="Mark a web notification of funds request as sent and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response markFundRequestAsSent(@Parameter(description="web notification id", required=true) @QueryParam(value="notificationId") String notificationId) {
        if (StringUtils.isBlank((CharSequence)notificationId)) {
            LOG.warn((Object)"Bad request sent to server with empty notificationId");
            return Response.status((int)400).build();
        }
        String currentUser = WalletUtils.getCurrentUserId();
        try {
            this.walletService.markFundRequestAsSent(notificationId, currentUser);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)401).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while marking fund request with id '" + notificationId + "' for user '" + WalletUtils.getCurrentUserId() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="fundRequestSent")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Returns fund request status", method="GET", description="returns fund request status (true if notification sent, else false)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response isFundRequestSent(@Parameter(description="web notification id", required=true) @QueryParam(value="notificationId") String notificationId) {
        if (StringUtils.isBlank((CharSequence)notificationId)) {
            LOG.warn((Object)"Bad request sent to server with empty notificationId");
            return Response.status((int)400).build();
        }
        String currentUser = WalletUtils.getCurrentUserId();
        try {
            boolean fundRequestSent = this.walletService.isFundRequestSent(notificationId, currentUser);
            return Response.ok((Object)String.valueOf(fundRequestSent)).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)401).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving fund request status", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Get list of wallet accounts", method="GET", description="Get list of wallet accounts (array of wallets objects)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getWallets() {
        try {
            Set wallets = this.accountService.listWallets();
            return Response.ok((Object)wallets).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of wallets", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="refreshWalletFromBlockchain")
    @RolesAllowed(value={"users"})
    @Operation(summary="force refresh wallet from blockchain", method="GET", description="force refresh wallet from blockchain")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response refreshWalletFromBlockchain(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)"Bad request sent to server with empty wallet address in parameter");
            return Response.status((int)400).build();
        }
        try {
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet == null) {
                LOG.warn("Bad request sent to server with unknown wallet address: {}", new Object[]{address});
                return Response.status((int)400).build();
            }
            this.accountService.refreshWalletFromBlockchain(wallet, null, null);
            return Response.status((int)204).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of wallets", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

