/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.storage;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.RewardStatus;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.model.WalletRewardPeriodSummary;
import io.meeds.wallet.model.WalletRewardStatus;
import io.meeds.wallet.model.WalletState;
import io.meeds.wallet.reward.dao.RewardDAO;
import io.meeds.wallet.reward.dao.RewardPeriodDAO;
import io.meeds.wallet.reward.dao.RewardPeriodSummaryDAO;
import io.meeds.wallet.reward.entity.WalletRewardEntity;
import io.meeds.wallet.reward.entity.WalletRewardPeriodEntity;
import io.meeds.wallet.reward.entity.WalletRewardPeriodSummaryEntity;
import io.meeds.wallet.reward.storage.WalletRewardReportStorage;
import io.meeds.wallet.service.WalletAccountService;
import io.meeds.wallet.service.WalletTransactionService;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={WalletRewardReportStorage.class})
@ExtendWith(value={MockitoExtension.class})
class WalletRewardReportStorageTest {
    private static final Long REWARD_ID = 2L;
    private static final Long REWARD_PERIOD_ID = 2L;
    private static final Long REWARD_PERIOD_SUMMARY_ID = 2L;
    private static final Long IDENTITY_ID = 5L;
    private static final Pageable PAGEABLE = Pageable.ofSize((int)2);
    @MockBean
    private RewardDAO rewardDAO;
    @MockBean
    private RewardPeriodDAO rewardPeriodDAO;
    @MockBean
    private RewardPeriodSummaryDAO rewardPeriodSummaryDAO;
    @MockBean
    private WalletAccountService walletAccountService;
    @MockBean
    private WalletTransactionService walletTransactionService;
    @Autowired
    private WalletRewardReportStorage walletRewardReportStorage;

    WalletRewardReportStorageTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.rewardDAO.save((Object)((WalletRewardEntity)Mockito.any()))).thenAnswer(invocation -> {
            WalletRewardEntity rewardEntity = (WalletRewardEntity)invocation.getArgument(0);
            if (rewardEntity.getId() == null) {
                rewardEntity.setId(REWARD_ID);
            }
            Mockito.when((Object)this.rewardDAO.findById((Object)REWARD_ID)).thenReturn(Optional.of(rewardEntity));
            Mockito.when((Object)this.rewardDAO.findWalletRewardEntitiesByIdentityId(IDENTITY_ID.longValue(), PAGEABLE)).thenReturn(List.of(rewardEntity));
            Mockito.when((Object)this.rewardDAO.findAll(PAGEABLE)).thenReturn((Object)new PageImpl(List.of(rewardEntity)));
            Mockito.when((Object)this.rewardDAO.count()).thenReturn((Object)1L);
            Mockito.when((Object)this.rewardDAO.countWalletRewardEntitiesByIdentityId(IDENTITY_ID.longValue())).thenReturn((Object)1.0);
            Mockito.when((Object)this.rewardDAO.findRewardsByPeriodId(REWARD_ID.longValue())).thenReturn(List.of(rewardEntity));
            Mockito.when((Object)this.rewardDAO.findWalletRewardsByPeriodId(REWARD_PERIOD_ID.longValue(), WalletRewardStatus.ALL.name(), PAGEABLE)).thenReturn((Object)new PageImpl(List.of(rewardEntity)));
            Mockito.when((Object)this.rewardDAO.findWalletRewardsByPeriodIdAndIdentityIds(REWARD_PERIOD_ID.longValue(), List.of(IDENTITY_ID), WalletRewardStatus.ALL.name(), PAGEABLE)).thenReturn((Object)new PageImpl(List.of(rewardEntity)));
            Mockito.when((Object)this.rewardDAO.findWalletRewardsByPeriodId(REWARD_PERIOD_ID.longValue(), WalletRewardStatus.ESTIMATED.name(), PAGEABLE)).thenReturn((Object)new PageImpl(List.of(rewardEntity)));
            return rewardEntity;
        });
        ((RewardDAO)Mockito.doAnswer(invocation -> {
            WalletRewardEntity entity = (WalletRewardEntity)invocation.getArgument(0);
            Mockito.when((Object)this.rewardDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.rewardDAO)).delete((Object)((WalletRewardEntity)Mockito.any()));
        Mockito.when((Object)this.rewardPeriodDAO.save((Object)((WalletRewardPeriodEntity)Mockito.any()))).thenAnswer(invocation -> {
            WalletRewardPeriodEntity entity = (WalletRewardPeriodEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                entity.setId(REWARD_PERIOD_ID);
            }
            if (entity.getPeriodType() == null) {
                entity.setPeriodType(RewardPeriodType.WEEK);
            }
            Mockito.when((Object)this.rewardPeriodDAO.findById((Object)REWARD_PERIOD_ID)).thenReturn(Optional.of(entity));
            Mockito.when((Object)this.rewardPeriodDAO.findRewardPeriodsBetween(12125L, 222125L, PAGEABLE)).thenReturn((Object)new PageImpl(List.of(entity)));
            Mockito.when((Object)this.rewardPeriodDAO.findAll(PAGEABLE)).thenReturn((Object)new PageImpl(List.of(entity)));
            Mockito.when((Object)this.rewardPeriodDAO.findRewardPeriodByTypeAndTime((RewardPeriodType)Mockito.any(RewardPeriodType.class), Mockito.anyLong())).thenReturn((Object)entity);
            Mockito.when((Object)this.rewardPeriodDAO.findWalletRewardPeriodEntitiesByStatus((RewardStatus)Mockito.any(RewardStatus.class))).thenReturn(List.of(entity));
            Mockito.when((Object)this.rewardPeriodDAO.count()).thenReturn((Object)1L);
            return entity;
        });
        ((RewardPeriodDAO)Mockito.doAnswer(invocation -> {
            WalletRewardPeriodEntity entity = (WalletRewardPeriodEntity)invocation.getArgument(0);
            Mockito.when((Object)this.rewardPeriodDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.rewardPeriodDAO)).delete((Object)((WalletRewardPeriodEntity)Mockito.any()));
        Mockito.when((Object)this.rewardPeriodSummaryDAO.save((Object)((WalletRewardPeriodSummaryEntity)Mockito.any()))).thenAnswer(invocation -> {
            WalletRewardPeriodSummaryEntity entity = (WalletRewardPeriodSummaryEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                entity.setId(REWARD_PERIOD_SUMMARY_ID);
            }
            Mockito.when((Object)this.rewardPeriodSummaryDAO.findWalletRewardPeriodSummaryByRewardPeriodId(REWARD_PERIOD_ID)).thenReturn(Optional.of(entity));
            return entity;
        });
        ((RewardPeriodSummaryDAO)Mockito.doAnswer(invocation -> {
            WalletRewardPeriodEntity entity = (WalletRewardPeriodEntity)invocation.getArgument(0);
            Mockito.when((Object)this.rewardPeriodSummaryDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.rewardPeriodSummaryDAO)).delete((Object)((WalletRewardPeriodSummaryEntity)Mockito.any()));
    }

    @Test
    void countRewards() {
        RewardReport rewardReport = this.createRewardReportInstance(true);
        this.walletRewardReportStorage.saveRewardReport(rewardReport);
        Assertions.assertEquals((double)1.0, (double)this.walletRewardReportStorage.countRewards(IDENTITY_ID.longValue()));
    }

    @Test
    void listRewards() {
        RewardReport rewardReport = this.createRewardReportInstance(true);
        this.walletRewardReportStorage.saveRewardReport(rewardReport);
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.listRewards(IDENTITY_ID.longValue(), ZoneId.systemDefault(), 2));
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.findRewardReportPeriods(PAGEABLE));
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.findRewardPeriodsBetween(12125L, 222125L, PAGEABLE));
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.getRewardPeriod(RewardPeriodType.WEEK, LocalDate.now(), ZoneId.systemDefault()));
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.findWalletRewardsByPeriodId(REWARD_PERIOD_ID.longValue(), ZoneId.systemDefault(), WalletRewardStatus.ESTIMATED, PAGEABLE));
    }

    @Test
    void getRewardReport() {
        Assertions.assertNull((Object)this.walletRewardReportStorage.getRewardReport(RewardPeriodType.WEEK, LocalDate.now(), ZoneId.systemDefault()));
        RewardReport rewardReport = this.createRewardReportInstance(true);
        this.walletRewardReportStorage.saveRewardReport(rewardReport);
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.getRewardReportByPeriodId(REWARD_PERIOD_ID.longValue(), ZoneId.systemDefault()));
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.getRewardPeriod(RewardPeriodType.WEEK, LocalDate.now(), ZoneId.systemDefault()));
        rewardReport = this.createRewardReportInstance(false);
        this.walletRewardReportStorage.saveRewardReport(rewardReport);
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.getRewardReportByPeriodId(REWARD_PERIOD_ID.longValue(), ZoneId.systemDefault()));
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.getRewardPeriod(RewardPeriodType.WEEK, LocalDate.now(), ZoneId.systemDefault()));
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.getRewardPeriodById(REWARD_PERIOD_ID.longValue()));
    }

    @Test
    void findRewardPeriodsByStatus() {
        RewardReport rewardReport = this.createRewardReportInstance(true);
        this.walletRewardReportStorage.saveRewardReport(rewardReport);
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.findRewardPeriodsByStatus(RewardStatus.SUCCESS));
    }

    @Test
    void findWalletRewardsByPeriodIdAndStatus() {
        RewardReport rewardReport = this.createRewardReportInstance(false);
        this.walletRewardReportStorage.saveRewardReport(rewardReport);
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.findWalletRewardsByPeriodIdAndIdentityIds(REWARD_PERIOD_ID.longValue(), List.of(IDENTITY_ID), ZoneId.systemDefault(), WalletRewardStatus.ALL, PAGEABLE));
    }

    @Test
    void findWalletRewardPeriodSummaryByRewardPeriodId() {
        RewardReport rewardReport = this.createRewardReportInstance(false);
        this.walletRewardReportStorage.saveRewardReport(rewardReport);
        WalletRewardPeriodSummary walletRewardPeriodSummary = this.createWalletRewardPeriodSummaryInstance(REWARD_PERIOD_ID);
        this.walletRewardReportStorage.createOrUpdateSummary(walletRewardPeriodSummary);
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.findWalletRewardPeriodSummaryByRewardPeriodId(REWARD_PERIOD_ID));
        walletRewardPeriodSummary.setPoints(500.0);
        this.walletRewardReportStorage.createOrUpdateSummary(walletRewardPeriodSummary);
        Assertions.assertNotNull((Object)this.walletRewardReportStorage.findWalletRewardPeriodSummaryByRewardPeriodId(REWARD_PERIOD_ID));
    }

    protected RewardReport createRewardReportInstance(boolean isSucceeded) {
        Wallet wallet = this.newWallet(IDENTITY_ID);
        Wallet wallet4 = this.newWallet(4L);
        Wallet wallet5 = this.newWallet(5L);
        RewardReport rewardReport = new RewardReport();
        RewardPeriod rewardPeriod = new RewardPeriod();
        rewardReport.setPeriod(rewardPeriod);
        rewardReport.setParticipationsCount(10);
        HashSet<WalletReward> walletRewards = new HashSet<WalletReward>();
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setSucceeded(isSucceeded);
        walletRewards.add(new WalletReward(1L, wallet, transactionDetail, 1L, 100.0, 10.0, rewardPeriod, 3));
        walletRewards.add(new WalletReward(2L, wallet4, transactionDetail, 4L, 200.0, 50.0, rewardPeriod, 2));
        walletRewards.add(new WalletReward(3L, wallet5, transactionDetail, 5L, 300.0, 40.0, rewardPeriod, 1));
        rewardReport.setRewards(walletRewards);
        return rewardReport;
    }

    protected WalletRewardPeriodSummary createWalletRewardPeriodSummaryInstance(long rewardPeriodId) {
        WalletRewardPeriodSummary walletRewardPeriodSummary = new WalletRewardPeriodSummary();
        RewardPeriod rewardPeriod = new RewardPeriod();
        rewardPeriod.setId(rewardPeriodId);
        walletRewardPeriodSummary.setPeriod(rewardPeriod);
        walletRewardPeriodSummary.setPoints(100.0);
        walletRewardPeriodSummary.setAchievementsCount(5L);
        walletRewardPeriodSummary.setParticipantsCount(2L);
        walletRewardPeriodSummary.setRecipientsCount(1L);
        walletRewardPeriodSummary.setTokensSent(100.0);
        walletRewardPeriodSummary.setTokensToSend(100.0);
        walletRewardPeriodSummary.setCompletelyProcessed(false);
        return walletRewardPeriodSummary;
    }

    protected Wallet newWallet(long identityId) {
        Wallet wallet = new Wallet();
        wallet.setTechnicalId(identityId);
        wallet.setAddress("walletAddress" + identityId);
        wallet.setPassPhrase("passphrase");
        wallet.setEnabled(true);
        wallet.setIsInitialized(Boolean.valueOf(true));
        wallet.setEtherBalance(Double.valueOf(0.0));
        wallet.setTokenBalance(Double.valueOf(0.0));
        wallet.setInitializationState(WalletState.INITIALIZED.name());
        return wallet;
    }
}

