/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.service;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Objects;
import io.meeds.wallet.model.RewardBudgetType;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.reward.service.WalletRewardSettingsService;
import io.meeds.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={WalletRewardSettingsService.class})
public class WalletRewardSettingsServiceTest {
    @MockBean
    private SettingService settingService;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private RewardSettingsService rewardSettingsService;

    @Test
    public void testGetSettings() {
        RewardSettings defaultSettings = this.rewardSettingsService.getSettings();
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Assertions.assertNotNull((Object)defaultSettings);
        Assertions.assertEquals((Object)RewardPeriodType.DEFAULT, (Object)defaultSettings.getPeriodType());
        Assertions.assertEquals((double)0.0, (double)defaultSettings.getAmount(), (double)0.0);
        Assertions.assertEquals((Object)RewardBudgetType.DEFAULT, (Object)defaultSettings.getBudgetType());
        Assertions.assertEquals((double)0.0, (double)defaultSettings.getThreshold(), (double)0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveSettings() {
        RewardSettings defaultSettings = this.rewardSettingsService.getSettings();
        RewardSettings newSettings = defaultSettings.clone();
        long amount = 1L;
        long threshold = 2L;
        RewardBudgetType budgetType = RewardBudgetType.FIXED_PER_POINT;
        RewardPeriodType periodType = RewardPeriodType.MONTH;
        newSettings.setPeriodType(periodType);
        newSettings.setAmount((double)amount);
        newSettings.setBudgetType(budgetType);
        newSettings.setThreshold((double)threshold);
        this.rewardSettingsService.saveSettings(newSettings);
        RewardSettings finalNewSettings = newSettings;
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SettingValue)ArgumentMatchers.argThat(value -> Objects.equal((Object)value.getValue(), (Object)WalletUtils.toJsonString((Object)finalNewSettings))));
        try {
            SettingValue value2 = SettingValue.create((String)WalletUtils.toJsonString((Object)finalNewSettings));
            Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)value2);
            newSettings = this.rewardSettingsService.getSettings();
            Assertions.assertNotNull((Object)newSettings);
            Assertions.assertEquals((Object)periodType, (Object)newSettings.getPeriodType());
            Assertions.assertEquals((double)amount, (double)newSettings.getAmount(), (double)0.0);
            Assertions.assertEquals((double)threshold, (double)newSettings.getThreshold(), (double)0.0);
            Assertions.assertEquals((Object)budgetType, (Object)newSettings.getBudgetType());
            budgetType = RewardBudgetType.FIXED;
            newSettings.setBudgetType(budgetType);
            this.rewardSettingsService.saveSettings(newSettings);
            value2 = SettingValue.create((String)WalletUtils.toJsonString((Object)newSettings));
            Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)value2);
            newSettings = this.rewardSettingsService.getSettings();
            Assertions.assertEquals((Object)budgetType, (Object)newSettings.getBudgetType());
        }
        finally {
            this.rewardSettingsService.saveSettings(defaultSettings);
        }
    }

    @Test
    public void testDeleteSettings() {
        this.rewardSettingsService.deleteSettings();
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).remove((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }
}

