/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.listener;

import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.reward.listener.RewardSucceedNotificationListener;
import io.meeds.wallet.utils.RewardUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.command.NotificationExecutor;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={RewardSucceedNotificationListener.class})
class RewardSucceedNotificationListenerTest {
    private static final String EVENT_NAME = "exo.wallet.reward.report.success";
    @MockBean
    private Event<RewardReport, Object> event;
    @MockBean
    private RewardReport rewardReport;
    @MockBean
    private NotificationContext notificationContext;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private RewardSucceedNotificationListener rewardSucceedNotificationListener;

    RewardSucceedNotificationListenerTest() {
    }

    @BeforeEach
    void setUp() {
        this.rewardSucceedNotificationListener.init();
    }

    @Test
    void testInit() {
        ((ListenerService)Mockito.verify((Object)this.listenerService)).addListener(EVENT_NAME, (ListenerBase)this.rewardSucceedNotificationListener);
    }

    @Test
    void testOnEvent() {
        Mockito.when((Object)((RewardReport)this.event.getSource())).thenReturn((Object)this.rewardReport);
        try (MockedStatic mockedStatic = Mockito.mockStatic(NotificationContextImpl.class);){
            mockedStatic.when(NotificationContextImpl::cloneInstance).thenReturn((Object)this.notificationContext);
            NotificationExecutor notificationExecutor = (NotificationExecutor)Mockito.mock(NotificationExecutor.class);
            Mockito.when((Object)this.notificationContext.getNotificationExecutor()).thenReturn((Object)notificationExecutor);
            NotificationCommand notificationCommand = (NotificationCommand)Mockito.mock(NotificationCommand.class);
            Mockito.when((Object)this.notificationContext.makeCommand(PluginKey.key((String)"RewardSuccessNotificationPlugin"))).thenReturn((Object)notificationCommand);
            Mockito.when((Object)notificationExecutor.with(notificationCommand)).thenReturn((Object)notificationExecutor);
            this.rewardSucceedNotificationListener.onEvent(this.event);
            ((NotificationContext)Mockito.verify((Object)this.notificationContext)).append(RewardUtils.REWARD_REPORT_NOTIFICATION_PARAM, (Object)this.rewardReport);
            ((NotificationExecutor)Mockito.verify((Object)notificationExecutor)).with(notificationCommand);
            ((NotificationExecutor)Mockito.verify((Object)notificationExecutor)).execute(this.notificationContext);
        }
    }
}

