/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.reward.listener.RewardSucceedAnalyticsListener;
import java.util.HashSet;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={RewardSucceedAnalyticsListener.class})
class RewardSucceedAnalyticsListenerTest {
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private Event<RewardReport, Object> event;
    @Autowired
    private RewardSucceedAnalyticsListener rewardSucceedAnalyticsListener;

    RewardSucceedAnalyticsListenerTest() {
    }

    @Test
    void createEvent() {
        RewardReport rewardReport = (RewardReport)Mockito.mock(RewardReport.class);
        RewardPeriod rewardPeriod = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        Mockito.when((Object)rewardReport.getPeriod()).thenReturn((Object)rewardPeriod);
        Mockito.when((Object)rewardPeriod.getStartDateInSeconds()).thenReturn((Object)1609459200L);
        Mockito.when((Object)rewardPeriod.getEndDateInSeconds()).thenReturn((Object)1612137600L);
        Mockito.when((Object)rewardPeriod.getTimeZone()).thenReturn((Object)"UTC");
        Mockito.when((Object)rewardPeriod.getRewardPeriodType()).thenReturn((Object)RewardPeriodType.MONTH);
        Mockito.when((Object)rewardReport.getSuccessTransactionCount()).thenReturn((Object)10L);
        Mockito.when((Object)rewardReport.getTokensSent()).thenReturn((Object)500.0);
        Mockito.when((Object)rewardReport.getTokensToSend()).thenReturn((Object)1000.0);
        Mockito.when((Object)rewardReport.getValidRewardCount()).thenReturn((Object)5L);
        HashSet<WalletReward> rewards = new HashSet<WalletReward>();
        rewards.add(new WalletReward());
        Mockito.when((Object)rewardReport.getRewards()).thenReturn(rewards);
        Mockito.when((Object)((RewardReport)this.event.getSource())).thenReturn((Object)rewardReport);
        try (MockedStatic mockedAnalyticsUtils = Mockito.mockStatic(AnalyticsUtils.class);){
            this.rewardSucceedAnalyticsListener.onEvent(this.event);
            ArgumentCaptor captor = ArgumentCaptor.forClass(StatisticData.class);
            mockedAnalyticsUtils.verify(() -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)captor.capture())), Mockito.times((int)1));
            StatisticData actualStatisticData = (StatisticData)captor.getValue();
            Assertions.assertEquals((Object)"wallet", (Object)actualStatisticData.getModule());
            Assertions.assertEquals((Object)"reward", (Object)actualStatisticData.getSubModule());
            Assertions.assertEquals((Object)"sendPeriodRewards", (Object)actualStatisticData.getOperation());
            Assertions.assertEquals((Object)"UTC", actualStatisticData.getParameters().get("rewardPeriodTimeZone"));
            Assertions.assertEquals((Object)"month", actualStatisticData.getParameters().get("rewardPeriodType"));
            Assertions.assertEquals((Object)"10", actualStatisticData.getParameters().get("rewardTransactionsCount"));
            Assertions.assertEquals((Object)"500.0", actualStatisticData.getParameters().get("rewardTokensSent"));
            Assertions.assertEquals((Object)"1000.0", actualStatisticData.getParameters().get("rewardTokensToSend"));
            Assertions.assertEquals((Object)"5", actualStatisticData.getParameters().get("rewardRecipientWalletCount"));
            Assertions.assertEquals((Object)"1", actualStatisticData.getParameters().get("rewardParticipantWalletCount"));
        }
    }
}

