/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.storage;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.wallet.entity.TransactionEntity;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.storage.TransactionStorage;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.exoplatform.wallet.utils.WalletUtils;
import org.junit.Test;

public class TransactionStorageTest
extends BaseWalletTest {
    @Test
    public void testServiceInstantiated() {
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        TransactionStorageTest.assertNotNull((Object)transactionStorage);
    }

    @Test
    public void testGetContractTransactions() {
        String contractAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        String contractMethodName = "transfer";
        this.generateTransactions("0xe9dfec7864af9e581a85ce3987d026be0f50aaaa", contractAddress, contractMethodName);
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        List transactions = transactionStorage.getContractTransactions(contractAddress, contractMethodName, 100);
        TransactionStorageTest.assertNotNull((String)"Returned transactions list is null", (Object)transactions);
        TransactionStorageTest.assertEquals((String)"Returned contract transactions list count is not coherent", (int)10, (int)transactions.size());
        transactions = transactionStorage.getContractTransactions(contractAddress, contractMethodName, 5);
        TransactionStorageTest.assertEquals((String)"Returned contract transactions list count is not coherent", (int)5, (int)transactions.size());
        transactions = transactionStorage.getContractTransactions(contractAddress, null, 100);
        TransactionStorageTest.assertEquals((String)"Returned contract transactions list count with not method name is not coherent", (int)30, (int)transactions.size());
        transactions = transactionStorage.getContractTransactions(contractAddress, null, 0);
        TransactionStorageTest.assertEquals((String)"Returned contract transactions list count with limit = 0 is not coherent", (int)30, (int)transactions.size());
    }

    @Test
    public void testGetTransactions() {
        String contractAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        String contractMethodName = "transfer";
        long totalTransactionsSize = this.generateTransactions("0xe9dfec7864af9e581a85ce3987d026be0f50aaaa", contractAddress, contractMethodName).size();
        TransactionStorageTest.assertTrue(((totalTransactionsSize += (long)this.generateTransactions("0xe9dfec7864af9e581a85ce3987d026be0f50bbbb", null, null).size()) > 100L ? 1 : 0) != 0);
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        List transactions = transactionStorage.getTransactions(WalletUtils.getNetworkId(), Integer.MAX_VALUE);
        TransactionStorageTest.assertNotNull((String)"Returned transactions list is null", (Object)transactions);
        TransactionStorageTest.assertEquals((String)"Returned transactions list count is not coherent", (long)totalTransactionsSize, (long)transactions.size());
        transactions = transactionStorage.getTransactions(WalletUtils.getNetworkId(), 5);
        TransactionStorageTest.assertEquals((String)"Returned contract transactions list count is not coherent", (int)5, (int)transactions.size());
    }

    @Test
    public void testGetWalletTransactions() {
        String contractAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        String contractMethodName = "transfer";
        String firstAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        List<TransactionEntity> generatedTransactions = this.generateTransactions(firstAddress, contractAddress, contractMethodName);
        List transactionHashList = generatedTransactions.stream().map(TransactionEntity::getHash).collect(Collectors.toList());
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        boolean includeAdministrationTransactions = true;
        boolean onlyPending = false;
        List transactions = transactionStorage.getWalletTransactions(137L, firstAddress, null, null, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertNotNull((String)"Returned transactions list is null", (Object)transactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)60, (int)transactions.size());
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, null, null, null, 20, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)20, (int)transactions.size());
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, contractAddress, null, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)30, (int)transactions.size());
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
        onlyPending = true;
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
        String oldestTransactionHash = (String)transactionHashList.get(0);
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, null, null, oldestTransactionHash, 10, false, true);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list should include all transactions, even if limit = 10, the selected hash must be included in result", (int)60, (int)transactions.size());
        includeAdministrationTransactions = false;
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
        includeAdministrationTransactions = true;
        onlyPending = false;
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, null, null, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)60, (int)transactions.size());
        transactions.forEach(transaction -> {
            transaction.setDropped(true);
            transactionStorage.saveTransactionDetail(transaction);
        });
        this.generateTransactions(firstAddress, contractAddress, contractMethodName);
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, null, null, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertNotNull((String)"Returned transactions list is null", (Object)transactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)60, (int)transactions.size());
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, null, null, null, 20, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)20, (int)transactions.size());
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, contractAddress, null, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)30, (int)transactions.size());
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
        onlyPending = true;
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
        oldestTransactionHash = (String)transactionHashList.get(0);
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, null, null, oldestTransactionHash, 10, false, true);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list should include all transactions, even if limit = 10, the selected hash must be included in result", (int)60, (int)transactions.size());
        includeAdministrationTransactions = false;
        transactions = transactionStorage.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, null, 0, onlyPending, includeAdministrationTransactions);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
    }

    @Test
    public void testGetPendingTransactions() {
        String contractAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        String contractMethodName = "transfer";
        String firstAddress = "0xe8dfec7864af9e581a85ce3987d026be0f509ac9";
        this.generateTransactions(firstAddress, contractAddress, contractMethodName);
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        List transactions = transactionStorage.getPendingWalletTransactionsNotSent(firstAddress, 137L);
        TransactionStorageTest.assertNotNull((String)"Returned transactions list is null", (Object)transactions);
        TransactionStorageTest.assertEquals((String)"Returned pending transactions list count on a network is not coherent", (int)10, (int)transactions.size());
        transactions = transactionStorage.getPendingWalletTransactionsNotSent(firstAddress, 138L);
        TransactionStorageTest.assertEquals((String)"Returned wallet transactions list count on a non existing network is not coherent", (int)0, (int)transactions.size());
    }

    @Test
    public void testGetTransactionByHash() {
        String hashOfTX = "0x51a6e8ef52f723ab8e52eed07b7ebbe165ec892664616434c946e387424ceadb";
        long createdDateInMilliSeconds = System.currentTimeMillis();
        this.createTransactionDetail(hashOfTX, null, 0.0, 0.0, "from", "to", "by", 1L, "label", "message", true, true, true, null, createdDateInMilliSeconds);
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        TransactionDetail transactionDetail = transactionStorage.getTransactionByHash(hashOfTX);
        TransactionStorageTest.assertNotNull((String)"Can't find previously saved transaction with given hash", (Object)transactionDetail);
        transactionDetail = transactionStorage.getTransactionByHash("0x111111ef52f723ab8e52eed07b7ebbe165ec892664616434c946e387424ceaaa");
        TransactionStorageTest.assertNull((String)"Shouldn't find a non existing transaction with fake hash", (Object)transactionDetail);
    }

    @Test
    public void testSaveTransactionDetail() {
        TransactionDetail transactionDetail = this.createTransactionDetail(null, null, 0.0, 0.0, "from", "to", "by", 0L, "label", "message", true, true, true, null, 0L);
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        TransactionDetail savedTransactionDetail = transactionStorage.getTransactionByHash(transactionDetail.getHash());
        TransactionStorageTest.assertEquals((String)"Stored transaction detail is not equals to built one", (Object)transactionDetail, (Object)savedTransactionDetail);
        transactionDetail.setContractMethodName("transfer");
        transactionStorage.saveTransactionDetail(transactionDetail);
        savedTransactionDetail = transactionStorage.getTransactionByHash(transactionDetail.getHash());
        TransactionStorageTest.assertEquals((String)"Stored transaction detail is not equals to updated one", (Object)transactionDetail, (Object)savedTransactionDetail);
    }

    @Test
    public void testCountReceivedContractAmount() {
        String contractAddress = "contractAddress";
        String address = "address";
        String contractMethodName = "reward";
        this.generateTransactions(address, contractAddress, contractMethodName, -1000L);
        ZonedDateTime start = ZonedDateTime.now();
        this.generateTransactions(address, contractAddress, contractMethodName);
        ZonedDateTime end = ZonedDateTime.now().plusSeconds(1L);
        this.generateTransactions(address, contractAddress, contractMethodName, 3000L);
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        double receivedAmount = transactionStorage.countReceivedContractAmount(contractAddress, address, start, end);
        TransactionStorageTest.assertEquals((String)"Received amount isn't coherent", (double)10.0, (double)receivedAmount, (double)0.0);
    }

    @Test
    public void testCountSentContractAmount() {
        String contractAddress = "contractAddress";
        String address = "address";
        String contractMethodName = "transfer";
        this.generateTransactions(address, contractAddress, contractMethodName, -1000L);
        ZonedDateTime start = ZonedDateTime.now();
        this.generateTransactions(address, contractAddress, contractMethodName);
        ZonedDateTime end = ZonedDateTime.now().plusSeconds(1L);
        this.generateTransactions(address, contractAddress, contractMethodName, 3000L);
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        double sentAmount = transactionStorage.countSentContractAmount(contractAddress, address, start, end);
        TransactionStorageTest.assertEquals((String)"Sent amount isn't coherent", (double)10.0, (double)sentAmount, (double)0.0);
    }
}

