/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.blockchain.listener;

import io.meeds.wallet.blockchain.listener.ContractTransactionMinedListener;
import io.meeds.wallet.model.ContractTransactionEvent;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.service.BlockchainTransactionService;
import io.meeds.wallet.service.WalletTransactionService;
import io.meeds.wallet.test.BaseWalletTest;
import java.util.Collections;
import java.util.List;
import org.exoplatform.services.listener.Event;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContractTransactionMinedListenerTest
extends BaseWalletTest {
    @Mock
    private WalletTransactionService walletTransactionService;
    @Mock
    private BlockchainTransactionService blockchainTransactionService;
    private ContractTransactionMinedListener listener;
    private Event<String, ContractTransactionEvent> event;
    private TransactionDetail transactionDetail;
    private String hash = "transactionHash";
    private String fromAddress = "fromAddress";
    private String toAddress = "toAddress";
    private String data = "data";
    private List<String> topics = Collections.singletonList("topic");
    private long blockNumber = 1234L;
    private ContractTransactionEvent contractTransactionEvent;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.contractTransactionEvent = new ContractTransactionEvent(this.hash, this.fromAddress, this.data, this.topics, this.blockNumber);
        this.event = new Event("exo.wallet.transaction.minedForContract", null, (Object)this.contractTransactionEvent);
        this.listener = new ContractTransactionMinedListener(this.walletTransactionService, this.blockchainTransactionService);
        this.transactionDetail = new TransactionDetail();
        this.transactionDetail.setHash(this.hash);
        this.transactionDetail.setFrom(this.fromAddress);
        this.transactionDetail.setTo(this.toAddress);
    }

    @Test
    public void testOnEventWhenTransactionIsNoKnownAndWalletsNotKnown() throws Exception {
        this.listener.onEvent(this.event);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.never())).refreshTransactionFromBlockchain((String)ArgumentMatchers.any());
    }

    @Test
    public void testOnEventWhenTransactionIsKnownButNotPendingAndAlreadySucceeded() throws Exception {
        Mockito.when((Object)this.walletTransactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setPending(false);
        this.transactionDetail.setSucceeded(true);
        this.listener.onEvent(this.event);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.never())).refreshTransactionFromBlockchain((String)ArgumentMatchers.any());
    }

    @Test
    public void testOnEventWhenTransactionIsKnownButNotPendingAndNotSucceeded() throws Exception {
        Mockito.when((Object)this.walletTransactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setPending(false);
        this.transactionDetail.setSucceeded(false);
        this.listener.onEvent(this.event);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)1))).addTransactionToRefreshFromBlockchain(this.transactionDetail);
    }

    @Test
    public void testOnEventWhenTransactionIsKnownButPending() throws Exception {
        Mockito.when((Object)this.walletTransactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setPending(true);
        this.listener.onEvent(this.event);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)1))).addTransactionToRefreshFromBlockchain(this.transactionDetail);
    }

    @Test
    public void testOnEventWhenTransactionIsNotKnownAndWalletsKnown() throws Exception {
        Mockito.when((Object)this.blockchainTransactionService.hasManagedWalletInTransaction(this.contractTransactionEvent)).thenReturn((Object)true);
        this.listener.onEvent(this.event);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)1))).refreshTransactionFromBlockchain(this.hash);
    }
}

