/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.util.Date;
import junit.framework.TestCase;
import org.exoplatform.common.http.client.Cookie;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.RoRequest;

public class CookieTest
extends TestCase {
    public void testParseCookie() throws Exception {
        for (int i = 0; i < 243; ++i) {
            int e;
            int d;
            int c;
            boolean withExpires = false;
            boolean withDomain = false;
            boolean withPath = false;
            boolean withSecure = false;
            boolean withHttpOnly = false;
            StringBuilder sb = new StringBuilder();
            sb.append("Customer=WILE_E_COYOTE");
            int[] decomposition = CookieTest.decomposition(i);
            int b = decomposition[0];
            if (b > 0) {
                withExpires = true;
                sb.append("; expires=");
                if (b == 1) {
                    sb.append('\"');
                }
                sb.append("Sat, 12 Aug 1995 13:30:00 GMT+0430");
                if (b == 1) {
                    sb.append('\"');
                }
            }
            if ((c = decomposition[1]) > 0) {
                withDomain = true;
                sb.append("; Domain=www.google.com");
            }
            if ((d = decomposition[2]) > 0) {
                withPath = true;
                sb.append("; Path=/acme");
            }
            if ((e = decomposition[3]) == 1) {
                withSecure = true;
                sb.append("; secure");
            }
            if (e == 2) continue;
            int f = decomposition[4];
            if (f == 1) {
                withHttpOnly = true;
                sb.append("; HttpOnly");
            }
            if (f == 2) continue;
            this.testParseCookie(sb.toString(), withExpires, withDomain, withPath, withSecure, withHttpOnly);
        }
    }

    private void testParseCookie(String pattern, boolean withExpires, boolean withDomain, boolean withPath, boolean withSecure, boolean withHttpOnly) throws Exception {
        HTTPConnection con = new HTTPConnection("www.google.com", 80);
        Request req = new Request(con, "GET", "/acme", null, null, null, false);
        System.out.println(pattern);
        Cookie[] resultCookies = Cookie.parse((String)pattern, (RoRequest)req);
        CookieTest.assertNotNull((Object)resultCookies);
        CookieTest.assertEquals((int)1, (int)resultCookies.length);
        Cookie resultCookie = resultCookies[0];
        CookieTest.assertEquals((String)"Customer", (String)resultCookie.getName());
        CookieTest.assertEquals((String)"WILE_E_COYOTE", (String)resultCookie.getValue());
        if (withExpires) {
            CookieTest.assertEquals((Object)new Date("Sat, 12 Aug 1995 13:30:00 GMT+0430"), (Object)resultCookie.expires());
        }
        if (withDomain) {
            CookieTest.assertEquals((String)"www.google.com", (String)resultCookie.getDomain());
        }
        if (withPath) {
            CookieTest.assertEquals((String)"/acme", (String)resultCookie.getPath());
        }
        if (withSecure) {
            CookieTest.assertTrue((boolean)resultCookie.isSecure());
        }
        if (withHttpOnly) {
            CookieTest.assertTrue((boolean)resultCookie.isHttpOnly());
        }
    }

    private static int[] decomposition(int value) {
        int base;
        int[] result = new int[5];
        int power = base = 3;
        int i = 0;
        while (value > 0) {
            int modulo = value % power;
            result[i] = base * modulo / power;
            value -= modulo;
            power *= base;
            ++i;
        }
        return result;
    }
}

