/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonTest;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.exoplatform.ws.frameworks.json.value.impl.ArrayValue;
import org.exoplatform.ws.frameworks.json.value.impl.BooleanValue;
import org.exoplatform.ws.frameworks.json.value.impl.DoubleValue;
import org.exoplatform.ws.frameworks.json.value.impl.LongValue;
import org.exoplatform.ws.frameworks.json.value.impl.ObjectValue;
import org.exoplatform.ws.frameworks.json.value.impl.StringValue;

public class JsonParserTest
extends JsonTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testArrayString() throws Exception {
        String jsonString = "[\"JUnit in Action\",\"Advanced JavaScript\",\"Beginning C# 2008\"]";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(jsonString.getBytes())), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JsonParserTest.assertTrue((boolean)jsonValue.isArray());
        HashSet<String> s = new HashSet<String>();
        Iterator elements = jsonValue.getElements();
        while (elements.hasNext()) {
            JsonValue next = (JsonValue)elements.next();
            JsonParserTest.assertTrue((boolean)next.isString());
            s.add(next.getStringValue());
        }
        JsonParserTest.assertEquals((int)3, (int)s.size());
        JsonParserTest.assertTrue((boolean)s.contains("JUnit in Action"));
        JsonParserTest.assertTrue((boolean)s.contains("Advanced JavaScript"));
        JsonParserTest.assertTrue((boolean)s.contains("Beginning C# 2008"));
    }

    public void testArrayLong() throws Exception {
        String jsonString = "[1, 0xAA, 077, 123, 32765, 77787, 123456789, 0x123456, 0123456, -2387648, -123456789]";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(jsonString.getBytes())), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JsonParserTest.assertTrue((boolean)jsonValue.isArray());
        int i = 0;
        Iterator elements = jsonValue.getElements();
        while (elements.hasNext()) {
            JsonValue next = (JsonValue)elements.next();
            JsonParserTest.assertTrue((boolean)next.isNumeric());
            JsonParserTest.assertTrue((boolean)next.isLong());
            JsonParserTest.assertFalse((boolean)next.isDouble());
            if (i == 0) {
                JsonParserTest.assertEquals((long)1L, (long)next.getLongValue());
            }
            if (i == 3) {
                JsonParserTest.assertEquals((long)123L, (long)next.getLongValue());
            }
            if (i == 6) {
                JsonParserTest.assertEquals((long)123456789L, (long)next.getLongValue());
            }
            ++i;
        }
    }

    public void testArrayDouble() throws Exception {
        String jsonString = "[1.0, 0.0006382746, 111111.2222222, 9999999999999.9999999999999,9827394873249.8, 1.23456789E8, 123456.789E8, 3215478352478651238.0,982.8, 0.00000000000023456789E8, 1.789E8, 0.0000000000000000000321547835247865123,982.8, -0.00000000000023456789E8, -1.789E-8, -0.0000000000000000000321547835247865123]";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(jsonString.getBytes())), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JsonParserTest.assertTrue((boolean)jsonValue.isArray());
        int i = 0;
        Iterator elements = jsonValue.getElements();
        while (elements.hasNext()) {
            JsonValue next = (JsonValue)elements.next();
            JsonParserTest.assertTrue((boolean)next.isNumeric());
            JsonParserTest.assertFalse((boolean)next.isLong());
            JsonParserTest.assertTrue((boolean)next.isDouble());
            if (i == 0) {
                JsonParserTest.assertEquals((Object)1.0, (Object)next.getDoubleValue());
            }
            if (i == 2) {
                JsonParserTest.assertEquals((Object)111111.2222222, (Object)next.getDoubleValue());
            }
            if (i == 9) {
                JsonParserTest.assertEquals((Object)2.3456789E-5, (Object)next.getDoubleValue());
            }
            ++i;
        }
    }

    public void testArrayMixed() throws Exception {
        String jsonString = "[1.0, \"to be or not to be\", 111, true, {\"object\":{\"foo\":\"bar\"}}]";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(jsonString.getBytes())), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JsonParserTest.assertTrue((boolean)jsonValue.isArray());
        ArrayValue exp = new ArrayValue();
        exp.addElement((JsonValue)new DoubleValue(1.0));
        exp.addElement((JsonValue)new StringValue("to be or not to be"));
        exp.addElement((JsonValue)new LongValue(111L));
        exp.addElement((JsonValue)new BooleanValue(true));
        ObjectValue o = new ObjectValue();
        o.addElement("foo", (JsonValue)new StringValue("bar"));
        ObjectValue o1 = new ObjectValue();
        o1.addElement("object", (JsonValue)o);
        exp.addElement((JsonValue)o1);
        Iterator elements = jsonValue.getElements();
        Iterator expElements = jsonValue.getElements();
        while (elements.hasNext() && expElements.hasNext()) {
            JsonValue next = (JsonValue)elements.next();
            JsonValue expNext = (JsonValue)expElements.next();
            JsonParserTest.assertEquals((String)expNext.toString(), (String)next.toString());
        }
        JsonParserTest.assertFalse((elements.hasNext() || expElements.hasNext() ? 1 : 0) != 0);
    }

    public void testObject() throws Exception {
        String jsonString = "{\"foo\":\"bar\", \"book\":{\"author\":\"Christian Gross\",\"title\":\"Beginning C# 2008\"}}";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(jsonString.getBytes())), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JsonParserTest.assertTrue((boolean)jsonValue.isObject());
        JsonValue sValue = jsonValue.getElement("foo");
        JsonParserTest.assertTrue((boolean)sValue.isString());
        JsonParserTest.assertEquals((String)"bar", (String)sValue.getStringValue());
        JsonValue bookValue = jsonValue.getElement("book");
        JsonParserTest.assertTrue((boolean)bookValue.isObject());
        JsonParserTest.assertEquals((String)"Beginning C# 2008", (String)bookValue.getElement("title").getStringValue());
        JsonParserTest.assertEquals((String)"Christian Gross", (String)bookValue.getElement("author").getStringValue());
    }

    public void testMultiDimensionArray() throws Exception {
        String jsonString = "[\"foo0\", [\"foo1\", \"bar1\", [\"foo2\", \"bar2\"]], \"bar0\"]";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(jsonString.getBytes())), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        ArrayValue exp = new ArrayValue();
        exp.addElement((JsonValue)new StringValue("foo0"));
        ArrayValue l1 = new ArrayValue();
        exp.addElement((JsonValue)l1);
        l1.addElement((JsonValue)new StringValue("foo1"));
        l1.addElement((JsonValue)new StringValue("bar1"));
        ArrayValue l2 = new ArrayValue();
        l1.addElement((JsonValue)l2);
        l2.addElement((JsonValue)new StringValue("foo2"));
        l2.addElement((JsonValue)new StringValue("bar2"));
        exp.addElement((JsonValue)new StringValue("bar0"));
        JsonParserTest.assertEquals((String)exp.toString(), (String)jsonValue.toString());
    }
}

