/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.exoplatform.ws.frameworks.json.value.impl.ObjectValue;
import org.exoplatform.ws.frameworks.json.value.impl.StringValue;

public class GroovyBeanTest
extends TestCase {
    public void testRestoreGroovyBean() throws Exception {
        GroovyClassLoader cl = new GroovyClassLoader();
        Class c = cl.parseClass(new GroovyCodeSource(IOUtil.getStreamContentAsString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("SimpleBean.groovy")), "myscript", "/groovy/shell"));
        ObjectValue ov = new ObjectValue();
        StringValue sv = new StringValue("test restore groovy bean");
        ov.addElement("value", (JsonValue)sv);
        GroovyBeanTest.assertEquals((String)"test restore groovy bean", (String)ObjectBuilder.createObject((Class)c, (JsonValue)ov).toString());
    }

    public void testSerializeGroovyBean() throws Exception {
        GroovyClassLoader cl = new GroovyClassLoader();
        Class c = cl.parseClass(new GroovyCodeSource(IOUtil.getStreamContentAsString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("SimpleBean.groovy")), "myscript", "/groovy/shell"));
        GroovyObject groovyObject = (GroovyObject)c.newInstance();
        groovyObject.invokeMethod("setValue", (Object)new Object[]{"test serialize groovy bean"});
        GroovyBeanTest.assertEquals((String)"{\"value\":\"test serialize groovy bean\"}", (String)new JsonGeneratorImpl().createJsonObject((Object)groovyObject).toString());
    }

    public void testSerializeGroovyBean1() throws Exception {
        GroovyClassLoader cl = new GroovyClassLoader();
        Class c = cl.parseClass(new GroovyCodeSource(IOUtil.getStreamContentAsString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("BookStorage.groovy")), "myscript", "/groovy/shell"));
        GroovyObject groovyObject = (GroovyObject)c.newInstance();
        groovyObject.invokeMethod("initStorage", (Object)new Object[0]);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)groovyObject);
        GroovyBeanTest.assertTrue((boolean)jsonValue.isObject());
        Iterator iterator = jsonValue.getElement("books").getElements();
        GroovyBeanTest.assertEquals((String)"JUnit in Action", (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        GroovyBeanTest.assertEquals((String)"Beginning C# 2008 from novice to professional", (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        GroovyBeanTest.assertEquals((String)"Advanced JavaScript, Third Edition", (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        GroovyBeanTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testRestoreGroovyBean1() throws Exception {
        GroovyClassLoader cl = new GroovyClassLoader();
        Class c = cl.parseClass(new GroovyCodeSource(IOUtil.getStreamContentAsString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("BookStorage.groovy")), "myscript", "/groovy/shell"));
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("BookStorage.txt")), (JsonHandler)jsonHandler);
        JsonValue jv = jsonHandler.getJsonObject();
        GroovyObject o = (GroovyObject)ObjectBuilder.createObject((Class)c, (JsonValue)jv);
        List books = (List)o.getProperty("books");
        GroovyBeanTest.assertEquals((int)3, (int)books.size());
        GroovyBeanTest.assertEquals((Object)((GroovyObject)books.get(0)).getProperty("title"), (Object)"JUnit in Action");
        GroovyBeanTest.assertEquals((Object)((GroovyObject)books.get(1)).getProperty("title"), (Object)"Beginning C# 2008 from novice to professional");
        GroovyBeanTest.assertEquals((Object)((GroovyObject)books.get(2)).getProperty("title"), (Object)"Advanced JavaScript. Third Edition");
    }
}

