/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.ws.frameworks.json.BeanWithBookEnum;
import org.exoplatform.ws.frameworks.json.BeanWithSimpleEnum;
import org.exoplatform.ws.frameworks.json.BeanWithTransientField;
import org.exoplatform.ws.frameworks.json.Book;
import org.exoplatform.ws.frameworks.json.BookEnum;
import org.exoplatform.ws.frameworks.json.BookStorage;
import org.exoplatform.ws.frameworks.json.BookWrapper;
import org.exoplatform.ws.frameworks.json.ClassTransfBean;
import org.exoplatform.ws.frameworks.json.JavaMapBean;
import org.exoplatform.ws.frameworks.json.StringEnum;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonTest;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class JsonGeneratorTest
extends JsonTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBean() throws Exception {
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)this.junitBook);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isObject());
        JsonGeneratorTest.assertEquals((String)this.junitBook.getAuthor(), (String)jsonValue.getElement("author").getStringValue());
        JsonGeneratorTest.assertEquals((String)this.junitBook.getTitle(), (String)jsonValue.getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((int)this.junitBook.getPages(), (int)jsonValue.getElement("pages").getIntValue());
        JsonGeneratorTest.assertEquals((Object)this.junitBook.getPrice(), (Object)jsonValue.getElement("price").getDoubleValue());
        JsonGeneratorTest.assertEquals((long)this.junitBook.getIsdn(), (long)jsonValue.getElement("isdn").getLongValue());
        JsonGeneratorTest.assertEquals((boolean)this.junitBook.getDelivery(), (boolean)jsonValue.getElement("delivery").getBooleanValue());
        JsonGeneratorTest.assertEquals((boolean)this.junitBook.isAvailability(), (boolean)jsonValue.getElement("availability").getBooleanValue());
    }

    public void testArray() throws Exception {
        Book[] a = new Book[]{this.junitBook, this.csharpBook, this.javaScriptBook};
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonArray((Object)a);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isArray());
        Iterator iterator = jsonValue.getElements();
        JsonGeneratorTest.assertEquals((String)a[0].getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((String)a[1].getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((String)a[2].getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
    }

    public void testArrayNull() throws Exception {
        Object a = null;
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonArray(a);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isNull());
    }

    public void testCollection() throws Exception {
        List<Book> l = Arrays.asList(this.junitBook, this.csharpBook, this.javaScriptBook);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonArray(l);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isArray());
        Iterator iterator = jsonValue.getElements();
        JsonGeneratorTest.assertEquals((String)l.get(0).getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((String)l.get(1).getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((String)l.get(2).getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
    }

    public void testCollectionNull() throws Exception {
        Collection l = null;
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonArray(l);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isNull());
    }

    public void testMap() throws Exception {
        HashMap<String, Book> m = new HashMap<String, Book>();
        m.put("junit", this.junitBook);
        m.put("csharp", this.csharpBook);
        m.put("js", this.javaScriptBook);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObjectFromMap(m);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isObject());
        JsonGeneratorTest.assertEquals((String)this.junitBook.getTitle(), (String)jsonValue.getElement("junit").getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((String)this.csharpBook.getTitle(), (String)jsonValue.getElement("csharp").getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((String)this.javaScriptBook.getTitle(), (String)jsonValue.getElement("js").getElement("title").getStringValue());
    }

    public void testMapOrder() throws Exception {
        LinkedHashMap<String, Book> m = new LinkedHashMap<String, Book>();
        m.put("junit", this.junitBook);
        m.put("csharp", this.csharpBook);
        m.put("js", this.javaScriptBook);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObjectFromMap(m);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isObject());
        Iterator iter = jsonValue.getKeys();
        String[] array = m.keySet().toArray(new String[0]);
        int i = 0;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            JsonGeneratorTest.assertEquals((String)key, (String)array[i]);
            ++i;
        }
    }

    public void testMapNull() throws Exception {
        Map m = null;
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObjectFromMap(m);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isNull());
    }

    public void testBeanWrapper() throws Exception {
        BookWrapper bookWrapper = new BookWrapper();
        bookWrapper.setBook(this.junitBook);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)bookWrapper);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isObject());
        JsonGeneratorTest.assertEquals((String)this.junitBook.getAuthor(), (String)jsonValue.getElement("book").getElement("author").getStringValue());
        JsonGeneratorTest.assertEquals((String)this.junitBook.getTitle(), (String)jsonValue.getElement("book").getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((int)this.junitBook.getPages(), (int)jsonValue.getElement("book").getElement("pages").getIntValue());
        JsonGeneratorTest.assertEquals((Object)this.junitBook.getPrice(), (Object)jsonValue.getElement("book").getElement("price").getDoubleValue());
        JsonGeneratorTest.assertEquals((long)this.junitBook.getIsdn(), (long)jsonValue.getElement("book").getElement("isdn").getLongValue());
        JsonGeneratorTest.assertEquals((boolean)this.junitBook.getDelivery(), (boolean)jsonValue.getElement("book").getElement("delivery").getBooleanValue());
        JsonGeneratorTest.assertEquals((boolean)this.junitBook.isAvailability(), (boolean)jsonValue.getElement("book").getElement("availability").getBooleanValue());
    }

    public void testBeanCollection() throws Exception {
        ArrayList<Book> l = new ArrayList<Book>();
        l.add(this.junitBook);
        l.add(this.csharpBook);
        l.add(this.javaScriptBook);
        BookStorage bookStorage = new BookStorage();
        bookStorage.setBooks(l);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)bookStorage);
        JsonGeneratorTest.assertTrue((boolean)jsonValue.isObject());
        Iterator iterator = jsonValue.getElement("books").getElements();
        JsonGeneratorTest.assertEquals((String)((Book)l.get(0)).getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((String)((Book)l.get(1)).getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
        JsonGeneratorTest.assertEquals((String)((Book)l.get(2)).getTitle(), (String)((JsonValue)iterator.next()).getElement("title").getStringValue());
    }

    public void testBeanMap() throws Exception {
        JavaMapBean mb = new JavaMapBean();
        HashMap<String, Book> m = new HashMap<String, Book>();
        m.put("test", this.junitBook);
        mb.setHashMap(m);
        ArrayList<Book> l = new ArrayList<Book>();
        l.add(this.junitBook);
        l.add(this.csharpBook);
        l.add(this.javaScriptBook);
        HashMap<String, List<Book>> hu = new HashMap<String, List<Book>>();
        hu.put("1", l);
        hu.put("2", l);
        hu.put("3", l);
        mb.setMapList(hu);
        HashMap<String, String> str = new HashMap<String, String>();
        str.put("key1", "value1");
        str.put("key2", "value2");
        str.put("key3", "value3");
        mb.setStrings(str);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)mb);
        JsonGeneratorTest.assertEquals((String)((String)str.get("key2")), (String)jsonValue.getElement("strings").getElement("key2").getStringValue());
        JsonGeneratorTest.assertNotNull((Object)jsonValue.getElement("hashMap"));
        JsonGeneratorTest.assertNotNull((Object)jsonValue.getElement("mapList"));
        JsonGeneratorTest.assertEquals((String)"JUnit in Action", (String)((JsonValue)jsonValue.getElement("mapList").getElement("3").getElements().next()).getElement("title").getStringValue());
    }

    public void testBeanTransientField() throws Exception {
        BeanWithTransientField trBean = new BeanWithTransientField();
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)trBean);
        JsonGeneratorTest.assertEquals((String)"visible", (String)jsonValue.getElement("field").getStringValue());
        JsonGeneratorTest.assertNull((Object)jsonValue.getElement("transientField"));
    }

    public void testBeanEnum() throws Exception {
        BeanWithSimpleEnum be = new BeanWithSimpleEnum();
        be.setName("name");
        be.setCount(StringEnum.TWO);
        be.setCounts(new StringEnum[]{StringEnum.ONE, StringEnum.TWO});
        be.setCountList(Arrays.asList(StringEnum.ONE, StringEnum.TWO, StringEnum.TREE));
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)be);
        JsonGeneratorTest.assertEquals((String)"name", (String)jsonValue.getElement("name").getStringValue());
        JsonGeneratorTest.assertEquals((String)StringEnum.TWO.name(), (String)jsonValue.getElement("count").getStringValue());
        JsonValue countValues = jsonValue.getElement("counts");
        ArrayList<String> tmp = new ArrayList<String>();
        Iterator counts = countValues.getElements();
        while (counts.hasNext()) {
            tmp.add(((JsonValue)counts.next()).getStringValue());
        }
        JsonGeneratorTest.assertEquals((int)2, (int)tmp.size());
        JsonGeneratorTest.assertTrue((boolean)tmp.contains(StringEnum.ONE.name()));
        JsonGeneratorTest.assertTrue((boolean)tmp.contains(StringEnum.TWO.name()));
        JsonValue countListValues = jsonValue.getElement("countList");
        tmp = new ArrayList();
        Iterator counts2 = countListValues.getElements();
        while (counts2.hasNext()) {
            tmp.add(((JsonValue)counts2.next()).getStringValue());
        }
        JsonGeneratorTest.assertEquals((int)3, (int)tmp.size());
        JsonGeneratorTest.assertTrue((boolean)tmp.contains(StringEnum.ONE.name()));
        JsonGeneratorTest.assertTrue((boolean)tmp.contains(StringEnum.TWO.name()));
        JsonGeneratorTest.assertTrue((boolean)tmp.contains(StringEnum.TREE.name()));
    }

    public void testBeanEnumObject() throws Exception {
        BeanWithBookEnum be = new BeanWithBookEnum();
        be.setBook(BookEnum.JUNIT_IN_ACTION);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)be);
        JsonGeneratorTest.assertEquals((String)BookEnum.JUNIT_IN_ACTION.name(), (String)jsonValue.getElement("book").getStringValue());
    }

    public void testBeanClassTransf() throws Exception {
        ClassTransfBean be = new ClassTransfBean();
        be.setKlass(ForTestClass000.class);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)be);
        JsonGeneratorTest.assertEquals((String)ForTestClass000.class.getName(), (String)jsonValue.getElement("klass").getStringValue());
    }

    public static class ForTestClass000 {
    }
}

